/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.container.ContainerEntityBase;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;

public class ContainerGateControl
extends ContainerEntityBase<EntityGate> {
    private static final String OWNER_TAG = "owner";

    public ContainerGateControl(EntityPlayer player, int x, int y, int z) {
        super(player, x);
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(OWNER_TAG, ((EntityGate)this.entity).getOwner().getName());
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("repack")) {
            ((EntityGate)this.entity).repackEntity();
        } else if (tag.func_74764_b(OWNER_TAG)) {
            String owner = tag.func_74779_i(OWNER_TAG);
            ((EntityGate)this.entity).setOwner(owner.isEmpty() ? Owner.EMPTY : new Owner(((EntityGate)this.entity).field_70170_p, tag.func_74779_i(OWNER_TAG)));
            this.refreshGui();
        }
    }

    public void repackGate() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("repack", true);
        this.sendDataToServer(tag);
    }

    public void updateOwner(String newOwner) {
        if (!((EntityGate)this.entity).getOwner().getName().equals(newOwner)) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a(OWNER_TAG, newOwner);
            this.sendDataToServer(tag);
        }
    }
}

