/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.config.ModConfiguration;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;

public class AWStructureStatics
extends ModConfiguration {
    public static Set<String> lootTableExclusions;
    public static boolean processScannerCommands;
    public static String templateExtension;
    public static String townTemplateExtension;
    public static boolean enableWorldGen;
    public static boolean enableTownGeneration;
    public static boolean enableStructureGeneration;
    public static boolean loadDefaultPack;
    public static int clusterValueSearchRange;
    public static int duplicateStructureSearchRange;
    public static int maxClusterValue;
    public static float randomGenerationChance;
    public static int spawnProtectionRange;
    public static int townClosestDistance;
    public static float townGenerationChance;
    public static Set<String> excludedSpawnerEntities;
    private static HashSet<String> skippableWorldGenBlocks;
    private static HashSet<String> worldGenTargetBlocks;
    private static HashSet<String> scannerSkippedBlocks;
    private static final String worldGenCategory = "a_world-gen_settings";
    private static final String villageGenCategory = "b_village-gen_settings";
    private static final String excludedEntitiesCategory = "c_excluded_spawner_entities";
    private static final String worldGenBlocks = "d_world_gen_skippable_blocks";
    private static final String targetBlocks = "e_world_gen_target_blocks";
    private static final String scanSkippedBlocks = "f_scanner_skipped_blocks";
    private static final String excludedLootTables = "g_excluded_loot_tables";

    public AWStructureStatics(String mod) {
        super(mod);
    }

    @Override
    public void initializeCategories() {
        this.config.addCustomCategoryComment(worldGenCategory, "Settings that effect all world-structure-generation.");
        this.config.addCustomCategoryComment(villageGenCategory, "Settings that effect the generation of vanilla villages.\nCurrently there are no village-generation options, and no structures will generate in villages.");
        this.config.addCustomCategoryComment(excludedEntitiesCategory, "Entities that will not show up in the Mob Spawner Placer entity selection list.\nAdd any mobs here that will crash if spawned via the vanilla mob-spawner (usually complex NBT-defined entities).");
        this.config.addCustomCategoryComment(worldGenBlocks, "Blocks that should be skipped/ignored during world gen -- should list all plant blocks/logs/foliage");
        this.config.addCustomCategoryComment(targetBlocks, "List of target blocks that structures and towns can spawn on in addition to materials that are automatically whitelisted.");
        this.config.addCustomCategoryComment(scanSkippedBlocks, "List of blocks that the structure scanner will completely ignore.\nWhenever these blocks are encountered the template will instead fill that block position with a hard-air rule.\nAdd any blocks to this list that may cause crashes when scanned or duplicated.\nVanilla blocks should not need to be added, but some mod-blocks may.\nBlock names must be specified by fully-qualified name (e.g. \"minecraft:chests/stronghold_corridor\")");
        this.config.addCustomCategoryComment(excludedLootTables, "List of loot tables that should be excluded from loot chest placer GUI.\nLoot table names must be specified by fully-qualified name (e.g. \"minecraft:stone\")");
    }

    @Override
    protected void initializeValues() {
        templateExtension = this.config.get(worldGenCategory, "template_extension", "aws", "Default=" + templateExtension + "\nThe template extension used when looking for and exporting templates.\nOnly files matching this extension will be examined.").getString();
        enableStructureGeneration = this.config.get(worldGenCategory, "enable_structure_generation", enableStructureGeneration, "Default=" + enableStructureGeneration + "\nEnable or disable structure (not town) generation.").getBoolean(enableStructureGeneration);
        enableTownGeneration = this.config.get(worldGenCategory, "enable_town_generation", enableTownGeneration, "Default=" + enableTownGeneration + "\nEnable or disable custom town generation e.g. walls and additional buildings.").getBoolean(enableTownGeneration);
        loadDefaultPack = this.config.get(worldGenCategory, "load_default_structure_pack", loadDefaultPack, "If true the default structure pack will be loaded and enabled for world-gen.").getBoolean(loadDefaultPack);
        duplicateStructureSearchRange = this.config.get(worldGenCategory, "validation_duplicate_search_radius", duplicateStructureSearchRange, "Default=" + duplicateStructureSearchRange + "\nThe minimum radius in chunks to be searched for duplicate structures.\nThis setting should generally not need to be adjusted unless you have templates with extremely\nlarge 'minDuplicateDistance' values\nExtremely large values may introduce extra lag during generation.  Lower values may reduce lag during generation,\nat the cost of some accuracy in the min duplicate distance tests.").getInt(duplicateStructureSearchRange);
        clusterValueSearchRange = this.config.get(worldGenCategory, "validation_cluster_value_search_radius", clusterValueSearchRange, "Default=" + clusterValueSearchRange + "\nThe minimum radius in chunks to be searched for structures when tallying cluster value in an area.\nThis setting should be adjusted along with maxClusterValue and the clusterValue in templates to encourage\nor discourage specific structures to generate near eachother.\nExtremely large values may introduce extra lag during generation.  Lower values may reduce lag during generation,\nat the cost of some accuracy in the cluster value tests.").getInt(clusterValueSearchRange);
        maxClusterValue = this.config.get(worldGenCategory, "max_cluster_value", maxClusterValue, "Default=" + maxClusterValue + "\nThe maximum allowed cluster value that may be present inside of 'validation_chunk_radius'.\n").getInt(maxClusterValue);
        randomGenerationChance = (float)this.config.get(worldGenCategory, "random_generation_chance", (double)randomGenerationChance, "Default=" + randomGenerationChance + "\nAccepts values between 0 and 1.\nDetermines the chance that a structure will attempt to be generated in any given chunk.\nNumber is specified as a percentage -- e.g. 0.75 == 75% chance to attempt generation.\nHigher values will result in more attempts to generate structures.  Actual number\ngenerated will depend upon your specific templates and their validation settings.\nValues of 0 or lower will result in no structures generating.  Values higher than 1\nwill result in a generation attempt in every chunk.").getDouble((double)randomGenerationChance);
        spawnProtectionRange = this.config.get(worldGenCategory, "spawn_protection_chunk_radius", spawnProtectionRange, "Default=" + spawnProtectionRange + "\nDetermines the area around the central spawn coordinate that will be excluded from random structure generation.\nLarger values will see a larger area around spawn that is devoid of structures.").getInt(spawnProtectionRange);
        enableWorldGen = this.config.get("02_server_settings", "enable_world_generation", enableWorldGen, "Default=" + enableWorldGen + "\nEnable or disable world generation entirely. If disabled, all other options will have no effect.").getBoolean(enableWorldGen);
        townClosestDistance = this.config.get(worldGenCategory, "town_min_distance", townClosestDistance, "Default=" + townClosestDistance + "\nMinimum distance between towns.  This should be set to a value quite a bit larger than the largest townthat you have configured for generation.  E.G.  Max town size=16, this value should be >= 40.").getInt(townClosestDistance);
        townGenerationChance = (float)this.config.get(worldGenCategory, "town_generation_chance", (double)townGenerationChance, "Default=" + townGenerationChance + "\nAccepts values between 0 and 1.0.  Decimal percent chance to -attempt- town generation for any given chunk.  Higher settings may result inmore towns being generated, but may come with a performance hit during new chunk generation.  Lower values WILL result in fewer towns, and-may- improve performance during chunk generation.").getDouble((double)townGenerationChance);
        this.initializeDefaultSkippableBlocks();
        this.initializeDefaultSkippedEntities();
        this.initializeDefaultTargetBlocks();
        this.initializeScannerSkippedBlocks();
        lootTableExclusions = new HashSet<String>(Arrays.asList(this.config.get(excludedLootTables, "excluded_loot_tables", new String[]{"primitivemobs:entities/chameleon", "minecraft:entities/ocelot", "minecraft:entities/silverfish", "minecraft:entities/llama", "twilightforest:entities/death_tome_hurt", "twilightforest:entities/yeti", "twilightforest:entities/mini_ghast", "twilightforest:entities/snow_guardian", "minecraft:entities/sheep/brown", "minecraft:entities/vex", "minecraft:entities/elder_guardian", "minecolonies:entityarcherbarbariandrops", "minecraft:entities/creeper", "primitivemobs:entities/mimic", "primitivemobs:entities/lily_lurker", "minecraft:entities/sheep/red", "twilightforest:entities/questing_ram_rewards", "twilightforest:entities/fire_beetle", "twilightforest:entities/redcap", "minecraft:entities/horse", "minecraft:entities/slime", "twilightforest:entities/bunny", "minecraft:entities/ghast", "minecraft:entities/zombie", "exoticbirds:birds/woodpecker", "minecraft:entities/sheep/silver", "twilightforest:entities/ice_crystal", "minecraft:entities/mushroom_cow", "minecolonies:entitychiefbarbariandrops", "exoticbirds:birds/toucan", "minecraft:entities/sheep/white", "exoticbirds:birds/hummingbird", "exoticbirds:birds/bluejay", "exoticbirds:birds/roadrunner", "minecraft:entities/sheep/cyan", "minecraft:entities/zombie_pigman", "minecraft:entities/cow", "minecraft:entities/pig", "exoticbirds:birds/heron", "exoticbirds:birds/peahen", "exoticbirds:birds/peacock", "exoticbirds:birds/cardinal", "exoticbirds:birds/duck", "exoticbirds:birds/ostrich", "minecraft:entities/stray", "exoticbirds:birds/gouldianfinch", "minecraft:entities/sheep/magenta", "exoticbirds:birds/cassowary", "primitivemobs:entities/blazing_juggernaut", "minecraft:gameplay/fishing/fish", "twilightforest:entities/winter_wolf", "minecraft:gameplay/fishing/junk", "minecraft:entities/donkey", "twilightforest:entities/tower_termite", "twilightforest:entities/goblin_knight", "exoticbirds:birds/kiwi", "ebwizardry:entities/evil_wizard", "exoticbirds:dungeon_phoenix", "minecraft:entities/villager", "minecraft:entities/spider", "twilightforest:entities/ice_exploder", "exoticbirds:birds/seagull", "minecraft:entities/zombie_horse", "minecraft:entities/sheep/yellow", "minecraft:entities/sheep/black", "primitivemobs:chests/mimic_trap", "twilightforest:entities/hydra", "exoticbirds:birds/pigeon", "twilightforest:entities/minoshroom", "minecraft:entities/magma_cube", "minecraft:entities/sheep/pink", "twilightforest:entities/death_tome", "minecraft:entities/mule", "familiarfauna:entities/butterfly", "twilightforest:entities/armored_giant", "minecraft:entities/endermite", "minecraft:entities/bat", "minecraft:gameplay/fishing", "familiarfauna:entities/turkey", "silentgems:ender_slime", "primitivemobs:entities/festive_creeper", "exoticbirds:birds/kingfisher", "minecraft:entities/evocation_illager", "primitivemobs:entities/special/filch_lizard_steal", "minecraft:entities/witch", "minecraft:entities/skeleton_horse", "minecraft:entities/zombie_villager", "twilightforest:entities/ice_shooter", "twilightforest:entities/block_goblin", "exoticbirds:birds/kookaburra", "minecraft:entities/guardian", "primitivemobs:entities/special/haunted_tool", "twilightforest:entities/wraith", "familiarfauna:entities/snail", "minecraft:entities/blaze", "minecraft:entities/sheep", "minecraft:entities/sheep/orange", "exoticbirds:birds/owl", "twilightforest:entities/snow_queen", "twilightforest:entities/minotaur", "twilightforest:entities/yeti_alpha", "exoticbirds:birds/crane", "minecraft:entities/sheep/lime", "twilightforest:entities/naga", "exoticbirds:birds/swan", "minecraft:empty", "exoticbirds:birds/parrot", "exoticbirds:birds/flamingo", "primitivemobs:entities/rocket_creeper", "familiarfauna:entities/deer", "twilightforest:entities/raven", "minecraft:entities/chicken", "twilightforest:entities/giant_miner", "minecolonies:entitybarbariandrops", "exoticbirds:birds/vulture", "twilightforest:entities/skeleton_druid", "exoticbirds:birds/penguin", "familiarfauna:entities/pixie", "minecraft:entities/sheep/light_blue", "minecraft:entities/wolf", "minecraft:entities/skeleton", "primitivemobs:entities/support_creeper", "minecraft:entities/enderman", "primitivemobs:entities/dodo", "minecraft:entities/squid", "minecraft:entities/shulker", "twilightforest:entities/deer", "twilightforest:entities/troll", "exoticbirds:birds/pelican", "minecraft:entities/cave_spider", "minecraft:entities/sheep/green", "twilightforest:entities/tower_golem", "minecraft:entities/wither_skeleton", "minecraft:entities/snowman", "minecraft:entities/sheep/blue", "familiarfauna:entities/dragonfly", "minecraft:entities/rabbit", "twilightforest:entities/helmet_crab", "twilightforest:entities/bird", "twilightforest:entities/slime_beetle", "twilightforest:entities/maze_slime", "minecraft:entities/polar_bear", "minecraft:entities/ender_dragon", "twilightforest:entities/kobold", "exoticbirds:birds/phoenix", "minecraft:entities/parrot", "minecraft:entities/sheep/gray", "twilightforest:entities/lich", "exoticbirds:birds/lyrebird", "exoticbirds:birds/booby", "minecraft:entities/vindication_illager", "exoticbirds:birds/magpie", "minecraft:entities/husk", "minecraft:entities/sheep/purple", "minecraft:entities/giant", "primitivemobs:entities/special/filch_lizard_spawn", "minecraft:entities/iron_golem"}).getStringList()));
    }

    private void initializeScannerSkippedBlocks() {
        String[] defaultSkippableBlocks = new String[]{"AncientWarfareStructure:gate_proxy"};
        defaultSkippableBlocks = this.config.getStringList("scanner_skipped_blocks", scanSkippedBlocks, defaultSkippableBlocks, "Blocks TO be skipped by structure scanner");
        Collections.addAll(scannerSkippedBlocks, defaultSkippableBlocks);
    }

    private void initializeDefaultSkippableBlocks() {
        String[] defaultSkippableBlocks = new String[]{"BiomesOPlenty:appleLeaves", "BiomesOPlenty:ash", "BiomesOPlenty:bamboo", "BiomesOPlenty:bones", "BiomesOPlenty:colorizedLeaves1", "BiomesOPlenty:colorizedLeaves2", "BiomesOPlenty:colorizedSaplings", "BiomesOPlenty:coral1", "BiomesOPlenty:coral2", "BiomesOPlenty:crystal", "BiomesOPlenty:flowers", "BiomesOPlenty:flowers2", "BiomesOPlenty:flowerVine", "BiomesOPlenty:foliage", "BiomesOPlenty:gemOre", "BiomesOPlenty:grave", "BiomesOPlenty:hardIce", "BiomesOPlenty:hardSand", "BiomesOPlenty:hell_blood", "BiomesOPlenty:hive", "BiomesOPlenty:honey", "BiomesOPlenty:honeyBlock", "BiomesOPlenty:ivy", "BiomesOPlenty:leaves1", "BiomesOPlenty:leaves2", "BiomesOPlenty:leaves3", "BiomesOPlenty:leaves4", "BiomesOPlenty:logs1", "BiomesOPlenty:logs2", "BiomesOPlenty:logs3", "BiomesOPlenty:logs4", "BiomesOPlenty:longGrass", "BiomesOPlenty:moss", "BiomesOPlenty:mud", "BiomesOPlenty:mudBricks", "BiomesOPlenty:mushrooms", "BiomesOPlenty:overgrownNetherrack", "BiomesOPlenty:palmStairs", "BiomesOPlenty:persimmonLeaves", "BiomesOPlenty:petals", "BiomesOPlenty:plants", "BiomesOPlenty:poison", "BiomesOPlenty:rocks", "BiomesOPlenty:saplings", "BiomesOPlenty:stoneFormations", "BiomesOPlenty:treeMoss", "BiomesOPlenty:turnip", "BiomesOPlenty:willow", "BiomesOPlenty:wisteria", "bonecraft:Fossil", "coralmod:Coral1", "coralmod:Coral2", "coralmod:Coral3", "coralmod:Coral4", "coralmod:Coral5", "ExtrabiomesXL:cornerlog_baldcypress", "ExtrabiomesXL:cornerlog_fir", "ExtrabiomesXL:cornerlog_oak", "ExtrabiomesXL:cornerlog_rainboweucalyptus", "ExtrabiomesXL:cornerlog_redwood", "ExtrabiomesXL:double_slabRedRock", "ExtrabiomesXL:double_woodslab", "ExtrabiomesXL:double_woodslab2", "ExtrabiomesXL:flower1", "ExtrabiomesXL:flower2", "ExtrabiomesXL:flower3", "ExtrabiomesXL:grass", "ExtrabiomesXL:leaf_pile", "ExtrabiomesXL:leaves_1", "ExtrabiomesXL:leaves_2", "ExtrabiomesXL:leaves_3", "ExtrabiomesXL:leaves_4", "ExtrabiomesXL:log_elbow_baldcypress", "ExtrabiomesXL:log_elbow_rainbow_eucalyptus", "ExtrabiomesXL:log1", "ExtrabiomesXL:log2", "ExtrabiomesXL:mini_log_1", "ExtrabiomesXL:plants4", "ExtrabiomesXL:saplings_1", "ExtrabiomesXL:saplings_2", "ExtrabiomesXL:terrain_blocks1", "ExtrabiomesXL:terrain_blocks2", "ExtrabiomesXL:tile.extrabiomes.crop.strawberry", "ExtrabiomesXL:vines", "ExtrabiomesXL:waterplant1", "extvil:DecoSand", "extvil:SmoothSand", "GraveStone:GSAltar", "GraveStone:GSBoneBlock", "GraveStone:GSBoneSlab", "GraveStone:GSBoneStairs", "GraveStone:GSCandle", "GraveStone:GSGraveStone", "GraveStone:GSHauntedChest", "GraveStone:GSMemorial", "GraveStone:GSSkullCandle", "GraveStone:GSSpawner", "GraveStone:GSTrap", "harvestcraft:apiary", "harvestcraft:beehive", "harvestcraft:berrygarden", "harvestcraft:desertgarden", "harvestcraft:gourdgarden", "harvestcraft:grassgarden", "harvestcraft:groundgarden", "harvestcraft:herbgarden", "harvestcraft:leafygarden", "harvestcraft:market", "harvestcraft:mushroomgarden", "harvestcraft:pamAlmond", "harvestcraft:pamalmondSapling", "harvestcraft:pamApple", "harvestcraft:pamappleSapling", "harvestcraft:pamApricot", "harvestcraft:pamapricotSapling", "harvestcraft:pamartichokeCrop", "harvestcraft:pamasparagusCrop", "harvestcraft:pamAvocado", "harvestcraft:pamavocadoSapling", "harvestcraft:pambambooshootCrop", "harvestcraft:pamBanana", "harvestcraft:pambananaSapling", "harvestcraft:pambarleyCrop", "harvestcraft:pambeanCrop", "harvestcraft:pambeetCrop", "harvestcraft:pambellpepperCrop", "harvestcraft:pamblackberryCrop", "harvestcraft:pamblueberryCrop", "harvestcraft:pambroccoliCrop", "harvestcraft:pambrusselsproutCrop", "harvestcraft:pamcabbageCrop", "harvestcraft:pamcactusfruitCrop", "harvestcraft:pamcandleberryCrop", "harvestcraft:pamcantaloupeCrop", "harvestcraft:pamCashew", "harvestcraft:pamcashewSapling", "harvestcraft:pamcauliflowerCrop", "harvestcraft:pamceleryCrop", "harvestcraft:pamCherry", "harvestcraft:pamcherrySapling", "harvestcraft:pamChestnut", "harvestcraft:pamchestnutSapling", "harvestcraft:pamchilipepperCrop", "harvestcraft:pamCinnamon", "harvestcraft:pamcinnamonSapling", "harvestcraft:pamCoconut", "harvestcraft:pamcoconutSapling", "harvestcraft:pamcoffeebeanCrop", "harvestcraft:pamcornCrop", "harvestcraft:pamcottonCrop", "harvestcraft:pamcranberryCrop", "harvestcraft:pamcucumberCrop", "harvestcraft:pamDate", "harvestcraft:pamdateSapling", "harvestcraft:pamDragonfruit", "harvestcraft:pamdragonfruitSapling", "harvestcraft:pamDurian", "harvestcraft:pamdurianSapling", "harvestcraft:pameggplantCrop", "harvestcraft:pamFig", "harvestcraft:pamfigSapling", "harvestcraft:pamgarlicCrop", "harvestcraft:pamgingerCrop", "harvestcraft:pamgrapeCrop", "harvestcraft:pamGrapefruit", "harvestcraft:pamgrapefruitSapling", "harvestcraft:pamkiwiCrop", "harvestcraft:pamleekCrop", "harvestcraft:pamLemon", "harvestcraft:pamlemonSapling", "harvestcraft:pamlettuceCrop", "harvestcraft:pamLime", "harvestcraft:pamlimeSapling", "harvestcraft:pamMaple", "harvestcraft:pammapleSapling", "harvestcraft:pamMango", "harvestcraft:pammangoSapling", "harvestcraft:pammustardseedsCrop", "harvestcraft:pamNutmeg", "harvestcraft:pamnutmegSapling", "harvestcraft:pamoatsCrop", "harvestcraft:pamokraCrop", "harvestcraft:pamOlive", "harvestcraft:pamoliveSapling", "harvestcraft:pamonionCrop", "harvestcraft:pamOrange", "harvestcraft:pamorangeSapling", "harvestcraft:pamPapaya", "harvestcraft:pampapayaSapling", "harvestcraft:pamPaperbark", "harvestcraft:pampaperbarkSapling", "harvestcraft:pamparsnipCrop", "harvestcraft:pamPeach", "harvestcraft:pampeachSapling", "harvestcraft:pampeanutCrop", "harvestcraft:pamPear", "harvestcraft:pampearSapling", "harvestcraft:pampeasCrop", "harvestcraft:pamPecan", "harvestcraft:pampecanSapling", "harvestcraft:pamPeppercorn", "harvestcraft:pampeppercornSapling", "harvestcraft:pamPersimmon", "harvestcraft:pampersimmonSapling", "harvestcraft:pampineappleCrop", "harvestcraft:pamPistachio", "harvestcraft:pampistachioSapling", "harvestcraft:pamPlum", "harvestcraft:pamplumSapling", "harvestcraft:pamPomegranate", "harvestcraft:pampomegranateSapling", "harvestcraft:pamradishCrop", "harvestcraft:pamraspberryCrop", "harvestcraft:pamrhubarbCrop", "harvestcraft:pamriceCrop", "harvestcraft:pamrutabagaCrop", "harvestcraft:pamryeCrop", "harvestcraft:pamscallionCrop", "harvestcraft:pamseaweedCrop", "harvestcraft:pamsoybeanCrop", "harvestcraft:pamspiceleafCrop", "harvestcraft:pamStarfruit", "harvestcraft:pamstarfruitSapling", "harvestcraft:pamstrawberryCrop", "harvestcraft:pamsweetpotatoCrop", "harvestcraft:pamtealeafCrop", "harvestcraft:pamtomatoCrop", "harvestcraft:pamturnipCrop", "harvestcraft:pamVanillabean", "harvestcraft:pamvanillabeanSapling", "harvestcraft:pamWalnut", "harvestcraft:pamwalnutSapling", "harvestcraft:pamwhitemushroomCrop", "harvestcraft:pamwintersquashCrop", "harvestcraft:pamzucchiniCrop", "harvestcraft:stalkgarden", "harvestcraft:textilegarden", "harvestcraft:tropicalgarden", "harvestcraft:watergarden", "Highlands:Fir Sapling", "Highlands:hl_cocoa", "Highlands:tile.hl_acaciaLeaves", "Highlands:tile.hl_acaciaSapling", "Highlands:tile.hl_acaciaWood", "Highlands:tile.hl_ashLeaves", "Highlands:tile.hl_ashSapling", "Highlands:tile.hl_ashWood", "Highlands:tile.hl_autumnOrangeLeaves", "Highlands:tile.hl_autumnOrangeSapling", "Highlands:tile.hl_autumnYellowLeaves", "Highlands:tile.hl_autumnYellowSapling", "Highlands:tile.hl_beechSapling", "Highlands:tile.hl_blueberryBush", "Highlands:tile.hl_blueFlower", "Highlands:tile.hl_canopyLeaves", "Highlands:tile.hl_canopySapling", "Highlands:tile.hl_canopyWood", "Highlands:tile.hl_cattail", "Highlands:tile.hl_cotton", "Highlands:tile.hl_deadSapling", "Highlands:tile.hl_decBushSapling", "Highlands:tile.hl_evgBushSapling", "Highlands:tile.hl_firLeaves", "Highlands:tile.hl_firWood", "Highlands:tile.hl_greatOakSapling", "Highlands:tile.hl_ironwoodLeaves", "Highlands:tile.hl_ironwoodSapling", "Highlands:tile.hl_ironwoodWood", "Highlands:tile.hl_japaneseMapleLeaves", "Highlands:tile.hl_japaneseMapleSapling", "Highlands:tile.hl_japaneseMapleWood", "Highlands:tile.hl_lavender", "Highlands:tile.hl_leafyFern", "Highlands:tile.hl_mangroveLeaves", "Highlands:tile.hl_mangroveSapling", "Highlands:tile.hl_mangroveWood", "Highlands:tile.hl_palmLeaves", "Highlands:tile.hl_palmSapling", "Highlands:tile.hl_palmWood", "Highlands:tile.hl_poplarLeaves", "Highlands:tile.hl_poplarSapling", "Highlands:tile.hl_poplarWood", "Highlands:tile.hl_raspberryBush", "Highlands:tile.hl_redwoodLeaves", "Highlands:tile.hl_redwoodSapling", "Highlands:tile.hl_redwoodWood", "Highlands:tile.hl_thornbush", "Highlands:tile.hl_whiteFlower", "lotr:tile.lotr:berryBush", "lotr:tile.lotr:bluebell", "lotr:tile.lotr:clover", "lotr:tile.lotr:deadMarshPlant", "lotr:tile.lotr:doubleFlower", "lotr:tile.lotr:fallenLeaves", "lotr:tile.lotr:fallenLeavesLOTR", "lotr:tile.lotr:fallenLeavesLOTR2", "lotr:tile.lotr:fangornPlant", "lotr:tile.lotr:fangornRiverweed", "lotr:tile.lotr:flaxPlant", "lotr:tile.lotr:fruitLeaves", "lotr:tile.lotr:fruitSapling", "lotr:tile.lotr:fruitWood", "lotr:tile.lotr:haradFlower", "lotr:tile.lotr:leaves", "lotr:tile.lotr:leaves2", "lotr:tile.lotr:leaves3", "lotr:tile.lotr:leaves4", "lotr:tile.lotr:lettuce", "lotr:tile.lotr:mordorMoss", "lotr:tile.lotr:mordorThorn", "lotr:tile.lotr:morgulShroom", "lotr:tile.lotr:pipeweedPlant", "lotr:tile.lotr:rottenLog", "lotr:tile.lotr:sapling", "lotr:tile.lotr:sapling2", "lotr:tile.lotr:sapling3", "lotr:tile.lotr:sapling4", "lotr:tile.lotr:shireHeather", "lotr:tile.lotr:simbelmyne", "lotr:tile.lotr:stalactite", "lotr:tile.lotr:tallGrass", "lotr:tile.lotr:termiteMound", "lotr:tile.lotr:wood", "lotr:tile.lotr:wood2", "lotr:tile.lotr:wood3", "lotr:tile.lotr:wood4", "mam:mam_dendroidsapling", "mam:mam_fairymushroom", "mam:mam_mamdendroidspawner", "Metallurgy:base.ore", "Metallurgy:ender.ore", "Metallurgy:fantasy.ore", "Metallurgy:nether.ore", "Metallurgy:precious.ore", "Metallurgy:utility.ore", "minecraft:air", "minecraft:brown_mushroom", "minecraft:brown_mushroom_block", "minecraft:cactus", "minecraft:clay", "minecraft:cobblestone", "minecraft:cocoa", "minecraft:deadbush", "minecraft:double_plant", "minecraft:flowing_lava", "minecraft:flowing_water", "minecraft:ice", "minecraft:leaves", "minecraft:leaves2", "minecraft:log", "minecraft:log2", "minecraft:melon_block", "minecraft:melon_stem", "minecraft:packed_ice", "minecraft:pumpkin", "minecraft:pumpkin_stem", "minecraft:red_flower", "minecraft:red_mushroom", "minecraft:red_mushroom_block", "minecraft:reeds", "minecraft:sapling", "minecraft:skull", "minecraft:snow", "minecraft:snow_layer", "minecraft:sponge", "minecraft:tallgrass", "minecraft:vine", "minecraft:waterlily", "minecraft:web", "minecraft:yellow_flower", "MineFactoryReloaded:tile.mfr.rubberwood.leaves", "MineFactoryReloaded:tile.mfr.rubberwood.log", "MoCreatures:MoCLeaves", "MoCreatures:MoCLog", "MoCreatures:MoCTallGrass", "ProjectZulu|Core:aloevera", "ProjectZulu|Core:coconut", "ProjectZulu|Core:creeperblossom", "ProjectZulu|Core:mobskulls", "ProjectZulu|Core:nightbloom", "ProjectZulu|Core:palmtreeleaves", "ProjectZulu|Core:palmtreelog", "ProjectZulu|Core:palmtreesapling", "ProjectZulu|Core:quicksand", "ProjectZulu|Core:spikes", "ProjectZulu|Core:tumbleweed", "ProjectZulu|Core:watereddirt", "TwilightForest:tile.DarkLeaves", "TwilightForest:tile.TFBurntThorns", "TwilightForest:tile.TFCicada", "TwilightForest:tile.TFDeadrock", "TwilightForest:tile.TFFirefly", "TwilightForest:tile.TFLeaves", "TwilightForest:tile.TFLeaves3", "TwilightForest:tile.TFLog", "TwilightForest:tile.TFMagicLeaves", "TwilightForest:tile.TFMagicLog", "TwilightForest:tile.TFMagicLogSpecial", "TwilightForest:tile.TFMoonworm", "TwilightForest:tile.TFPlant", "TwilightForest:tile.TFRoots", "TwilightForest:tile.TFSapling", "TwilightForest:tile.TFThorns", "TwilightForest:tile.TFThornRose", "wildcaves3:Decorations", "wildcaves3:Flora", "wildcaves3:FossilBlock", "wildcaves3:SandstoneSalactite", "wildcaves3:StoneStalactite", "witchery:artichoke", "witchery:belladonna", "witchery:bloodrose", "witchery:bramble", "witchery:brazier", "witchery:crittersnare", "witchery:embermoss", "witchery:glintweed", "witchery:leapinglily", "witchery:mandrake", "witchery:mindrake", "witchery:plantmine", "witchery:snowbell", "witchery:somniancotton", "witchery:spanishmoss", "witchery:stockade", "witchery:voidbramble", "witchery:witchleaves", "witchery:witchlog", "witchery:witchsapling", "witchery:wormwood"};
        defaultSkippableBlocks = this.config.get(worldGenBlocks, "skippable_blocks", defaultSkippableBlocks).getStringList();
        Collections.addAll(skippableWorldGenBlocks, defaultSkippableBlocks);
    }

    public static void logSkippableBlocksCoveredByMaterial() {
        skippableWorldGenBlocks.stream().filter(b -> AWStructureStatics.getBlock(b).isPresent() && AWStructureStatics.isSkippableMaterial(AWStructureStatics.getBlock(b).get().func_176223_P().func_185904_a())).forEach(b -> AncientWarfareStructure.LOG.info("Block {} defined as skippable is redundant as its material is already skipped by default", b));
    }

    private static Optional<Block> getBlock(String registryName) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName));
        return block == Blocks.field_150350_a ? Optional.empty() : Optional.ofNullable(block);
    }

    private void initializeDefaultSkippedEntities() {
        String[] defaultExcludedEntities = new String[]{"ancientwarfarestructure:aw_gate", "Arrow", "awger_Hoy.EntityHoy", "awer_Punt.EntityPunt", "awger_SmallBoat.EntityBoatChest", "awger_SmallBoat.EntityBoatPart", "awger_SmallBoat.EntitySmallBoat", "awger_Whitehall.EntityWhitehall", "BiblioCraft.SeatEntity", "BiomesOPlenty.dart", "BiomesOPlenty.mudball", "BiomesOPlenty.PoisonDart", "BladeTrap", "Boat", "Cannon", "cfm.MountableBlock", "chocolateQuest.Beam", "chocolateQuest.ChocoProjectile", "chocolateQuest.CQ_npc", "chocolateQuest.dummy", "chocolateQuest.EntityPart", "chocolateQuest.EntityPartRidable", "chocolateQuest.EntityPartSlime", "chocolateQuest.Hookshoot", "CustomNpcChairMount", "DemonMobs.DemonicBlast", "DemonMobs.DemonicSpark", "DemonMobs.Doomfireball", "DemonMobs.Hellfireball", "DesertMobs.Mudshot", "DesertMobs.ThrowingScythe", "EnderCrystal", "EnderDragon", "ExtrabiomesXL.scarecrow", "EyeOfEnderSignal", "EyeRay", "FallingSand", "Fireball", "FireworksRocketEntity", "goblin.Arcaneball", "goblin.Bomb", "goblin.ETNTPrimed", "goblin.GArcanebal", "goblin.Lightball", "goblin.MTNTPrimed", "goblin.orbB", "goblin.orbG", "goblin.orbR", "goblin.orbY", "hoy.Hoy", "Item", "ItemFrame", "JungleMobs.ConcapedeSegment", "KoadPirates.Cannon Ball", "KoadPirates.Net", "KoadPirates.Shot", "KoadPirates.Tether", "LeashKnot", "lom_DirtPile", "lotr.Banner", "lotr.Barrel", "lotr.Conker", "lotr.CrossbowBolt", "lotr.GandalfFireball", "lotr.InvasionSpawner", "lotr.LOTRTNT", "lotr.MysteryWeb", "lotr.OrcBomb", "lotr.Pebble", "lotr.Plate", "lotr.Portal", "lotr.SmokeRing", "lotr.Spear", "lotr.ThrowingAxe", "lotr.ThrownRock", "lotr.ThrownTermite", "lotr.TraderRespawn", "lotr.WallBanner", "lotr.WargRug", "MagicMissile", "mam.firebreath", "mam.goldarrow", "mam.kitsune", "mam.music", "mam.stick", "Metallurgy3Base.LargeTNTEntity", "Metallurgy3Base.MinersTNTEntity", "MinecartChest", "MinecartCommandBlock", "MinecartFurnace", "MinecartHopper", "MinecartRideable", "MinecartSpawner", "MinecartTNT", "minecolonies.arrow", "minecolonies.baker", "minecolonies.blacksmith", "minecolonies.builder", "minecolonies.citizen", "minecolonies.deliveryman", "minecolonies.farmer", "minecolonies.huntersdog", "minecolonies.miner", "minecolonies.pointer", "minecolonies.soldier", "minecolonies.stonemason", "minecolonies.stonemason", "Mob", "MoCreatures.Egg", "MoCreatures.FishBowl", "MoCreatures.KittyBed", "MoCreatures.LitterBox", "MoCreatures.MoCPlatform", "MoCreatures.PetScorpion", "MoCreatures.TRock", "Monster", "npccrystal", "NpcDragon", "npcdwarffemale", "npcdwarfmale", "npcelffemale", "npcelfmale", "npcenderchibi", "npcEnderman", "npcfurryfemale", "npcfurrymale", "npcGolem", "npchumanfemale", "npchumanmale", "npcnagafemale", "npcnagamale", "npcorcfemale", "npcorcmale", "npcpony", "npcskeleton", "NpcSlime", "npcvillager", "npczombiefemale", "npczombiemale", "Painting", "Paleocraft.Bladeking68", "Petrified", "PrimedTnt", "primitivemobs.Ball", "primitivemobs.Lily", "primitivemobs.SpawnEgg", "ProjectZulu|Core.CreeperBlossomPrimed", "ProjectZulu|Core.DuckEgg", "ProjectZulu|Core.Follower", "ProjectZulu|Core.Lizard Spit", "ProjectZulu|Core.OstrichEgg", "ProjectZulu|Core.ThrowingRock", "punt.Punt", "RakshasaImage", "RopesPlus.ConfusingArrow", "RopesPlus.DirtArrow", "RopesPlus.ExplodingArrow", "RopesPlus.FireArrow", "RopesPlus.FreeFormRope", "RopesPlus.FrostArrow", "RopesPlus.GrapplingHook", "RopesPlus.PenetratingArrow", "RopesPlus.RedstonetorchArrow", "RopesPlus.RopeArrow", "RopesPlus.SeedArrow", "RopesPlus.SlimeArrow", "RopesPlus.TorchArrow", "RopesPlus.WarpArrow", "smallboats.EntityBoatChest", "smallboats.EntityBoatGun", "smallboats.EntityBoatPart", "smallboats.EntitySmallBoat", "SmallFireball", "Snowball", "SonicBoom", "SwampMobs.PoisonRay", "SwampMobs.PoisonRayEnd", "SwampMobs.VenomShot", "throwableitem", "ThrownEnderpearl", "ThrownExpBottle", "ThrownPotion", "TwilightForest.tffallingice", "TwilightForest.tflichbolt", "TwilightForest.tflichbomb", "TwilightForest.tfmoonwormshot", "TwilightForest.tfthrownaxe", "TwilightForest.tfthrownice", "TwilightForest.tfthrownpick", "TwilightForest.tfcharmeffect", "TwilightForest.tfhydramortar", "TwilightForest.tfnaturebolt", "TwilightForest.tfslimeblob", "TwilightForest.tftomebolt", "TwilightForest.tftwilightwandbolt", "weaponmod.bolt", "weaponmod.boomerang", "weaponmod.bullet", "weaponmod.cannon", "weaponmod.cannonball", "weaponmod.dart", "weaponmod.dummy", "weaponmod.dynamite", "weaponmod.flail", "weaponmod.javelin", "weaponmod.knife", "weaponmod.shot", "weaponmod.spear", "witchery.bolt", "witchery.brew", "witchery.broom", "witchery.corpse", "witchery.eye", "witchery.familiar", "witchery.goblingulg", "witchery.illusionCreeper", "witchery.illusionSpider", "witchery.illusionZombie", "witchery.mandrake", "witchery.owl", "witchery.soulfire", "witchery.spellEffect", "witchery.spirit", "WitherBoss", "WitherSkull", "XPOrb"};
        defaultExcludedEntities = this.config.get(excludedEntitiesCategory, "excluded_entities", defaultExcludedEntities).getStringList();
        Collections.addAll(excludedSpawnerEntities, defaultExcludedEntities);
    }

    private void initializeDefaultTargetBlocks() {
        String[] defaultTargetBlocks = new String[]{"minecraft:snow", "minecraft:snow_layer", "minecraft:ice", "minecraft:water", "minecraft:clay", "minecraft:mycelium", "minecraft:stone", "minecraft:grass", "minecraft:dirt", "minecraft:sand", "minecraft:gravel", "minecraft:sand", "minecraft:sandstone", "BiomesOPlenty:mud", "BiomesOPlenty:driedDirt", "BiomesOPlenty:rocks", "BiomesOPlenty:ash", "BiomesOPlenty:ashStone", "BiomesOPlenty:hardSand", "BiomesOPlenty:hardDirt", "BiomesOPlenty:biomeBlock", "BiomesOPlenty:crystal", "BiomesOPlenty:gemOre", "BiomesOPlenty:cragRock", "mam:mam_mamgravel", "mam:mam_depthquartz", "mam:mam_depthquartzchiseled", "mam:mam_depthquartzlines", "mam:mam_depthcrystalblock"};
        defaultTargetBlocks = this.config.get("target_blocks", targetBlocks, defaultTargetBlocks, "List of blocks that are valid").getStringList();
        Collections.addAll(worldGenTargetBlocks, defaultTargetBlocks);
    }

    public static boolean isValidTargetBlock(IBlockState state) {
        return AWStructureStatics.isValidTargetMaterial(state.func_185904_a()) || worldGenTargetBlocks.contains(state.func_177230_c().getRegistryName().toString());
    }

    public static boolean isValidTargetMaterial(Material material) {
        return material == Material.field_151577_b || material == Material.field_151578_c || material == Material.field_151576_e || material == Material.field_151597_y || material == Material.field_151588_w || material == Material.field_151598_x || material == Material.field_151595_p || material == Material.field_151586_h;
    }

    public static boolean isSkippable(IBlockState state) {
        return AWStructureStatics.isSkippableMaterial(state.func_185904_a()) || skippableWorldGenBlocks.contains(state.func_177230_c().getRegistryName().toString());
    }

    public static boolean isSkippableMaterial(Material material) {
        return material == Material.field_151579_a || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151584_j || material == Material.field_151575_d || material == Material.field_151572_C || material == Material.field_151570_A;
    }

    public static boolean shouldSkipScan(Block block) {
        return scannerSkippedBlocks.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public static boolean withinProtectionRange(double dist) {
        return dist < (double)(spawnProtectionRange * spawnProtectionRange * 16 * 16);
    }

    static {
        processScannerCommands = false;
        templateExtension = "aws";
        townTemplateExtension = "awt";
        enableWorldGen = true;
        enableTownGeneration = true;
        enableStructureGeneration = true;
        loadDefaultPack = true;
        clusterValueSearchRange = 16;
        duplicateStructureSearchRange = 40;
        maxClusterValue = 500;
        randomGenerationChance = 0.075f;
        spawnProtectionRange = 12;
        townClosestDistance = 40;
        townGenerationChance = 0.125f;
        excludedSpawnerEntities = new HashSet<String>();
        skippableWorldGenBlocks = new HashSet();
        worldGenTargetBlocks = new HashSet();
        scannerSkippedBlocks = new HashSet();
    }
}

