/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockTotemPart;
import net.shadowmage.ancientwarfare.structure.tile.TileTotemPart;

public class BlockTotemPart
extends BlockBaseStructure {
    public static final String VARIANT_TAG = "variant";
    private static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private static final PropertyBool VISIBLE = PropertyBool.func_177716_a((String)"visible");

    public BlockTotemPart() {
        super(Material.field_151575_d, "totem_part");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, VISIBLE, VARIANT});
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        Item item = Item.func_150898_a((Block)this);
        for (Variant variant : Variant.values()) {
            ItemStack stack = new ItemStack(item);
            stack.func_77982_d(new NBTBuilder().setByte(VARIANT_TAG, variant.getId()).build());
            items.add((Object)stack);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)VISIBLE) != false ? super.func_149645_b(state) : EnumBlockRenderType.INVISIBLE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf((meta >> 2 & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)VISIBLE) != false ? 1 : 0) << 2;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return WorldTools.getTile(world, pos, TileTotemPart.class).map(te -> state.func_177226_a(VARIANT, (Comparable)((Object)te.getVariant()))).orElse(state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileTotemPart();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(true));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Variant variant = ItemBlockTotemPart.getVariant(stack);
        WorldTools.getTile((IBlockAccess)world, pos, TileTotemPart.class).ifPresent(te -> te.setVariant(variant));
        variant.placeAdditionalParts(world, pos, placer.func_174811_aO());
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockPos mainPos = WorldTools.getTile((IBlockAccess)world, pos, TileTotemPart.class).filter(t -> t.getMainBlockPos().isPresent()).map(t -> t.getMainBlockPos().get()).orElse(pos);
        if (!mainPos.equals((Object)pos)) {
            world.func_175698_g(mainPos);
        } else {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING);
            WorldTools.getTile((IBlockAccess)world, mainPos, TileTotemPart.class).ifPresent(te -> te.getVariant().getAdditionalPartPositions(mainPos, facing).forEach(additionalPos -> world.func_175656_a(additionalPos, Blocks.field_150350_a.func_176223_P())));
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ResourceLocation baseLocation = new ResourceLocation("ancientwarfare", "structure/" + this.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(baseLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        String modelPropString = "facing=west,variant=%s,visible=true";
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), stack -> {
            if (!stack.func_77942_o()) {
                return new ModelResourceLocation(baseLocation, String.format(modelPropString, true, Variant.BASE.func_176610_l().toLowerCase()));
            }
            NBTTagCompound tag = stack.func_77978_p();
            Variant variant = Variant.fromId(tag.func_74771_c(VARIANT_TAG));
            return new ModelResourceLocation(baseLocation, String.format(modelPropString, variant.func_176610_l().toLowerCase()));
        });
        for (Variant variant : Variant.values()) {
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)this), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(baseLocation, String.format(modelPropString, variant.func_176610_l().toLowerCase()))});
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return WorldTools.getTile(source, pos, TileTotemPart.class).map(TileTotemPart::getVariant).orElse(Variant.BASE).getBoundingBox((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    public static enum Variant implements IStringSerializable
    {
        BASE(0){

            @Override
            protected Set<BlockPos> getAdditionalPartPositions(BlockPos pos, EnumFacing facing) {
                return ImmutableSet.of((Object)pos.func_177984_a());
            }

            @Override
            public void placeAdditionalParts(World world, BlockPos pos, EnumFacing facing) {
                world.func_175656_a(pos.func_177984_a(), AWStructureBlocks.TOTEM_PART.func_176223_P().func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(false)));
                WorldTools.getTile((IBlockAccess)world, pos.func_177984_a(), TileTotemPart.class).ifPresent(t -> t.setMainBlockPos(pos));
            }
        }
        ,
        MID(1),
        MID_ALT(2),
        TOP(3){

            @Override
            protected Set<BlockPos> getAdditionalPartPositions(BlockPos pos, EnumFacing facing) {
                return ImmutableSet.of((Object)pos.func_177984_a(), (Object)pos.func_177972_a(facing.func_176746_e()), (Object)pos.func_177972_a(facing.func_176735_f()));
            }

            @Override
            public void placeAdditionalParts(World world, BlockPos pos, EnumFacing facing) {
                world.func_175656_a(pos.func_177984_a(), AWStructureBlocks.TOTEM_PART.func_176223_P().func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(false)));
                WorldTools.getTile((IBlockAccess)world, pos.func_177984_a(), TileTotemPart.class).ifPresent(t -> t.setMainBlockPos(pos));
                this.placeWingBlock(world, pos, pos.func_177972_a(facing.func_176746_e()), facing.func_176734_d());
                this.placeWingBlock(world, pos, pos.func_177972_a(facing.func_176735_f()), facing);
            }

            private void placeWingBlock(World world, BlockPos mainPos, BlockPos wingPos, EnumFacing wingFacing) {
                world.func_175656_a(wingPos, AWStructureBlocks.TOTEM_PART.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)wingFacing));
                WorldTools.getTile((IBlockAccess)world, wingPos, TileTotemPart.class).ifPresent(t -> {
                    t.setVariant(WINGS);
                    t.setMainBlockPos(mainPos);
                });
            }
        }
        ,
        WINGS(4){

            @Override
            public AxisAlignedBB getBoundingBox(EnumFacing facing) {
                return facing.func_176740_k() == EnumFacing.Axis.X ? WING_AABB_X : WING_AABB_Z;
            }
        }
        ,
        IRMINSUL_BASE(5){

            @Override
            public AxisAlignedBB getBoundingBox(EnumFacing facing) {
                return facing.func_176740_k() == EnumFacing.Axis.X ? IRMINSUL_AABB_X : IRMINSUL_AABB_Z;
            }
        }
        ,
        IRMINSUL_MID(6){

            @Override
            public AxisAlignedBB getBoundingBox(EnumFacing facing) {
                return facing.func_176740_k() == EnumFacing.Axis.X ? IRMINSUL_AABB_X : IRMINSUL_AABB_Z;
            }
        }
        ,
        IRMINSUL_TOP(7){

            @Override
            public AxisAlignedBB getBoundingBox(EnumFacing facing) {
                return facing.func_176740_k() == EnumFacing.Axis.X ? IRMINSUL_TOP_AABB_X : IRMINSUL_TOP_AABB_Z;
            }

            @Override
            protected Set<BlockPos> getAdditionalPartPositions(BlockPos pos, EnumFacing facing) {
                return ImmutableSet.of((Object)pos.func_177972_a(facing.func_176746_e()), (Object)pos.func_177972_a(facing.func_176735_f()));
            }

            @Override
            public void placeAdditionalParts(World world, BlockPos pos, EnumFacing facing) {
                this.placeSideBlock(world, pos, pos.func_177972_a(facing.func_176746_e()), facing.func_176734_d());
                this.placeSideBlock(world, pos, pos.func_177972_a(facing.func_176735_f()), facing);
            }

            private void placeSideBlock(World world, BlockPos mainPos, BlockPos wingPos, EnumFacing wingFacing) {
                world.func_175656_a(wingPos, AWStructureBlocks.TOTEM_PART.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)wingFacing));
                WorldTools.getTile((IBlockAccess)world, wingPos, TileTotemPart.class).ifPresent(t -> {
                    t.setVariant(IRMINSUL_SIDE);
                    t.setMainBlockPos(mainPos);
                });
            }
        }
        ,
        IRMINSUL_SIDE(8){

            @Override
            public AxisAlignedBB getBoundingBox(EnumFacing facing) {
                return facing.func_176740_k() == EnumFacing.Axis.X ? IRMINSUL_SIDE_AABB_X : IRMINSUL_SIDE_AABB_Z;
            }
        };

        private int id;
        protected static final AxisAlignedBB DEFAULT_AABB;
        protected static final AxisAlignedBB WING_AABB_X;
        protected static final AxisAlignedBB WING_AABB_Z;
        protected static final AxisAlignedBB IRMINSUL_AABB_X;
        protected static final AxisAlignedBB IRMINSUL_AABB_Z;
        protected static final AxisAlignedBB IRMINSUL_TOP_AABB_X;
        protected static final AxisAlignedBB IRMINSUL_TOP_AABB_Z;
        protected static final AxisAlignedBB IRMINSUL_SIDE_AABB_X;
        protected static final AxisAlignedBB IRMINSUL_SIDE_AABB_Z;
        private static Map<Integer, Variant> variants;

        private Variant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        protected Set<BlockPos> getAdditionalPartPositions(BlockPos pos, EnumFacing facing) {
            return new HashSet<BlockPos>();
        }

        public boolean canPlace(World world, BlockPos pos, EntityPlayer placer) {
            if (!this.mayPlace(world, pos, placer)) {
                return false;
            }
            Set<BlockPos> positions = this.getAdditionalPartPositions(pos, placer.func_174811_aO());
            for (BlockPos addPos : positions) {
                if (this.mayPlace(world, addPos, placer)) continue;
                return false;
            }
            return true;
        }

        public void placeAdditionalParts(World world, BlockPos pos, EnumFacing facing) {
        }

        private boolean mayPlace(World world, BlockPos pos, EntityPlayer placer) {
            return world.func_190527_a(AWStructureBlocks.TOTEM_PART, pos, false, EnumFacing.UP, (Entity)placer);
        }

        public static Variant fromId(int id) {
            return variants.get(id);
        }

        public AxisAlignedBB getBoundingBox(EnumFacing value) {
            return DEFAULT_AABB;
        }

        static {
            DEFAULT_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
            WING_AABB_X = new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.9375, 1.0);
            WING_AABB_Z = new AxisAlignedBB(0.0, 0.25, 0.375, 1.0, 0.9375, 0.625);
            IRMINSUL_AABB_X = new AxisAlignedBB(0.25, 0.0, 0.1875, 0.75, 1.0, 0.8125);
            IRMINSUL_AABB_Z = new AxisAlignedBB(0.1875, 0.0, 0.25, 0.8125, 1.0, 0.75);
            IRMINSUL_TOP_AABB_X = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.875, 1.0);
            IRMINSUL_TOP_AABB_Z = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 0.875, 0.75);
            IRMINSUL_SIDE_AABB_X = new AxisAlignedBB(0.25, 0.1875, 0.0, 0.75, 0.875, 1.0);
            IRMINSUL_SIDE_AABB_Z = new AxisAlignedBB(0.0, 0.1875, 0.25, 1.0, 0.875, 0.75);
            variants = new HashMap<Integer, Variant>();
            for (Variant variant : Variant.values()) {
                variants.put(variant.getId(), variant);
            }
        }
    }
}

