/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.render.StructureScannerRenderer;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureScanner;

public class BlockStructureScanner
extends BlockBaseStructure {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;

    public BlockStructureScanner() {
        super(Material.field_151575_d, "structure_scanner_block");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 1, pos);
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Optional<TileStructureScanner> tile = WorldTools.getTile(worldIn, pos, TileStructureScanner.class);
        return tile.map(tileStructureScanner -> state.func_177226_a((IProperty)FACING, (Comparable)tileStructureScanner.getRenderFacing())).orElse(state);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        WorldTools.getTile((IBlockAccess)worldIn, pos, TileStructureScanner.class).ifPresent(t -> t.setFacing(placer.func_174811_aO().func_176734_d()));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileStructureScanner();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        ClientRegistry.bindTileEntitySpecialRenderer(TileStructureScanner.class, (TileEntitySpecialRenderer)new StructureScannerRenderer());
    }
}

