/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.render.RenderStructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureBuilder;

public class BlockStructureBuilder
extends BlockBaseStructure {
    private NonNullList<ItemStack> displayCache = null;

    public BlockStructureBuilder() {
        super(Material.field_151576_e, "structure_builder_ticked");
        this.func_149711_c(2.0f);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.displayCache == null || this.displayCache.isEmpty()) {
            this.displayCache = NonNullList.func_191196_a();
            Set<String> templateNames = StructureTemplateManager.getSurvivalStructures().keySet();
            for (String templateName : templateNames) {
                ItemStack item = new ItemStack((Block)this);
                item.func_77983_a("structureName", (NBTBase)new NBTTagString(templateName));
                this.displayCache.add((Object)item);
            }
        }
        if (!this.displayCache.isEmpty()) {
            items.addAll(this.displayCache);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileStructureBuilder();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            WorldTools.getTile((IBlockAccess)world, pos, TileStructureBuilder.class).ifPresent(b -> b.onBlockClicked(player));
        }
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack drop = new ItemStack((Block)this);
        WorldTools.getTile(world, pos, TileStructureBuilder.class).ifPresent(t -> drop.func_77982_d(new NBTBuilder().setString("structureName", t.getBuilder().getTemplate().name).setTag("progress", t.getBuilder().serializeProgressData()).build()));
        drops.add((Object)drop);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        ClientRegistry.bindTileEntitySpecialRenderer(TileStructureBuilder.class, (TileEntitySpecialRenderer)new RenderStructureBuilder());
    }
}

