/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import codechicken.lib.model.DummyBakedModel;
import codechicken.lib.model.ModelRegistryHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.proxy.IClientRegister;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.render.GateProxyRenderer;
import net.shadowmage.ancientwarfare.structure.tile.TEGateProxy;

public final class BlockGateProxy
extends BlockContainer
implements IClientRegister {
    private static final AxisAlignedBB Z_AXIS_AABB = new AxisAlignedBB(0.5, 0.0, 0.0, 0.5, 1.0, 1.0);
    private static final AxisAlignedBB X_AXIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 0.5);
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final AxisAlignedBB NO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BlockGateProxy() {
        super(Material.field_151576_e);
        this.func_149647_a(null);
        this.func_149663_c("gate_proxy");
        this.setRegistryName(new ResourceLocation("ancientwarfarestructure", "gate_proxy"));
        this.func_149722_s();
        AncientWarfareStructure.proxy.addClientRegister(this);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TEGateProxy();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return WorldTools.getTile(world, pos, TEGateProxy.class).map(TEGateProxy::isOpen).orElse(false) != false ? field_185506_k : this.getCorrectAxisAABB(world, pos);
    }

    private AxisAlignedBB getCorrectAxisAABB(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c() == this || world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_177230_c() == this ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return ZERO_AABB;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        if (WorldTools.getTile(world, pos, TEGateProxy.class).map(TEGateProxy::isGateClosed).orElse(false).booleanValue()) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c() == this) {
            return world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_177230_c() == this;
        }
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_177230_c() == this) {
            return world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_177230_c() == this;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ModelResourceLocation modelLocation = new ModelResourceLocation(this.getRegistryName(), "normal");
        ModelLoaderHelper.registerItem((Block)this, modelLocation);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return modelLocation;
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)modelLocation, (IBakedModel)new DummyBakedModel());
        ClientRegistry.bindTileEntitySpecialRenderer(TEGateProxy.class, (TileEntitySpecialRenderer)new GateProxyRenderer());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return WorldTools.getTile(source, pos, TEGateProxy.class).map(TEGateProxy::isOpen).orElse(false) != false ? NO_AABB : field_185505_j;
    }
}

