/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;

public class BlockFirePit
extends BlockBaseStructure {
    public static final String LIT_TAG = "lit";
    private static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final String VARIANT_TAG = "variant";
    private static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockFirePit() {
        super(Material.field_151576_e, "fire_pit");
        this.func_149711_c(2.0f);
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, LIT});
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        Item item = Item.func_150898_a((Block)this);
        for (Variant variant : Variant.values()) {
            ItemStack stack = new ItemStack(item);
            stack.func_77982_d(new NBTBuilder().setString(VARIANT_TAG, variant.func_176610_l()).setBoolean(LIT_TAG, false).build());
            items.add((Object)stack);
            stack = new ItemStack(item);
            stack.func_77982_d(new NBTBuilder().setString(VARIANT_TAG, variant.func_176610_l()).setBoolean(LIT_TAG, true).build());
            items.add((Object)stack);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.fromMeta(meta & 7))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta >> 3 == 1));
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal() | ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 8 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public Material func_149688_o(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMaterial();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        state = state.func_177226_a(VARIANT, (Comparable)((Object)Variant.byValue(stack.func_77978_p().func_74779_i(VARIANT_TAG)))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(stack.func_77978_p().func_74767_n(LIT_TAG)));
        worldIn.func_175656_a(pos, state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickStack = new ItemStack(Item.func_150898_a((Block)this));
        pickStack.func_77982_d(new NBTBuilder().setString(VARIANT_TAG, ((Variant)((Object)state.func_177229_b(VARIANT))).func_176610_l()).setBoolean(LIT_TAG, (Boolean)state.func_177229_b((IProperty)LIT)).build());
        return pickStack;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && this.isFireStarter(stack)) {
            if (world.field_72995_K) {
                return true;
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            if (stack.func_77973_b().func_77645_m()) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && stack.func_77973_b() == Items.field_151131_as) {
            if (world.field_72995_K) {
                return true;
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            }
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 1.0f);
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    private boolean isFireStarter(ItemStack heldItem) {
        return heldItem.func_77973_b() == Items.field_151033_d || heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack firePit = new ItemStack((Block)this);
        firePit.func_77982_d(new NBTBuilder().setString(VARIANT_TAG, ((Variant)((Object)state.func_177229_b(VARIANT))).func_176610_l()).setBoolean(LIT_TAG, false).build());
        drops.add((Object)firePit);
    }

    public int func_149738_a(World worldIn) {
        return 30;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        if (rand.nextInt(10) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.func_177958_n() + 0.25 + rand.nextDouble() * 0.5;
            double y = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double z = (double)pos.func_177952_p() + 0.25 + rand.nextDouble() * 0.5;
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ResourceLocation baseLocation = new ResourceLocation("ancientwarfare", "structure/" + this.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(baseLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        String modelPropString = "lit=%b,variant=%s";
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), stack -> {
            if (!stack.func_77942_o()) {
                return new ModelResourceLocation(baseLocation, String.format(modelPropString, true, Variant.DEFAULT.func_176610_l().toLowerCase()));
            }
            NBTTagCompound tag = stack.func_77978_p();
            Variant variant = Variant.byValue(tag.func_74779_i(VARIANT_TAG));
            boolean lit = tag.func_74767_n(LIT_TAG);
            return new ModelResourceLocation(baseLocation, String.format(modelPropString, lit, variant.func_176610_l().toLowerCase()));
        });
        for (Variant variant : Variant.values()) {
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)this), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(baseLocation, String.format(modelPropString, true, variant.func_176610_l().toLowerCase()))});
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)this), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(baseLocation, String.format(modelPropString, false, variant.func_176610_l().toLowerCase()))});
        }
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT(Material.field_151576_e),
        LOG(Material.field_151575_d),
        SQUARE(Material.field_151576_e);

        private Material material;
        private static final Map<String, Variant> VALUES;

        private Variant(Material material) {
            this.material = material;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public Material getMaterial() {
            return this.material;
        }

        public static Variant fromMeta(int meta) {
            return Variant.values()[meta];
        }

        public static Variant byValue(String value) {
            return VALUES.getOrDefault(value, DEFAULT);
        }

        static {
            VALUES = new HashMap<String, Variant>();
            for (Variant variant : Variant.values()) {
                VALUES.put(variant.func_176610_l(), variant);
            }
        }
    }
}

