/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public abstract class Trade {
    protected NonNullList<ItemStack> input = NonNullList.func_191197_a((int)this.size(), (Object)ItemStack.field_190927_a);
    protected NonNullList<ItemStack> output = NonNullList.func_191197_a((int)this.size(), (Object)ItemStack.field_190927_a);

    public int size() {
        return 9;
    }

    public ItemStack getInputStack(int index) {
        return (ItemStack)this.input.get(index);
    }

    public ItemStack getOutputStack(int index) {
        return (ItemStack)this.output.get(index);
    }

    public void setInputStack(int index, ItemStack stack) {
        this.input.set(index, (Object)stack);
    }

    public void setOutputStack(int index, ItemStack stack) {
        this.output.set(index, (Object)stack);
    }

    public boolean performTrade(EntityPlayer player, @Nullable IItemHandler storage) {
        NonNullList<ItemStack> list = NonNullList.func_191196_a();
        for (ItemStack temp : this.input) {
            if (temp.func_190926_b()) continue;
            list.add((Object)temp.func_77946_l());
        }
        list = InventoryTools.compactStackList(list);
        for (ItemStack stack : list) {
            if (this.hasEnoughOf(player, stack)) continue;
            return false;
        }
        this.doTrade(player, storage);
        return true;
    }

    private boolean hasEnoughOf(EntityPlayer player, ItemStack stack) {
        return InventoryTools.getItemHandlerFrom((ICapabilityProvider)player, null).map(handler -> InventoryTools.getCountOf(handler, stack) >= stack.func_190916_E()).orElse(false);
    }

    protected void doTrade(EntityPlayer player, @Nullable IItemHandler storage) {
        InventoryTools.getItemHandlerFrom((ICapabilityProvider)player, null).ifPresent(playerInventory -> {
            for (ItemStack inputStack : this.input) {
                ItemStack result;
                if (inputStack.func_190926_b() || (result = InventoryTools.removeItems(playerInventory, inputStack, inputStack.func_190916_E())).func_190926_b() || storage == null) continue;
                InventoryTools.mergeItemStack(storage, result);
            }
            for (ItemStack outputStack : this.output) {
                if (outputStack.func_190926_b() || (outputStack = InventoryTools.mergeItemStack(playerInventory, outputStack = storage != null ? InventoryTools.removeItems(storage, outputStack, outputStack.func_190916_E()) : outputStack.func_77946_l())).func_190926_b() || player.field_70170_p.field_72995_K) continue;
                InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)outputStack);
            }
        });
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound itemTag;
        int i;
        NBTTagList list = new NBTTagList();
        for (i = 0; i < this.input.size(); ++i) {
            if (((ItemStack)this.input.get(i)).func_190926_b()) continue;
            itemTag = ((ItemStack)this.input.get(i)).func_77955_b(new NBTTagCompound());
            itemTag.func_74768_a("slot", i);
            list.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("inputItems", (NBTBase)list);
        list = new NBTTagList();
        for (i = 0; i < this.output.size(); ++i) {
            if (((ItemStack)this.output.get(i)).func_190926_b()) continue;
            itemTag = ((ItemStack)this.output.get(i)).func_77955_b(new NBTTagCompound());
            itemTag.func_74768_a("slot", i);
            list.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("outputItems", (NBTBase)list);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound itemTag;
        NBTTagList inputList = tag.func_150295_c("inputItems", 10);
        for (int i = 0; i < inputList.func_74745_c(); ++i) {
            itemTag = inputList.func_150305_b(i);
            this.input.set(itemTag.func_74762_e("slot"), (Object)new ItemStack(itemTag));
        }
        NBTTagList outputList = tag.func_150295_c("outputItems", 10);
        for (int i = 0; i < outputList.func_74745_c(); ++i) {
            itemTag = outputList.func_150305_b(i);
            this.output.set(itemTag.func_74762_e("slot"), (Object)new ItemStack(itemTag));
        }
    }

    public boolean isValid() {
        return this.input.stream().anyMatch(s -> !s.func_190926_b()) && this.output.stream().anyMatch(s -> !s.func_190926_b());
    }
}

