/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.npc.trade.POTradeDepositEntry;
import net.shadowmage.ancientwarfare.npc.trade.POTradeWithdrawEntry;

public class POTradeRestockData {
    private BlockPos withdrawPoint;
    private EnumFacing withdrawSide = EnumFacing.DOWN;
    private List<POTradeWithdrawEntry> withdrawList = new ArrayList<POTradeWithdrawEntry>();
    private BlockPos depositPoint;
    private EnumFacing depositSide = EnumFacing.UP;
    private List<POTradeDepositEntry> depositList = new ArrayList<POTradeDepositEntry>();

    public BlockPos getDepositPoint() {
        return this.depositPoint;
    }

    public BlockPos getWithdrawPoint() {
        return this.withdrawPoint;
    }

    public EnumFacing getDepositSide() {
        return this.depositSide;
    }

    public EnumFacing getWithdrawSide() {
        return this.withdrawSide;
    }

    public void deleteDepositPoint() {
        this.depositPoint = null;
    }

    public void deleteWithdrawPoint() {
        this.withdrawPoint = null;
    }

    public List<POTradeWithdrawEntry> getWithdrawList() {
        return this.withdrawList;
    }

    public List<POTradeDepositEntry> getDepositList() {
        return this.depositList;
    }

    public void addDepositEntry() {
        this.depositList.add(new POTradeDepositEntry());
    }

    public void addWithdrawEntry() {
        this.withdrawList.add(new POTradeWithdrawEntry());
    }

    public void removeDepositEntry(int index) {
        this.depositList.remove(index);
    }

    public void removeWithdrawEntry(int index) {
        this.withdrawList.remove(index);
    }

    public void setDepositPoint(BlockPos pos, EnumFacing side) {
        this.depositPoint = pos;
        this.depositSide = side;
    }

    public void setWithdrawPoint(BlockPos pos, EnumFacing side) {
        this.withdrawPoint = pos;
        this.withdrawSide = side;
    }

    public void doDeposit(IItemHandler storage, IItemHandler deposit) {
        for (POTradeDepositEntry aDeposit : this.depositList) {
            aDeposit.process(storage, deposit);
        }
    }

    public void doWithdraw(IItemHandler storage, IItemHandler withdraw) {
        for (POTradeWithdrawEntry aWithdraw : this.withdrawList) {
            aWithdraw.process(storage, withdraw);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("withdrawPoint")) {
            this.withdrawPoint = BlockPos.func_177969_a((long)tag.func_74763_f("withdrawPoint"));
            this.withdrawSide = EnumFacing.field_82609_l[tag.func_74771_c("withdrawSide")];
        }
        if (tag.func_74764_b("depositPoint")) {
            this.depositPoint = BlockPos.func_177969_a((long)tag.func_74763_f("depositPoint"));
            this.depositSide = EnumFacing.field_82609_l[tag.func_74771_c("depositSide")];
        }
        NBTTagList deposit = tag.func_150295_c("depositList", 10);
        for (int i = 0; i < deposit.func_74745_c(); ++i) {
            POTradeDepositEntry de = new POTradeDepositEntry();
            de.readFromNBT(deposit.func_150305_b(i));
            this.depositList.add(de);
        }
        NBTTagList withdraw = tag.func_150295_c("withdrawList", 10);
        for (int i = 0; i < withdraw.func_74745_c(); ++i) {
            POTradeWithdrawEntry we = new POTradeWithdrawEntry();
            we.readFromNBT(withdraw.func_150305_b(i));
            this.withdrawList.add(we);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.withdrawPoint != null) {
            tag.func_74772_a("withdrawPoint", this.withdrawPoint.func_177986_g());
            tag.func_74774_a("withdrawSide", (byte)this.withdrawSide.ordinal());
        }
        if (this.depositPoint != null) {
            tag.func_74772_a("depositPoint", this.depositPoint.func_177986_g());
            tag.func_74774_a("depositSide", (byte)this.depositSide.ordinal());
        }
        NBTTagList depositTagList = new NBTTagList();
        for (POTradeDepositEntry aDeposit : this.depositList) {
            depositTagList.func_74742_a((NBTBase)aDeposit.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("depositList", (NBTBase)depositTagList);
        NBTTagList withdrawTagList = new NBTTagList();
        for (POTradeWithdrawEntry aWithdraw : this.withdrawList) {
            withdrawTagList.func_74742_a((NBTBase)aWithdraw.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("withdrawList", (NBTBase)withdrawTagList);
        return tag;
    }
}

