/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.trade.POTradeTransferEntry;

public final class POTradeDepositEntry
extends POTradeTransferEntry {
    @Override
    public POTradeTransferEntry.TransferType getDefaultType() {
        return POTradeDepositType.ALL_OF;
    }

    @Override
    public void toggleType() {
        int o = this.getType().ordinal();
        if (++o >= POTradeDepositType.values().length) {
            o = 0;
        }
        this.setType(POTradeDepositType.values()[o]);
    }

    @Override
    protected POTradeTransferEntry.TransferType getTypeFrom(int type) {
        return POTradeDepositType.values()[type];
    }

    public static enum POTradeDepositType implements POTradeTransferEntry.TransferType
    {
        ALL_OF{

            @Override
            public void doTransfer(IItemHandler storage, IItemHandler move, ItemStack filter) {
                int count = InventoryTools.getCountOf(storage, filter);
                if (count > 0) {
                    InventoryTools.transferItems(storage, move, filter, count);
                }
            }
        }
        ,
        QUANTITY{

            @Override
            public void doTransfer(IItemHandler storage, IItemHandler move, ItemStack filter) {
                int count = InventoryTools.getCountOf(storage, filter);
                if (count > filter.func_190916_E()) {
                    count = filter.func_190916_E();
                }
                InventoryTools.transferItems(storage, move, filter, count);
            }
        }
        ,
        DEPOSIT_EXCESS{

            @Override
            public void doTransfer(IItemHandler storage, IItemHandler move, ItemStack filter) {
                int count = InventoryTools.getCountOf(storage, filter);
                if (count > filter.func_190916_E()) {
                    InventoryTools.transferItems(storage, move, filter, count - filter.func_190916_E());
                }
            }
        };

    }
}

