/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.trade.Trade;

public class POTrade
extends Trade {
    private NonNullList<ItemStack> compactInput = NonNullList.func_191196_a();
    private NonNullList<ItemStack> compactOutput = NonNullList.func_191196_a();

    @Override
    public void setInputStack(int index, ItemStack stack) {
        super.setInputStack(index, stack);
        this.updateCompactInput();
    }

    @Override
    public void setOutputStack(int index, ItemStack stack) {
        super.setOutputStack(index, stack);
        this.updateCompactOutput();
    }

    private void updateCompactInput() {
        NonNullList list = NonNullList.func_191196_a();
        for (ItemStack temp : this.input) {
            if (temp.func_190926_b()) continue;
            list.add((Object)temp.func_77946_l());
        }
        this.compactInput = InventoryTools.compactStackList((NonNullList<ItemStack>)list);
    }

    private void updateCompactOutput() {
        NonNullList list = NonNullList.func_191196_a();
        for (ItemStack temp : this.output) {
            if (temp.func_190926_b()) continue;
            list.add((Object)temp.func_77946_l());
        }
        this.compactOutput = InventoryTools.compactStackList((NonNullList<ItemStack>)list);
    }

    public boolean isAvailable(IItemHandler storage) {
        for (ItemStack stack : this.compactOutput) {
            if (InventoryTools.getCountOf(storage, stack) >= stack.func_190916_E()) continue;
            return false;
        }
        return InventoryTools.canInventoryHold(storage, this.compactInput);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.updateCompactInput();
        this.updateCompactOutput();
    }
}

