/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.npc.trade.FactionTrade;
import net.shadowmage.ancientwarfare.npc.trade.Trade;
import net.shadowmage.ancientwarfare.npc.trade.TradeList;

public final class FactionTradeList
extends TradeList {
    private int ticks = 0;

    @Override
    protected Trade getNewTrade() {
        return new FactionTrade();
    }

    public void tick() {
        ++this.ticks;
    }

    public void updateTradesForView() {
        for (Trade aTrade : this.points) {
            ((FactionTrade)aTrade).updateTrade(this.ticks);
        }
        this.ticks = 0;
    }

    public void removeEmptyTrades() {
        Trade t;
        Iterator it = this.points.iterator();
        while (it.hasNext() && (t = (Trade)it.next()) != null) {
            if (((FactionTrade)t).hasItems()) continue;
            it.remove();
        }
    }

    public boolean performTrade(EntityPlayer player, int tradeNum) {
        return ((Trade)this.get(tradeNum)).performTrade(player, null);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74768_a("ticks", this.ticks);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        this.ticks = tag.func_74762_e("ticks");
        super.deserializeNBT(tag);
    }
}

