/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.skin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.util.FileUtils;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import org.apache.commons.io.FilenameUtils;

public class NpcSkinManager {
    public static final NpcSkinManager INSTANCE = new NpcSkinManager();
    private final HashMap<String, List<ResourceLocation>> npcSkins = new HashMap();
    private final Random rng = new Random();
    private static final String SKINS_CONFIG_PATH = "config/ancientwarfare/npc/skins/";
    private static final String DEFAULT_SKINS = "assets/ancientwarfare/skin_pack";

    public Optional<ResourceLocation> getTextureFor(NpcBase npc) {
        Optional<ResourceLocation> texture;
        long id = npc.getIDForSkin();
        if (!npc.getCustomTex().isEmpty() && (texture = this.getNpcTexture(npc.getCustomTex(), id)).isPresent()) {
            return texture;
        }
        return this.getNpcTexture(npc.getNpcFullType(), id);
    }

    private Optional<ResourceLocation> getNpcTexture(String type, long idlsb) {
        this.rng.setSeed(idlsb);
        return this.npcSkins.containsKey(type) ? Optional.of(this.npcSkins.get(type).get(this.rng.nextInt(this.npcSkins.get(type).size()))) : Optional.empty();
    }

    public void loadSkins() {
        this.loadSkinsFromSource(Loader.instance().activeModContainer().getSource(), DEFAULT_SKINS);
        this.loadSkinsFromSource(new File(SKINS_CONFIG_PATH), "");
    }

    private void loadSkinsFromSource(File source, String base) {
        HashMap imageMap = new HashMap();
        FileUtils.findFiles(source, base, root -> {
            Path fPath = root.resolve("skin_pack.meta");
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(fPath);){
                    this.readImageMap(reader, imageMap);
                }
                catch (IOException e) {
                    AncientWarfareCore.LOG.error("Error loading skin_pack.meta: ", (Throwable)e);
                    return false;
                }
            }
            return true;
        }, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            String extension = FilenameUtils.getExtension((String)file.toString());
            if (extension.equals("png")) {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    List<String> skinMappings = imageMap.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(relative)).map(Map.Entry::getKey).collect(Collectors.toList());
                    if (!skinMappings.isEmpty()) {
                        ResourceLocation skinRegistryName = this.loadSkinImage(relative, stream);
                        skinMappings.forEach(skinMapping -> this.addNpcSkin((String)skinMapping, skinRegistryName));
                    }
                }
                catch (IOException e2) {
                    AncientWarfareCore.LOG.error("Error loading image {}: ", (Object)relative, (Object)e2);
                }
            }
        });
    }

    private void readImageMap(BufferedReader br, HashMap<String, Set<String>> imageMap) throws IOException {
        while (br.ready()) {
            String line = br.readLine();
            String[] lineBits = line.split("=");
            if (lineBits.length <= 1) continue;
            if (!imageMap.containsKey(lineBits[0])) {
                imageMap.put(lineBits[0], new HashSet());
            }
            imageMap.get(lineBits[0]).add(lineBits[1]);
        }
    }

    private void addNpcSkin(String npcType, ResourceLocation texture) {
        if (!this.npcSkins.containsKey(npcType)) {
            this.npcSkins.put(npcType, new ArrayList());
        }
        this.npcSkins.get(npcType).add(texture);
    }

    private ResourceLocation loadSkinImage(String imageName, InputStream is) {
        return AncientWarfareNPC.proxy.loadSkinPackImage(imageName, is).orElse(TextureMap.field_174945_f);
    }
}

