/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.item.ItemOrders;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderWorkLines {
    public static final RenderWorkLines INSTANCE = new RenderWorkLines();
    private final List<BlockPos> positionList = new ArrayList<BlockPos>();

    private RenderWorkLines() {
    }

    @SubscribeEvent
    public void renderLastEvent(RenderWorldLastEvent evt) {
        boolean render = AWNPCStatics.renderWorkPoints.getBoolean();
        if (!render) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        Item item = stack.func_77973_b();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemOrders)) {
            stack = player.func_184592_cb();
            item = stack.func_77973_b();
        }
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemOrders)) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.positionList.addAll(((ItemOrders)item).getPositionsForRender(stack));
        if (this.positionList.size() > 0) {
            this.renderListOfPoints((EntityPlayer)player, evt.getPartialTicks());
            this.positionList.clear();
        }
    }

    private void renderListOfPoints(EntityPlayer player, float partialTick) {
        AxisAlignedBB bb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        BlockPos prev = null;
        int index = 1;
        for (BlockPos point : this.positionList) {
            bb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            bb = bb.func_72317_d((double)point.func_177958_n(), (double)point.func_177956_o(), (double)point.func_177952_p());
            bb = RenderTools.adjustBBForPlayerPos(bb, player, partialTick);
            RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 1.0f, 1.0f);
            this.renderTextAt(player, (double)point.func_177958_n() + 0.5, (double)point.func_177956_o() + 1.5, (double)point.func_177952_p() + 0.5, String.valueOf(index), partialTick);
            if (prev != null) {
                this.renderLineBetween(player, (double)point.func_177958_n() + 0.5, (double)point.func_177956_o() + 0.5, (double)point.func_177952_p() + 0.5, (double)prev.func_177958_n() + 0.5, (double)prev.func_177956_o() + 0.5, (double)prev.func_177952_p() + 0.5, partialTick);
            }
            prev = point;
            ++index;
        }
    }

    private void renderLineBetween(EntityPlayer player, double x1, double y1, double z1, double x2, double y2, double z2, float partialTick) {
        double ox = RenderTools.getRenderOffsetX(player, partialTick);
        double oy = RenderTools.getRenderOffsetY(player, partialTick);
        double oz = RenderTools.getRenderOffsetZ(player, partialTick);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_187447_r((int)2);
        GL11.glVertex3d((double)(x1 - ox), (double)(y1 - oy), (double)(z1 - oz));
        GL11.glVertex3d((double)(x2 - ox), (double)(y2 - oy), (double)(z2 - oz));
        GlStateManager.func_187437_J();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private void renderTextAt(EntityPlayer player, double x, double y, double z, String text, float partialTick) {
        double ox = RenderTools.getRenderOffsetX(player, partialTick);
        double oy = RenderTools.getRenderOffsetY(player, partialTick);
        double oz = RenderTools.getRenderOffsetZ(player, partialTick);
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(x -= ox)), (float)((float)(y -= oy)), (float)((float)(z -= oz)));
        GlStateManager.func_179114_b((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, 0, 0, -1);
        GlStateManager.func_179121_F();
    }
}

