/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.shadowmage.ancientwarfare.core.util.parsing.ResourceLocationMatcher;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefault;

@Immutable
public class OwnedNpcDefault
extends NpcDefault {
    private final Set<ResourceLocationMatcher> targetList;

    public OwnedNpcDefault(Set<ResourceLocationMatcher> targetList, Map<String, Double> attributes, int experienceDrop, boolean canSwim, boolean canBreakDoors, Map<Integer, Item> equipment) {
        super(attributes, experienceDrop, canSwim, canBreakDoors, equipment);
        this.targetList = targetList;
    }

    public OwnedNpcDefault overrideTargets(Set<ResourceLocationMatcher> newTargetList) {
        return new OwnedNpcDefault(newTargetList, this.attributes, this.experienceDrop, this.canSwim, this.canBreakDoors, this.equipment);
    }

    public boolean isTarget(Entity entity) {
        return EntityRegistry.getEntry(entity.getClass()) != null && this.targetList.stream().anyMatch(m -> m.test(EntityRegistry.getEntry(entity.getClass()).getRegistryName()));
    }

    @Override
    public OwnedNpcDefault setExperienceDrop(int experienceDrop) {
        return new OwnedNpcDefault(this.targetList, this.attributes, experienceDrop, this.canSwim, this.canBreakDoors, this.equipment);
    }

    @Override
    public OwnedNpcDefault setCanSwim(boolean canSwim) {
        return new OwnedNpcDefault(this.targetList, this.attributes, this.experienceDrop, canSwim, this.canBreakDoors, this.equipment);
    }

    @Override
    public OwnedNpcDefault setCanBreakDoors(boolean canBreakDoors) {
        return new OwnedNpcDefault(this.targetList, this.attributes, this.experienceDrop, this.canSwim, canBreakDoors, this.equipment);
    }

    @Override
    public OwnedNpcDefault setAttributes(Map<String, Double> additionalAttributes) {
        HashMap<String, Double> newAttributes = new HashMap<String, Double>();
        newAttributes.putAll(this.attributes);
        newAttributes.putAll(additionalAttributes);
        return new OwnedNpcDefault(this.targetList, newAttributes, this.experienceDrop, this.canSwim, this.canBreakDoors, this.equipment);
    }

    @Override
    public OwnedNpcDefault setEquipment(Map<Integer, Item> additionalEquipment) {
        HashMap<Integer, Item> newEquipment = new HashMap<Integer, Item>();
        newEquipment.putAll(this.equipment);
        newEquipment.putAll(additionalEquipment);
        return new OwnedNpcDefault(this.targetList, this.attributes, this.experienceDrop, this.canSwim, this.canBreakDoors, newEquipment);
    }
}

