/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.RegistryTools;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;
import net.shadowmage.ancientwarfare.core.util.parsing.ResourceLocationMatcher;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.AdditionalAttributes;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.IAdditionalAttribute;
import net.shadowmage.ancientwarfare.npc.init.AWNPCEntities;
import net.shadowmage.ancientwarfare.npc.registry.FactionNpcDefault;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefault;
import net.shadowmage.ancientwarfare.npc.registry.OwnedNpcDefault;

public class NpcDefaultsRegistry {
    private static Map<String, Map<String, FactionNpcDefault>> factionNpcDefaults = new HashMap<String, Map<String, FactionNpcDefault>>();
    private static Map<String, OwnedNpcDefault> ownedNpcDefaults = new HashMap<String, OwnedNpcDefault>();
    private static final String FACTION_NPC_PREFIX = "faction.";

    private NpcDefaultsRegistry() {
    }

    public static FactionNpcDefault getFactionNpcDefault(String faction, String npcType) {
        return factionNpcDefaults.get(faction).get(npcType);
    }

    public static FactionNpcDefault getFactionNpcDefault(NpcFaction npc) {
        return factionNpcDefaults.get(npc.getFaction()).get(npc.getNpcType());
    }

    public static OwnedNpcDefault getOwnedNpcDefault(NpcPlayerOwned npc) {
        return ownedNpcDefaults.get(npc.getNpcType());
    }

    public static class FactionNpcDefaultsParser
    extends NpcDefaultsParserBase {
        @Override
        public String getName() {
            return "faction_npc_defaults";
        }

        @Override
        public void parse(JsonObject json) {
            FactionNpcDefault overallDefault = this.parseDefaults(json);
            Map<String, FactionNpcDefault> npcSubtypeDefaults = this.parseSubtypes(json, overallDefault);
            this.parseFactions(json, npcSubtypeDefaults);
        }

        private FactionNpcDefault parseDefaults(JsonObject json) {
            JsonObject defaults = JsonUtils.func_152754_s((JsonObject)json, (String)"defaults");
            return new FactionNpcDefault(this.getAttributes(defaults), this.getExperienceDrop(defaults).orElse(0), this.getCanSwim(defaults).orElse(true), this.getCanBreakDoors(defaults).orElse(true), this.getEquipment(defaults), this.getAdditionalAttributes(defaults), this.getEnabled(defaults).orElse(true));
        }

        private Map<IAdditionalAttribute<?>, Object> getAdditionalAttributes(JsonObject json) {
            if (!json.has("additional_attributes")) {
                return Collections.emptyMap();
            }
            return JsonHelper.mapFromJson(json, "additional_attributes", e -> AdditionalAttributes.getByName((String)e.getKey()), e -> this.parseAttributeValue(AdditionalAttributes.getByName((String)e.getKey()), ((JsonElement)e.getValue()).getAsString()));
        }

        private <T> T parseAttributeValue(IAdditionalAttribute<T> attribute, String value) {
            return attribute.parseValue(value).orElse(attribute.getValueClass().cast(null));
        }

        private void parseFactions(JsonObject json, Map<String, FactionNpcDefault> npcSubtypeDefaults) {
            JsonHelper.mapFromJson(json, "factions", factionNpcDefaults, Map.Entry::getKey, e -> this.getFactionDefaults(npcSubtypeDefaults, (Map.Entry<String, JsonElement>)e));
            this.fillRemainingFactionDefaults(npcSubtypeDefaults);
        }

        private FactionNpcDefault getSubtypeDefault(Map.Entry<String, JsonElement> entry, Function<String, FactionNpcDefault> setKey) {
            JsonObject data = JsonUtils.func_151210_l((JsonElement)entry.getValue(), (String)"");
            NpcDefault npcSubtypeDefault = setKey.apply(entry.getKey());
            npcSubtypeDefault = ((FactionNpcDefault)npcSubtypeDefault).setAttributes((Map)this.getAttributes(data));
            npcSubtypeDefault = this.getExperienceDrop(data).map(((FactionNpcDefault)npcSubtypeDefault)::setExperienceDrop).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getCanSwim(data).map(((FactionNpcDefault)npcSubtypeDefault)::setCanSwim).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getCanBreakDoors(data).map(((FactionNpcDefault)npcSubtypeDefault)::setCanBreakDoors).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = ((FactionNpcDefault)npcSubtypeDefault).setEquipment((Map)this.getEquipment(data));
            npcSubtypeDefault = ((FactionNpcDefault)npcSubtypeDefault).setAdditionalAttributes(this.getAdditionalAttributes(data));
            npcSubtypeDefault = this.getEnabled(data).map(((FactionNpcDefault)npcSubtypeDefault)::setEnabled).orElse((FactionNpcDefault)npcSubtypeDefault);
            return npcSubtypeDefault;
        }

        private Optional<Boolean> getEnabled(JsonObject data) {
            return data.has("enabled") ? Optional.of(JsonUtils.func_151212_i((JsonObject)data, (String)"enabled")) : Optional.empty();
        }

        private Map<String, FactionNpcDefault> parseSubtypes(JsonObject json, FactionNpcDefault overallDefault) {
            Map<String, FactionNpcDefault> npcSubtypeDefaults = JsonHelper.mapFromJson(json, "npc_subtypes", Map.Entry::getKey, e -> this.getSubtypeDefault((Map.Entry<String, JsonElement>)e, s -> overallDefault));
            this.fillRemainingSubtypeDefaults(overallDefault, npcSubtypeDefaults);
            return npcSubtypeDefaults;
        }

        private Map<String, FactionNpcDefault> getFactionDefaults(Map<String, FactionNpcDefault> npcSubtypeDefaults, Map.Entry<String, JsonElement> entry) {
            Map<String, FactionNpcDefault> typeDefaults = JsonHelper.mapFromJson(entry.getValue(), Map.Entry::getKey, e -> this.getSubtypeDefault((Map.Entry<String, JsonElement>)e, npcSubtypeDefaults::get));
            for (Map.Entry<String, FactionNpcDefault> subtypeDefault : npcSubtypeDefaults.entrySet()) {
                if (typeDefaults.keySet().contains(subtypeDefault.getKey())) continue;
                typeDefaults.put(subtypeDefault.getKey(), subtypeDefault.getValue());
            }
            return typeDefaults;
        }

        private void fillRemainingFactionDefaults(Map<String, FactionNpcDefault> npcSubtypeDefaults) {
            for (String faction : FactionRegistry.getFactionNames()) {
                if (factionNpcDefaults.keySet().contains(faction)) continue;
                HashMap typeDefaults = new HashMap();
                npcSubtypeDefaults.forEach(typeDefaults::put);
                factionNpcDefaults.put(faction, typeDefaults);
            }
        }

        private void fillRemainingSubtypeDefaults(FactionNpcDefault overallDefault, Map<String, FactionNpcDefault> npcSubtypeDefaults) {
            for (String subtype : AWNPCEntities.getNpcMap().keySet().stream().filter(k -> k.startsWith(NpcDefaultsRegistry.FACTION_NPC_PREFIX)).map(k -> k.replace(NpcDefaultsRegistry.FACTION_NPC_PREFIX, "")).collect(Collectors.toList())) {
                if (npcSubtypeDefaults.keySet().contains(subtype)) continue;
                npcSubtypeDefaults.put(subtype, overallDefault);
            }
        }
    }

    private static abstract class NpcDefaultsParserBase
    implements IRegistryDataParser {
        private NpcDefaultsParserBase() {
        }

        protected Optional<Boolean> getCanBreakDoors(JsonObject json) {
            return json.has("can_break_doors") ? Optional.of(JsonUtils.func_151212_i((JsonObject)json, (String)"can_break_doors")) : Optional.empty();
        }

        protected Optional<Boolean> getCanSwim(JsonObject json) {
            return json.has("can_swim") ? Optional.of(JsonUtils.func_151212_i((JsonObject)json, (String)"can_swim")) : Optional.empty();
        }

        protected Optional<Integer> getExperienceDrop(JsonObject json) {
            return json.has("experience_drop") ? Optional.of(JsonUtils.func_151203_m((JsonObject)json, (String)"experience_drop")) : Optional.empty();
        }

        protected Map<String, Double> getAttributes(JsonObject json) {
            if (!json.has("attributes")) {
                return Collections.emptyMap();
            }
            return JsonHelper.mapFromJson(json, "attributes", Map.Entry::getKey, e -> JsonUtils.func_151220_d((JsonElement)((JsonElement)e.getValue()), (String)""));
        }

        protected Map<Integer, Item> getEquipment(JsonObject json) {
            if (!json.has("equipment")) {
                return Collections.emptyMap();
            }
            return JsonHelper.mapFromJson(json, "equipment", e -> this.parseEquipmentSlot((String)e.getKey()), e -> RegistryTools.getItem(JsonUtils.func_151206_a((JsonElement)((JsonElement)e.getValue()), (String)"")));
        }

        private int parseEquipmentSlot(String slotName) {
            int slot = Arrays.stream(EntityEquipmentSlot.values()).filter(s -> s.func_188450_d().equals(slotName)).map(Enum::ordinal).findFirst().orElse(-1);
            if (slot > -1) {
                return slot;
            }
            switch (slotName) {
                case "work": {
                    return 6;
                }
                case "upkeep": {
                    return 7;
                }
            }
            throw new JsonParseException("Invalid equipment slot name \"" + slotName + "\"");
        }
    }

    public static class OwnedNpcDefaultsParser
    extends NpcDefaultsParserBase {
        @Override
        public String getName() {
            return "owned_npc_defaults";
        }

        @Override
        public void parse(JsonObject json) {
            OwnedNpcDefault overallDefault = this.parseDefaults(json);
            this.parseSubtypes(json, overallDefault);
        }

        private OwnedNpcDefault parseDefaults(JsonObject json) {
            JsonObject defaults = JsonUtils.func_152754_s((JsonObject)json, (String)"defaults");
            return new OwnedNpcDefault(this.getTargetList(defaults), this.getAttributes(defaults), this.getExperienceDrop(defaults).orElse(0), this.getCanSwim(defaults).orElse(true), this.getCanBreakDoors(defaults).orElse(true), this.getEquipment(defaults));
        }

        private void parseSubtypes(JsonObject json, OwnedNpcDefault overallDefault) {
            ownedNpcDefaults.putAll(JsonHelper.mapFromJson(json, "npc_subtypes", Map.Entry::getKey, e -> this.getSubtypeDefault((Map.Entry<String, JsonElement>)e, s -> overallDefault)));
            this.fillRemainingSubtypeDefaults(overallDefault, ownedNpcDefaults);
        }

        private OwnedNpcDefault getSubtypeDefault(Map.Entry<String, JsonElement> entry, Function<String, OwnedNpcDefault> setKey) {
            JsonObject data = JsonUtils.func_151210_l((JsonElement)entry.getValue(), (String)"");
            NpcDefault npcSubtypeDefault = setKey.apply(entry.getKey());
            npcSubtypeDefault = ((OwnedNpcDefault)npcSubtypeDefault).setAttributes((Map)this.getAttributes(data));
            npcSubtypeDefault = this.getExperienceDrop(data).map(((OwnedNpcDefault)npcSubtypeDefault)::setExperienceDrop).orElse((OwnedNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getCanSwim(data).map(((OwnedNpcDefault)npcSubtypeDefault)::setCanSwim).orElse((OwnedNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getCanBreakDoors(data).map(((OwnedNpcDefault)npcSubtypeDefault)::setCanBreakDoors).orElse((OwnedNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = ((OwnedNpcDefault)npcSubtypeDefault).setEquipment((Map)this.getEquipment(data));
            Set<ResourceLocationMatcher> overrideTargetList = this.getTargetList(data);
            if (!overrideTargetList.isEmpty()) {
                npcSubtypeDefault = ((OwnedNpcDefault)npcSubtypeDefault).overrideTargets(overrideTargetList);
            }
            return npcSubtypeDefault;
        }

        private Set<ResourceLocationMatcher> getTargetList(JsonObject json) {
            if (!json.has("entities_to_target")) {
                return Collections.emptySet();
            }
            JsonArray targets = JsonUtils.func_151214_t((JsonObject)json, (String)"entities_to_target");
            return StreamSupport.stream(targets.spliterator(), false).map(e -> new ResourceLocationMatcher(JsonUtils.func_151206_a((JsonElement)e, (String)""))).collect(Collectors.toCollection(HashSet::new));
        }

        private void fillRemainingSubtypeDefaults(OwnedNpcDefault overallDefault, Map<String, OwnedNpcDefault> npcSubtypeDefaults) {
            for (String subtype : AWNPCEntities.getNpcMap().keySet().stream().filter(k -> !k.startsWith(NpcDefaultsRegistry.FACTION_NPC_PREFIX)).collect(Collectors.toList())) {
                if (npcSubtypeDefaults.keySet().contains(subtype)) continue;
                npcSubtypeDefaults.put(subtype, overallDefault);
            }
        }
    }
}

