/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import java.util.Map;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

@Immutable
public abstract class NpcDefault {
    protected final Map<String, Double> attributes;
    protected final int experienceDrop;
    protected final boolean canSwim;
    protected final boolean canBreakDoors;
    protected final Map<Integer, Item> equipment;

    public NpcDefault(Map<String, Double> attributes, int experienceDrop, boolean canSwim, boolean canBreakDoors, Map<Integer, Item> equipment) {
        this.attributes = attributes;
        this.experienceDrop = experienceDrop;
        this.canSwim = canSwim;
        this.canBreakDoors = canBreakDoors;
        this.equipment = equipment;
    }

    public abstract NpcDefault setExperienceDrop(int var1);

    public abstract NpcDefault setCanSwim(boolean var1);

    public abstract NpcDefault setCanBreakDoors(boolean var1);

    public abstract NpcDefault setAttributes(Map<String, Double> var1);

    public abstract NpcDefault setEquipment(Map<Integer, Item> var1);

    public int getExperienceDrop() {
        return this.experienceDrop;
    }

    public double getBaseHealth() {
        String healthKey = SharedMonsterAttributes.field_111267_a.func_111108_a();
        return this.attributes.containsKey(healthKey) ? this.attributes.get(healthKey) : 0.0;
    }

    public double getBaseAttack() {
        String attackKey = SharedMonsterAttributes.field_111264_e.func_111108_a();
        return this.attributes.containsKey(attackKey) ? this.attributes.get(attackKey) : 0.0;
    }

    public void applyAttributes(NpcBase npc) {
        this.attributes.forEach((name, value) -> this.applyAttribute(npc, (String)name, (double)value));
    }

    private void applyAttribute(NpcBase npc, String attributeName, double baseValue) {
        IAttributeInstance attribute = npc.func_110140_aT().func_111152_a(attributeName);
        if (attribute != null) {
            attribute.func_111128_a(baseValue);
            if (attribute.func_111123_a() == SharedMonsterAttributes.field_111267_a) {
                npc.func_70606_j((float)baseValue);
            }
        }
    }

    public void applyPathSettings(PathNavigateGround navigator) {
        navigator.func_179693_d(this.canSwim);
        navigator.func_179688_b(this.canBreakDoors);
    }

    public void applyEquipment(NpcBase npc) {
        this.equipment.forEach((slot, item) -> npc.setItemStackToSlot((int)slot, new ItemStack(item)));
    }
}

