/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;
import net.shadowmage.ancientwarfare.npc.registry.FactionTradeListTemplate;
import net.shadowmage.ancientwarfare.npc.registry.FactionTradeTemplate;

public class FactionTradeListRegistry {
    private static Map<String, FactionTradeListTemplate> defaultTemplates;
    private static Map<String, Map<String, FactionTradeListTemplate>> factionTemplates;

    private FactionTradeListRegistry() {
    }

    public static Map<String, FactionTradeListTemplate> getFactionDefaults(String factionName) {
        return factionTemplates.getOrDefault(factionName, new HashMap());
    }

    public static Map<String, FactionTradeListTemplate> getDefaults() {
        return defaultTemplates;
    }

    public static class Parser
    implements IRegistryDataParser {
        @Override
        public String getName() {
            return "faction_trade_lists";
        }

        @Override
        public void parse(JsonObject json) {
            defaultTemplates = this.parseTradeLists(JsonUtils.func_151214_t((JsonObject)json, (String)"defaults"));
            this.parseFactionDefaults(json);
        }

        private void parseFactionDefaults(JsonObject json) {
            factionTemplates = JsonHelper.mapFromJson(json, "faction_defaults", Map.Entry::getKey, e -> this.parseTradeLists(JsonUtils.func_151207_m((JsonElement)((JsonElement)e.getValue()), (String)"trade_list")));
        }

        private Map<String, FactionTradeListTemplate> parseTradeLists(JsonArray tradeLists) {
            HashMap<String, FactionTradeListTemplate> ret = new HashMap<String, FactionTradeListTemplate>();
            for (JsonElement tradeListElement : tradeLists) {
                JsonObject tradeList = JsonUtils.func_151210_l((JsonElement)tradeListElement, (String)"trade_list");
                String name = JsonUtils.func_151200_h((JsonObject)tradeList, (String)"name");
                JsonArray tradesArray = JsonUtils.func_151214_t((JsonObject)tradeList, (String)"trades");
                List<FactionTradeTemplate> trades = this.parseTrades(tradesArray);
                ret.put(name, new FactionTradeListTemplate(name, trades));
            }
            return ret;
        }

        private List<FactionTradeTemplate> parseTrades(JsonArray trades) {
            ArrayList<FactionTradeTemplate> ret = new ArrayList<FactionTradeTemplate>();
            for (JsonElement tradeElement : trades) {
                JsonObject trade = JsonUtils.func_151210_l((JsonElement)tradeElement, (String)"trade");
                int refillFrequency = JsonUtils.func_151203_m((JsonObject)trade, (String)"refill_frequency");
                int maxTrades = JsonUtils.func_151203_m((JsonObject)trade, (String)"max_trades");
                List<ItemStack> input = JsonHelper.getItemStacks(JsonUtils.func_151214_t((JsonObject)trade, (String)"input"));
                List<ItemStack> output = JsonHelper.getItemStacks(JsonUtils.func_151214_t((JsonObject)trade, (String)"output"));
                ret.add(new FactionTradeTemplate(input, output, refillFrequency, maxTrades));
            }
            return ret;
        }
    }
}

