/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;
import net.shadowmage.ancientwarfare.core.util.parsing.ResourceLocationMatcher;
import net.shadowmage.ancientwarfare.npc.registry.FactionDefinition;

public class FactionRegistry {
    private static Map<String, FactionDefinition> factions = new HashMap<String, FactionDefinition>();
    private static final FactionDefinition EMPTY_FACTION = new FactionDefinition(0, new HashSet<String>(), new HashSet<ResourceLocationMatcher>()).copy("", -1).build();

    private FactionRegistry() {
    }

    public static Set<String> getFactionNames() {
        return factions.keySet();
    }

    public static FactionDefinition getFaction(String name) {
        return factions.getOrDefault(name, EMPTY_FACTION);
    }

    public static class FactionParser
    implements IRegistryDataParser {
        private static final String PLAYER_DEFAULT_STANDING = "player_default_standing";
        private static final String HOSTILE_TOWARDS_FACTIONS = "hostile_towards_factions";
        private static final String ENTITIES_TO_TARGET = "entities_to_target";

        @Override
        public String getName() {
            return "factions";
        }

        @Override
        public void parse(JsonObject json) {
            JsonObject defaults = JsonUtils.func_152754_s((JsonObject)json, (String)"defaults");
            FactionDefinition defaultDefinition = new FactionDefinition(JsonUtils.func_151203_m((JsonObject)defaults, (String)PLAYER_DEFAULT_STANDING), this.parseHostileTowards(defaults).entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toCollection(HashSet::new)), this.parseTargetList(defaults));
            JsonArray factionsArray = JsonUtils.func_151214_t((JsonObject)json, (String)"factions");
            for (JsonElement e : factionsArray) {
                JsonObject faction = JsonUtils.func_151210_l((JsonElement)e, (String)"faction");
                String factionName = JsonUtils.func_151200_h((JsonObject)faction, (String)"name");
                FactionDefinition.CopyBuilder builder = defaultDefinition.copy(factionName, Integer.parseInt(JsonUtils.func_151200_h((JsonObject)faction, (String)"color"), 16));
                if (faction.has(PLAYER_DEFAULT_STANDING)) {
                    builder.setPlayerDefaultStanding(JsonUtils.func_151203_m((JsonObject)faction, (String)PLAYER_DEFAULT_STANDING));
                }
                builder.removeHostileTowards(factionName);
                if (faction.has(HOSTILE_TOWARDS_FACTIONS)) {
                    Map<String, Boolean> hostileTowards = this.parseHostileTowards(faction);
                    hostileTowards.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(builder::addHostileTowards);
                    hostileTowards.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).forEach(builder::removeHostileTowards);
                }
                if (faction.has(ENTITIES_TO_TARGET)) {
                    builder.overrideTargetList(this.parseTargetList(faction));
                }
                factions.put(factionName, builder.build());
            }
        }

        private Map<String, Boolean> parseHostileTowards(JsonObject json) {
            return JsonHelper.mapFromJson(json, HOSTILE_TOWARDS_FACTIONS, Map.Entry::getKey, entry -> JsonUtils.func_151216_b((JsonElement)((JsonElement)entry.getValue()), (String)""));
        }

        private Set<ResourceLocationMatcher> parseTargetList(JsonObject json) {
            if (!json.has(ENTITIES_TO_TARGET)) {
                return Collections.emptySet();
            }
            JsonArray targets = JsonUtils.func_151214_t((JsonObject)json, (String)ENTITIES_TO_TARGET);
            return StreamSupport.stream(targets.spliterator(), false).map(e -> new ResourceLocationMatcher(JsonUtils.func_151206_a((JsonElement)e, (String)""))).collect(Collectors.toCollection(HashSet::new));
        }
    }
}

