/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.orders;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.util.OrderingList;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.ItemWorkOrder;

public class WorkOrder
extends OrderingList<WorkEntry>
implements INBTSerializable<NBTTagCompound> {
    private static final int MAX_SIZE = 8;
    private WorkPriorityType priorityType = WorkPriorityType.ROUTE;
    private boolean nightShift;

    public boolean isNightShift() {
        return this.nightShift;
    }

    public void toggleShift() {
        this.nightShift = !this.nightShift;
    }

    public WorkPriorityType getPriorityType() {
        return this.priorityType;
    }

    public List<WorkEntry> getEntries() {
        return this.points;
    }

    public boolean addWorkPosition(World world, BlockPos position) {
        if (position != null && this.size() < 8) {
            this.add(new WorkEntry(position, world.field_73011_w.getDimension(), 0));
            return true;
        }
        return false;
    }

    public String toString() {
        return "Work Orders size: " + this.size() + " of type: " + (Object)((Object)this.priorityType);
    }

    public static WorkOrder getWorkOrder(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWorkOrder) {
            WorkOrder order = new WorkOrder();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("orders")) {
                order.deserializeNBT(stack.func_77978_p().func_74775_l("orders"));
            }
            return order;
        }
        return null;
    }

    public void write(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWorkOrder) {
            stack.func_77983_a("orders", (NBTBase)this.serializeNBT());
        }
    }

    public void togglePriority() {
        WorkPriorityType[] type = WorkPriorityType.values();
        this.priorityType = type[(this.priorityType.ordinal() + 1) % type.length];
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList entryList = new NBTTagList();
        for (WorkEntry entry : this.points) {
            entryList.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        tag.func_74768_a("priorityType", this.priorityType.ordinal());
        tag.func_74757_a("nightShift", this.nightShift);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.clear();
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            this.add(new WorkEntry(entryList.func_150305_b(i)));
        }
        this.priorityType = WorkPriorityType.values()[tag.func_74762_e("priorityType")];
        this.nightShift = tag.func_74767_n("nightShift");
    }

    public static enum WorkPriorityType {
        SITE_NEED{

            @Override
            public int getNextWorkIndex(int current, List<WorkEntry> orders, NpcBase npc) {
                for (int i = 0; i < orders.size(); ++i) {
                    if (!WorldTools.getTile((IBlockAccess)npc.field_70170_p, orders.get(i).getPosition(), IWorkSite.class).filter(site -> ((IWorker)((Object)npc)).canWorkAt(site.getWorkType()) && site.hasWork()).isPresent()) continue;
                    return i;
                }
                return 0;
            }
        }
        ,
        ROUTE,
        TIMED;


        public int getNextWorkIndex(int current, List<WorkEntry> orders, NpcBase npcBase) {
            if (current + 1 >= orders.size()) {
                return 0;
            }
            return current + 1;
        }

        public boolean isTimed() {
            return this == TIMED;
        }
    }

    public static final class WorkEntry {
        private BlockPos position;
        private int dimension;
        private int workLength;

        private WorkEntry(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        private WorkEntry(BlockPos position, int dimension, int workLength) {
            this.setPosition(position);
            this.dimension = dimension;
            this.setWorkLength(workLength);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.setPosition(BlockPos.func_177969_a((long)tag.func_74763_f("pos")));
            this.dimension = tag.func_74762_e("dim");
            this.setWorkLength(tag.func_74762_e("length"));
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74772_a("pos", this.getPosition().func_177986_g());
            tag.func_74768_a("dim", this.dimension);
            tag.func_74768_a("length", this.getWorkLength());
            return tag;
        }

        public Block getBlock(World world) {
            return world.func_180495_p(this.getPosition()).func_177230_c();
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public void setPosition(BlockPos position) {
            this.position = position;
        }

        public int getWorkLength() {
            return this.workLength;
        }

        public void setWorkLength(int workLength) {
            this.workLength = workLength;
        }
    }
}

