/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.orders;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.OrderingList;
import net.shadowmage.ancientwarfare.npc.item.ItemRoutingOrder;

public class RoutingOrder
extends OrderingList<RoutePoint>
implements INBTSerializable<NBTTagCompound> {
    private static final String ORDERS_TAG = "orders";

    public void addRoutePoint(EnumFacing side, BlockPos pos) {
        this.add(new RoutePoint(side, pos));
    }

    private boolean check(int index) {
        return index >= 0 && index < this.size();
    }

    public void changeRouteType(int index, boolean isRmb) {
        if (this.check(index)) {
            ((RoutePoint)this.get(index)).changeRouteType(isRmb);
        }
    }

    public void changeBlockSide(int index) {
        if (this.check(index)) {
            ((RoutePoint)this.get(index)).changeBlockSide();
        }
    }

    public void toggleIgnoreDamage(int index) {
        if (this.check(index)) {
            ((RoutePoint)this.get(index)).toggleIgnoreDamage();
        }
    }

    public void toggleIgnoreTag(int index) {
        if (this.check(index)) {
            ((RoutePoint)this.get(index)).toggleIgnoreTag();
        }
    }

    public static RoutingOrder getRoutingOrder(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemRoutingOrder) {
            RoutingOrder order = new RoutingOrder();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ORDERS_TAG)) {
                order.deserializeNBT(stack.func_77978_p().func_74775_l(ORDERS_TAG));
            }
            return order;
        }
        return null;
    }

    public void write(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemRoutingOrder) {
            stack.func_77983_a(ORDERS_TAG, (NBTBase)this.serializeNBT());
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (RoutePoint p : this.points) {
            list.func_74742_a((NBTBase)p.writeToNBT(new NBTTagCompound()));
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("entryList", (NBTBase)list);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.clear();
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            this.add(new RoutePoint(entryList.func_150305_b(i)));
        }
    }

    public int handleRouteAction(RoutePoint p, IItemHandler npc, IItemHandler target) {
        switch (p.routeType) {
            case FILL_COURIER_TO: {
                return p.fillTo(target, npc);
            }
            case FILL_TARGET_TO: {
                return p.fillTo(npc, target);
            }
            case DEPOSIT_ALL_EXCEPT: {
                return p.depositAllItemsExcept(npc, target);
            }
            case DEPOSIT_ALL_OF: {
                return p.depositAllItems(npc, target);
            }
            case WITHDRAW_ALL_EXCEPT: {
                return p.depositAllItemsExcept(target, npc);
            }
            case WITHDRAW_ALL_OF: {
                return p.depositAllItems(target, npc);
            }
            case DEPOSIT_RATIO: {
                return p.depositRatio(npc, target);
            }
            case WITHDRAW_RATIO: {
                return p.depositRatio(target, npc);
            }
            case DEPOSIT_EXACT: {
                return p.depositExact(npc, target);
            }
            case WITHDRAW_EXACT: {
                return p.depositExact(target, npc);
            }
            case FILL_MINIMUM: {
                return p.fillAtLeast(npc, target);
            }
            case TAKE_MINIMUM: {
                return p.fillAtLeast(target, npc);
            }
        }
        return 0;
    }

    public List<RoutePoint> getEntries() {
        return this.points;
    }

    public static enum RouteType {
        FILL_TARGET_TO("route.fill.upto"),
        FILL_COURIER_TO("route.take.upto"),
        DEPOSIT_ALL_OF("route.deposit.match"),
        WITHDRAW_ALL_OF("route.withdraw.match"),
        DEPOSIT_ALL_EXCEPT("route.deposit.no_match"),
        WITHDRAW_ALL_EXCEPT("route.withdraw.no_match"),
        DEPOSIT_RATIO("route.deposit.ratio"),
        WITHDRAW_RATIO("route.withdraw.ratio"),
        DEPOSIT_EXACT("route.deposit.exact"),
        WITHDRAW_EXACT("route.withdraw.exact"),
        FILL_MINIMUM("route.fill.minimum"),
        TAKE_MINIMUM("route.take.minimum");

        final String key;

        private RouteType(String key) {
            this.key = key;
        }

        public String getTranslationKey() {
            return this.key;
        }

        public static RouteType next(RouteType type) {
            return type == null ? FILL_TARGET_TO : type.next();
        }

        public static RouteType previous(RouteType type) {
            return type == null ? FILL_TARGET_TO : type.previous();
        }

        public RouteType next() {
            int ordinal = this.ordinal() + 1;
            if (ordinal >= RouteType.values().length) {
                ordinal = 0;
            }
            return RouteType.values()[ordinal];
        }

        public RouteType previous() {
            int ordinal = this.ordinal() - 1;
            if (ordinal < 0) {
                ordinal = RouteType.values().length - 1;
            }
            return RouteType.values()[ordinal];
        }
    }

    public static class RoutePoint {
        private boolean ignoreDamage;
        private boolean ignoreTag;
        private RouteType routeType = RouteType.FILL_TARGET_TO;
        private BlockPos target = BlockPos.field_177992_a;
        private EnumFacing blockSide = EnumFacing.DOWN;
        private NonNullList<ItemStack> filters = NonNullList.func_191197_a((int)12, (Object)ItemStack.field_190927_a);

        private RoutePoint(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        private RoutePoint(EnumFacing side, BlockPos target) {
            this.target = target;
            this.blockSide = side;
        }

        private void changeBlockSide() {
            this.blockSide = EnumFacing.field_82609_l[(this.blockSide.ordinal() + 1) % EnumFacing.field_82609_l.length];
        }

        private void changeRouteType(boolean isRmb) {
            this.routeType = isRmb ? this.routeType.previous() : this.routeType.next();
        }

        public void setFilter(int index, ItemStack stack) {
            this.filters.set(index, (Object)stack);
        }

        public EnumFacing getBlockSide() {
            return this.blockSide;
        }

        public RouteType getRouteType() {
            return this.routeType;
        }

        public BlockPos getTarget() {
            return this.target;
        }

        public ItemStack getFilterInSlot(int slot) {
            return (ItemStack)this.filters.get(slot);
        }

        public int getFilterSize() {
            return this.filters.size();
        }

        public boolean getIgnoreDamage() {
            return this.ignoreDamage;
        }

        public boolean getIgnoreTag() {
            return this.ignoreTag;
        }

        private void toggleIgnoreDamage() {
            this.ignoreDamage = !this.ignoreDamage;
        }

        private void toggleIgnoreTag() {
            this.ignoreTag = !this.ignoreTag;
        }

        private int depositAllItems(IItemHandler from, IItemHandler to) {
            float movedStacks = 0.0f;
            for (ItemStack filter : this.filters) {
                if (filter.func_190926_b()) continue;
                int movedSize = InventoryTools.transferItems(from, to, filter, Integer.MAX_VALUE, this.ignoreDamage, this.ignoreTag);
                movedStacks += (float)movedSize / (float)filter.func_77976_d();
            }
            return (int)Math.ceil(movedStacks);
        }

        private int depositAllItemsExcept(IItemHandler from, IItemHandler to) {
            float movedStacks = 0.0f;
            for (ItemStack stack : InventoryTools.getIterator(from)) {
                if (this.matchesFilter(stack)) continue;
                ItemStack remaining = InventoryTools.insertItem(to, stack, true);
                int toMove = stack.func_190916_E() - remaining.func_190916_E();
                ItemStack removedStack = InventoryTools.removeItems(from, stack, toMove);
                InventoryTools.insertItem(to, removedStack);
                movedStacks += (float)removedStack.func_190916_E() / (float)stack.func_77976_d();
            }
            return (int)Math.ceil(movedStacks);
        }

        private boolean matchesFilter(ItemStack stack) {
            return this.filters.stream().anyMatch(s -> !s.func_190926_b() && InventoryTools.doItemStacksMatch(stack, s, this.ignoreDamage, this.ignoreTag));
        }

        private int fillTo(IItemHandler from, IItemHandler to) {
            float moved = 0.0f;
            for (ItemStack filter : this.filters) {
                int toMove;
                int foundCount;
                if (filter.func_190926_b() || (foundCount = InventoryTools.getCountOf(to, filter)) > (toMove = filter.func_190916_E())) continue;
                int m1 = InventoryTools.transferItems(from, to, filter, toMove -= foundCount, this.ignoreDamage, this.ignoreTag);
                moved += (float)m1 / (float)filter.func_77976_d();
            }
            return (int)Math.ceil(moved);
        }

        private int depositRatio(IItemHandler from, IItemHandler to) {
            float movedTotal = 0.0f;
            for (ItemStack filter : this.filters) {
                if (filter.func_190926_b()) continue;
                int foundCount = InventoryTools.getCountOf(from, filter);
                int toMove = (int)((float)foundCount * (1.0f / (float)filter.func_190916_E()));
                int moved = InventoryTools.transferItems(from, to, filter, toMove, this.ignoreDamage, this.ignoreTag);
                movedTotal += (float)moved / (float)filter.func_77976_d();
            }
            return (int)Math.ceil(movedTotal);
        }

        private int depositExact(IItemHandler from, IItemHandler to) {
            float movedTotal = 0.0f;
            for (ItemStack filter : this.filters) {
                int toMove;
                int foundCount;
                if (filter.func_190926_b() || (foundCount = InventoryTools.getCountOf(from, filter)) < (toMove = filter.func_190916_E()) || !InventoryTools.canInventoryHold(to, filter)) continue;
                int moved = InventoryTools.transferItems(from, to, filter, toMove, this.ignoreDamage, this.ignoreTag);
                movedTotal += (float)moved / (float)filter.func_77976_d();
            }
            return (int)Math.ceil(movedTotal);
        }

        private int fillAtLeast(IItemHandler from, IItemHandler to) {
            float movedTotal = 0.0f;
            for (ItemStack filter : this.filters) {
                if (filter.func_190926_b()) continue;
                int foundCount = InventoryTools.getCountOf(from, filter);
                int existingCount = InventoryTools.getCountOf(to, filter);
                int toMove = filter.func_190916_E() - existingCount;
                if (toMove < 1 || foundCount < toMove) continue;
                ItemStack filterAdjusted = filter.func_77946_l();
                filterAdjusted.func_190920_e(toMove);
                if (!InventoryTools.canInventoryHold(to, filterAdjusted)) continue;
                int moved = InventoryTools.transferItems(from, to, filterAdjusted, foundCount, this.ignoreDamage, this.ignoreTag);
                movedTotal += (float)moved / (float)filter.func_77976_d();
            }
            return (int)Math.ceil(movedTotal);
        }

        private void readFromNBT(NBTTagCompound tag) {
            this.routeType = RouteType.values()[tag.func_74762_e("type")];
            this.target = BlockPos.func_177969_a((long)tag.func_74763_f("position"));
            this.blockSide = EnumFacing.field_82609_l[tag.func_74771_c("blockSide")];
            this.ignoreDamage = tag.func_74767_n("ignoreDamage");
            this.ignoreTag = tag.func_74767_n("ignoreTag");
            NBTTagList filterList = tag.func_150295_c("filterList", 10);
            int[] filterCounts = tag.func_74759_k("filterCounts");
            for (int i = 0; i < filterList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = filterList.func_150305_b(i);
                int slot = itemTag.func_74762_e("slot");
                while (slot >= this.filters.size()) {
                    this.filters.add((Object)ItemStack.field_190927_a);
                }
                ItemStack filterStack = new ItemStack(itemTag);
                filterStack.func_190920_e(filterCounts[slot]);
                this.filters.set(slot, (Object)filterStack);
            }
        }

        private NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("type", this.routeType.ordinal());
            tag.func_74772_a("position", this.target.func_177986_g());
            tag.func_74774_a("blockSide", (byte)this.blockSide.ordinal());
            tag.func_74757_a("ignoreDamage", this.ignoreDamage);
            tag.func_74757_a("ignoreTag", this.ignoreTag);
            NBTTagList filterList = new NBTTagList();
            int[] filterCounts = new int[this.filters.size()];
            for (int i = 0; i < this.filters.size(); ++i) {
                if (((ItemStack)this.filters.get(i)).func_190926_b()) {
                    filterCounts[i] = 0;
                    continue;
                }
                filterCounts[i] = ((ItemStack)this.filters.get(i)).func_190916_E();
                ItemStack filterCopy = ((ItemStack)this.filters.get(i)).func_77946_l();
                filterCopy.func_190920_e(1);
                NBTTagCompound itemTag = filterCopy.func_77955_b(new NBTTagCompound());
                itemTag.func_74768_a("slot", i);
                filterList.func_74742_a((NBTBase)itemTag);
            }
            tag.func_74782_a("filterList", (NBTBase)filterList);
            tag.func_74783_a("filterCounts", filterCounts);
            return tag;
        }
    }
}

