/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.orders;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.util.OrderingList;
import net.shadowmage.ancientwarfare.npc.item.ItemCombatOrder;

public class CombatOrder
extends OrderingList<BlockPos>
implements INBTSerializable<NBTTagCompound> {
    int patrolDimensionId = 0;

    public void addPatrolPoint(World world, BlockPos point) {
        if (world.field_73011_w.getDimension() != this.patrolDimensionId) {
            this.clear();
            this.patrolDimensionId = world.field_73011_w.getDimension();
        }
        this.add(point);
    }

    public int getPatrolDimension() {
        return this.patrolDimensionId;
    }

    public static CombatOrder getCombatOrder(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCombatOrder) {
            CombatOrder order = new CombatOrder();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("orders")) {
                order.deserializeNBT(stack.func_77978_p().func_74775_l("orders"));
            }
            return order;
        }
        return null;
    }

    public void write(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCombatOrder) {
            stack.func_77983_a("orders", (NBTBase)this.serializeNBT());
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("dim", this.patrolDimensionId);
        if (!this.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (BlockPos point : this.points) {
                list.func_74742_a((NBTBase)new NBTTagLong(point.func_177986_g()));
            }
            tag.func_74782_a("pointList", (NBTBase)list);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.clear();
        this.patrolDimensionId = tag.func_74762_e("dim");
        if (tag.func_74764_b("pointList")) {
            NBTTagList list = tag.func_150295_c("pointList", 4);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.add(BlockPos.func_177969_a((long)((NBTTagLong)list.func_179238_g(i)).func_150291_c()));
            }
        }
    }
}

