/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.init.AWNPCEntities;
import net.shadowmage.ancientwarfare.npc.init.AWNPCItems;
import net.shadowmage.ancientwarfare.npc.item.ItemBaseNPC;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;

public class ItemNpcSpawner
extends ItemBaseNPC {
    private static final String NPC_TYPE_TAG = "npcType";
    private static final String NPC_SUBTYPE_TAG = "npcSubtype";
    private static final String FACTION_TAG = "faction";
    private static final String NPC_STORED_DATA_TAG = "npcStoredData";

    public ItemNpcSpawner() {
        super("npc_spawner");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"guistrings.npc.spawner.right_click_to_place", (Object[])new Object[0]));
    }

    public String func_77667_c(ItemStack stack) {
        String npcName = ItemNpcSpawner.getNpcType(stack);
        if (npcName != null) {
            npcName = npcName.replace("faction.", "");
            String npcSub = ItemNpcSpawner.getNpcSubtype(stack);
            if (!npcSub.isEmpty()) {
                npcName = npcName + "." + npcSub;
            }
            return "entity.ancientwarfarenpc." + ItemNpcSpawner.getFaction(stack).map(s -> s + ".").orElse("") + npcName;
        }
        return super.func_77667_c(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        BlockPos hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
        if (hit == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        NpcBase npc = ItemNpcSpawner.createNpcFromItem(player.field_70170_p, stack);
        if (npc != null) {
            if (npc instanceof NpcPlayerOwned) {
                npc.setOwner(player);
            }
            npc.func_70107_b((double)hit.func_177958_n() + 0.5, hit.func_177956_o(), (double)hit.func_177952_p() + 0.5);
            npc.setHomeAreaAtCurrentPosition();
            player.field_70170_p.func_72838_d((Entity)npc);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static NpcBase createNpcFromItem(World world, ItemStack stack) {
        Optional<String> faction;
        String type = ItemNpcSpawner.getNpcType(stack);
        if (type == null) {
            return null;
        }
        String subType = ItemNpcSpawner.getNpcSubtype(stack);
        NpcBase npc = AWNPCEntities.createNpc(world, type, subType, (faction = ItemNpcSpawner.getFaction(stack)).orElse(""));
        if (npc == null) {
            return null;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NPC_STORED_DATA_TAG)) {
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                npc.func_184201_a(slot, ItemStack.field_190927_a);
            }
            npc.readAdditionalItemData(stack.func_77978_p().func_74775_l(NPC_STORED_DATA_TAG));
        }
        return npc;
    }

    public static ItemStack getSpawnerItemForNpc(NpcBase npc) {
        String type = npc.getNpcType();
        String sub = npc.getNpcSubType();
        ItemStack stack = npc instanceof NpcFaction ? ItemNpcSpawner.getStackForNpcType("faction." + type, sub, ((NpcFaction)npc).getFaction()) : ItemNpcSpawner.getStackForNpcType(type, sub);
        NBTTagCompound tag = new NBTTagCompound();
        npc.writeAdditionalItemData(tag);
        stack.func_77983_a(NPC_STORED_DATA_TAG, (NBTBase)tag);
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemNpcSpawner.getSpawnerSubItems(items);
    }

    private static void getSpawnerSubItems(NonNullList<ItemStack> list) {
        ArrayList<ItemStack> playerOwned = new ArrayList<ItemStack>();
        ArrayList<ItemStack> factionOwned = new ArrayList<ItemStack>();
        for (AWNPCEntities.NpcDeclaration dec : AWNPCEntities.getNpcMap().values()) {
            if (dec.canSpawnBaseEntity()) {
                if (dec.getNpcType().startsWith("faction.")) {
                    for (String factionName : FactionRegistry.getFactionNames()) {
                        if (!NpcDefaultsRegistry.getFactionNpcDefault(factionName, ItemNpcSpawner.getShortNpcType(dec)).isEnabled()) continue;
                        factionOwned.add(ItemNpcSpawner.getStackForNpcType(dec.getNpcType(), "", factionName));
                    }
                } else {
                    playerOwned.add(ItemNpcSpawner.getStackForNpcType(dec.getNpcType(), "", ""));
                }
            }
            for (String sub : dec.getSubTypes()) {
                playerOwned.add(ItemNpcSpawner.getStackForNpcType(dec.getNpcType(), sub));
            }
        }
        list.addAll(playerOwned);
        list.addAll(factionOwned);
    }

    private static String getShortNpcType(AWNPCEntities.NpcDeclaration dec) {
        String shortType = dec.getNpcType().substring("faction.".length());
        return shortType.equals("siege_engineer") ? "siege.engineer" : shortType;
    }

    private static ItemStack getStackForNpcType(String type, String npcSubtype) {
        return ItemNpcSpawner.getStackForNpcType(type, npcSubtype, "");
    }

    private static ItemStack getStackForNpcType(String type, String npcSubtype, String faction) {
        ItemStack stack = new ItemStack(AWNPCItems.NPC_SPAWNER);
        stack.func_77983_a(NPC_TYPE_TAG, (NBTBase)new NBTTagString(type));
        stack.func_77983_a(NPC_SUBTYPE_TAG, (NBTBase)new NBTTagString(npcSubtype));
        if (!faction.isEmpty()) {
            stack.func_77983_a(FACTION_TAG, (NBTBase)new NBTTagString(faction));
        }
        return stack;
    }

    @Nullable
    public static String getNpcType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NPC_TYPE_TAG)) {
            return stack.func_77978_p().func_74779_i(NPC_TYPE_TAG);
        }
        return null;
    }

    private static String getNpcSubtype(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NPC_SUBTYPE_TAG)) {
            return stack.func_77978_p().func_74779_i(NPC_SUBTYPE_TAG);
        }
        return "";
    }

    public static Optional<String> getFaction(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(FACTION_TAG)) {
            return Optional.of(stack.func_77978_p().func_74779_i(FACTION_TAG));
        }
        return Optional.empty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        HashMap modelLocations = Maps.newHashMap();
        AWNPCEntities.getNpcMap().values().stream().map(AWNPCEntities.NpcDeclaration::getItemModelVariants).flatMap(Collection::stream).distinct().forEach(v -> {
            modelLocations.put(v, this.getModelLocation((String)v));
            ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{(ResourceLocation)modelLocations.get(v)});
        });
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            AWNPCEntities.NpcDeclaration dec;
            String npcType = ItemNpcSpawner.getNpcType(stack);
            if (npcType == null) {
                npcType = "worker";
            }
            return (dec = AWNPCEntities.getNpcDeclaration(npcType)) == null ? null : (ModelResourceLocation)modelLocations.get(dec.getItemModelVariant(ItemNpcSpawner.getNpcSubtype(stack)));
        });
    }

    private ModelResourceLocation getModelLocation(String modelVariant) {
        return new ModelResourceLocation("ancientwarfare:npc/npc_spawner", "variant=" + modelVariant);
    }
}

