/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.ItemBaseNPC;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;

public class ItemCommandBaton
extends ItemBaseNPC
implements IItemKeyInterface {
    private final double attackDamage;
    int range = 120;
    private final Item.ToolMaterial material;

    public ItemCommandBaton(String name, Item.ToolMaterial material) {
        super(name);
        this.attackDamage = 4.0f + material.func_78000_c();
        this.material = material;
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String text = "RMB = " + I18n.func_135052_a((String)"guistrings.npc.baton.add_remove", (Object[])new Object[0]);
        tooltip.add(text);
        String keyText = InputHandler.ALT_ITEM_USE_1.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.npc.baton.clear", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_2.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.npc.baton.attack", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_3.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.npc.baton.move", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_4.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.npc.baton.home", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_5.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.npc.baton.upkeep", (Object[])new Object[0]);
        tooltip.add(text);
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase attacked, EntityLivingBase wielder) {
        stack.func_77972_a(1, wielder);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (state.func_185887_b(world, pos) != 0.0f) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.attackDamage, 0));
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.3, 0));
        return multimap;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        NpcBase npc;
        RayTraceResult pos;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!player.func_70093_af() && (pos = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f)) != null && pos.field_72313_a == RayTraceResult.Type.ENTITY && pos.field_72308_g instanceof NpcBase && (npc = (NpcBase)pos.field_72308_g).hasCommandPermissions(player.func_110124_au(), player.func_70005_c_())) {
            this.onNpcClicked(player, npc, stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        switch (altFunction) {
            case ALT_FUNCTION_1: {
                RayTraceResult hit = new RayTraceResult((Entity)player);
                NpcCommand.handleCommandClient(NpcCommand.CommandType.CLEAR_COMMAND, hit);
                break;
            }
            case ALT_FUNCTION_2: {
                RayTraceResult hit = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f);
                if (hit == null) break;
                NpcCommand.CommandType c = hit.field_72313_a == RayTraceResult.Type.ENTITY ? NpcCommand.CommandType.ATTACK : NpcCommand.CommandType.ATTACK_AREA;
                NpcCommand.handleCommandClient(c, hit);
                break;
            }
            case ALT_FUNCTION_3: {
                RayTraceResult hit = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f);
                if (hit == null) break;
                NpcCommand.CommandType c = hit.field_72313_a == RayTraceResult.Type.ENTITY ? NpcCommand.CommandType.GUARD : NpcCommand.CommandType.MOVE;
                NpcCommand.handleCommandClient(c, hit);
                break;
            }
            case ALT_FUNCTION_4: {
                RayTraceResult hit = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f);
                if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) break;
                NpcCommand.CommandType c = player.func_70093_af() ? NpcCommand.CommandType.CLEAR_HOME : NpcCommand.CommandType.SET_HOME;
                NpcCommand.handleCommandClient(c, hit);
                break;
            }
            case ALT_FUNCTION_5: {
                RayTraceResult hit = RayTraceUtils.getPlayerTarget(player, this.range, 0.0f);
                if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) break;
                NpcCommand.CommandType c = player.func_70093_af() ? NpcCommand.CommandType.CLEAR_UPKEEP : NpcCommand.CommandType.SET_UPKEEP;
                NpcCommand.handleCommandClient(c, hit);
            }
        }
        return false;
    }

    private void onNpcClicked(EntityPlayer player, NpcBase npc, ItemStack stack) {
        if (player == null || npc == null || stack.func_190926_b() || stack.func_77973_b() != this) {
            return;
        }
        CommandSet.loadFromStack(stack, false).onNpcClicked(npc, stack);
    }

    public static List<Entity> getCommandedEntities(World world, ItemStack stack) {
        if (world == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCommandBaton)) {
            return new ArrayList<Entity>();
        }
        return CommandSet.loadFromStack(stack, world.field_72995_K).getEntities(world);
    }

    private static class CommandSet {
        private Set<UUID> ids = new HashSet<UUID>();

        private CommandSet() {
        }

        public static CommandSet loadFromStack(ItemStack stack, boolean client) {
            CommandSet set = new CommandSet();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("entityList")) {
                set.readFromNBT(stack.func_77978_p().func_74775_l("entityList"), client);
            }
            return set;
        }

        private void writeToStack(ItemStack stack) {
            stack.func_77983_a("entityList", (NBTBase)this.writeToNBT());
        }

        private void readFromNBT(NBTTagCompound tag, boolean client) {
            NBTTagList entryList = tag.func_150295_c("entryList", 10);
            for (int i = 0; i < entryList.func_74745_c(); ++i) {
                NBTTagCompound idTag = entryList.func_150305_b(i);
                this.ids.add(idTag.func_186857_a("uuid"));
            }
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList entryList = new NBTTagList();
            for (UUID id : this.ids) {
                NBTTagCompound idTag = new NBTTagCompound();
                idTag.func_186854_a("uuid", id);
                entryList.func_74742_a((NBTBase)idTag);
            }
            tag.func_74782_a("entryList", (NBTBase)entryList);
            return tag;
        }

        public void onNpcClicked(NpcBase npc, ItemStack stack) {
            if (this.ids.contains(npc.getPersistentID())) {
                this.ids.remove(npc.getPersistentID());
            } else {
                this.ids.add(npc.getPersistentID());
            }
            this.validateEntities(npc.field_70170_p);
            this.writeToStack(stack);
        }

        public List<Entity> getEntities(World world) {
            ArrayList in;
            block4: {
                block3: {
                    in = Lists.newArrayList();
                    if (!(world instanceof WorldServer)) break block3;
                    WorldServer worldServer = (WorldServer)world;
                    for (UUID id : this.ids) {
                        Entity e = worldServer.func_175733_a(id);
                        if (e == null) continue;
                        in.add(e);
                    }
                    break block4;
                }
                if (!(world instanceof WorldClient)) break block4;
                for (Entity entity : world.field_72996_f) {
                    for (UUID id : this.ids) {
                        if (!entity.getPersistentID().equals(id)) continue;
                        in.add(entity);
                    }
                }
            }
            return in;
        }

        private void validateEntities(World world) {
            if (world instanceof WorldServer) {
                WorldServer worldServer = (WorldServer)world;
                Iterator<UUID> it = this.ids.iterator();
                while (it.hasNext()) {
                    UUID id = it.next();
                    if (id != null && worldServer.func_175733_a(id) != null) continue;
                    it.remove();
                }
            }
        }
    }
}

