/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.npc.network.PacketExtendedReachAttack;

public interface IExtendedReachWeapon {
    public float getReach();

    @SideOnly(value=Side.CLIENT)
    public static class MouseClickHandler {
        @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
        public void onMouseClick(MouseEvent event) {
            if (event.getButton() != 0 || !event.isButtonstate()) {
                return;
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !(player.func_184614_ca().func_77973_b() instanceof IExtendedReachWeapon)) {
                return;
            }
            IExtendedReachWeapon weapon = (IExtendedReachWeapon)player.func_184614_ca().func_77973_b();
            Optional<RayTraceResult> result = this.getMouseOverExtended(weapon.getReach());
            result.ifPresent(arg_0 -> MouseClickHandler.lambda$onMouseClick$0((EntityPlayer)player, arg_0));
        }

        @SideOnly(value=Side.CLIENT)
        private Optional<RayTraceResult> getMouseOverExtended(float reach) {
            RayTraceResult ret = null;
            Minecraft mc = Minecraft.func_71410_x();
            Entity renderViewEntity = mc.func_175606_aa();
            if (renderViewEntity != null && mc.field_71441_e != null) {
                mc.field_71424_I.func_76320_a("pick");
                double d0 = reach;
                ret = renderViewEntity.func_174822_a(d0, 0.0f);
                Vec3d positionEyes = renderViewEntity.func_174824_e(0.0f);
                double calcDist = d0;
                if (ret != null) {
                    calcDist = ret.field_72307_f.func_72438_d(positionEyes);
                }
                Vec3d vec3d1 = renderViewEntity.func_70676_i(1.0f);
                Vec3d vec3d2 = positionEyes.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
                List list = mc.field_71441_e.func_175674_a(renderViewEntity, renderViewEntity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, e -> e != null && e.func_70067_L()));
                ret = this.getEntityHit(ret, renderViewEntity, positionEyes, calcDist, vec3d2, list);
            }
            return Optional.ofNullable(ret);
        }

        @Nullable
        private RayTraceResult getEntityHit(@Nullable RayTraceResult ret, Entity renderViewEntity, Vec3d positionEyes, double calcDist, Vec3d vec3d2, List<Entity> list) {
            double d = calcDist;
            Entity pointedEntity = null;
            for (Entity entity : list) {
                double d1;
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(positionEyes, vec3d2);
                if (axisalignedbb.func_72318_a(positionEyes)) {
                    if (!(d >= 0.0)) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d1 = positionEyes.func_72438_d(raytraceresult.field_72307_f)) < d) && d != 0.0) continue;
                if (entity.func_184208_bv() == renderViewEntity.func_184208_bv() && !entity.canRiderInteract()) {
                    if (d != 0.0) continue;
                    pointedEntity = entity;
                    continue;
                }
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcDist || ret == null)) {
                ret = new RayTraceResult(pointedEntity);
            }
            return ret;
        }

        private static /* synthetic */ void lambda$onMouseClick$0(EntityPlayer player, RayTraceResult r) {
            if (r.field_72308_g != null && r.field_72308_g.field_70172_ad == 0 && r.field_72308_g != player) {
                NetworkHandler.sendToServer(new PacketExtendedReachAttack(r.field_72308_g.func_145782_y()));
            }
        }
    }
}

