/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.ItemUpkeepOrder;

public class NpcEquipmentHandler
extends ItemStackHandler {
    private static final int SIZE_INVENTORY = 8;
    private final NpcBase npc;

    public NpcEquipmentHandler(NpcBase npc) {
        super(8);
        this.npc = npc;
        this.stacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 8; ++i) {
            if (npc.getItemStackFromSlot(i).func_190926_b()) continue;
            this.stacks.set(i, (Object)npc.getItemStackFromSlot(i).func_77946_l());
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.isItemStackValidForSlot(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
    }

    private boolean isItemStackValidForSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b() || slot < 0) {
            return false;
        }
        if (slot == 7) {
            return stack.func_77973_b() instanceof ItemUpkeepOrder;
        }
        if (slot == 6) {
            return this.npc.isValidOrdersStack(stack);
        }
        if (slot > 1 && slot < 6) {
            return stack.func_77973_b().isValidArmor(stack, EntityEquipmentSlot.values()[slot], (Entity)this.npc);
        }
        return true;
    }

    protected void onContentsChanged(int slot) {
        this.npc.setItemStackToSlot(slot, (ItemStack)this.stacks.get(slot));
    }
}

