/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.init;

import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.core.util.InjectionTools;
import net.shadowmage.ancientwarfare.npc.item.ItemBardInstrument;
import net.shadowmage.ancientwarfare.npc.item.ItemCoin;
import net.shadowmage.ancientwarfare.npc.item.ItemCombatOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.item.ItemExtendedReachWeapon;
import net.shadowmage.ancientwarfare.npc.item.ItemFoodBundle;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;
import net.shadowmage.ancientwarfare.npc.item.ItemRoutingOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemShield;
import net.shadowmage.ancientwarfare.npc.item.ItemTradeOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemUpkeepOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemWorkOrder;

@GameRegistry.ObjectHolder(value="ancientwarfarenpc")
@Mod.EventBusSubscriber(modid="ancientwarfarenpc")
public class AWNPCItems {
    public static final ItemCommandBaton IRON_COMMAND_BATON = (ItemCommandBaton)InjectionTools.nullValue();
    public static final ItemShield WOODEN_SHIELD = (ItemShield)InjectionTools.nullValue();
    public static final Item NPC_SPAWNER = (Item)InjectionTools.nullValue();
    public static final Item WORK_ORDER = (Item)InjectionTools.nullValue();
    public static final Item UPKEEP_ORDER = (Item)InjectionTools.nullValue();
    public static final Item COMBAT_ORDER = (Item)InjectionTools.nullValue();
    public static final Item ROUTING_ORDER = (Item)InjectionTools.nullValue();
    public static final Item TRADE_ORDER = (Item)InjectionTools.nullValue();
    public static final Item BARD_INSTRUMENT = (Item)InjectionTools.nullValue();
    public static final Item COIN = (Item)InjectionTools.nullValue();

    private AWNPCItems() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("wooden_command_baton", Item.ToolMaterial.WOOD));
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("stone_command_baton", Item.ToolMaterial.STONE));
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("iron_command_baton", Item.ToolMaterial.IRON));
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("gold_command_baton", Item.ToolMaterial.GOLD));
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("diamond_command_baton", Item.ToolMaterial.DIAMOND));
        registry.register((IForgeRegistryEntry)new ItemBardInstrument("bard_instrument"));
        registry.register((IForgeRegistryEntry)new ItemShield("wooden_shield", Item.ToolMaterial.WOOD));
        registry.register((IForgeRegistryEntry)new ItemShield("stone_shield", Item.ToolMaterial.WOOD));
        registry.register((IForgeRegistryEntry)new ItemShield("iron_shield", Item.ToolMaterial.WOOD));
        registry.register((IForgeRegistryEntry)new ItemShield("gold_shield", Item.ToolMaterial.WOOD));
        registry.register((IForgeRegistryEntry)new ItemShield("diamond_shield", Item.ToolMaterial.WOOD));
        registry.register((IForgeRegistryEntry)new ItemWorkOrder());
        registry.register((IForgeRegistryEntry)new ItemUpkeepOrder());
        registry.register((IForgeRegistryEntry)new ItemCombatOrder());
        registry.register((IForgeRegistryEntry)new ItemRoutingOrder());
        registry.register((IForgeRegistryEntry)new ItemTradeOrder());
        registry.register((IForgeRegistryEntry)new ItemNpcSpawner());
        registry.register((IForgeRegistryEntry)new ItemCoin());
        ItemFoodBundle bundle = new ItemFoodBundle();
        registry.register((IForgeRegistryEntry)bundle);
        OreDictionary.registerOre((String)"foodBundle", (Item)bundle);
        AWNPCItems.registerExtendedReachWeapons((IForgeRegistry<Item>)registry, "spear", 2.0, -3.0, 4.2f);
        AWNPCItems.registerExtendedReachWeapons((IForgeRegistry<Item>)registry, "halberd", 3.0, -3.2, 4.5f);
        AWNPCItems.registerExtendedReachWeapons((IForgeRegistry<Item>)registry, "lance", 2.5, -3.2, 5.5f);
    }

    private static void registerExtendedReachWeapons(IForgeRegistry<Item> registry, String name, double attackOffset, double attackSpeed, float reach) {
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.WOOD, "wooden_" + name, attackOffset, attackSpeed, reach));
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.STONE, "stone_" + name, attackOffset, attackSpeed, reach));
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.IRON, "iron_" + name, attackOffset, attackSpeed, reach));
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.GOLD, "golden_" + name, attackOffset, attackSpeed, reach));
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.DIAMOND, "diamond_" + name, attackOffset, attackSpeed, reach));
    }
}

