/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.shadowmage.ancientwarfare.core.block.Direction;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Line;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.npc.container.ContainerRoutingOrder;
import net.shadowmage.ancientwarfare.npc.orders.RoutingOrder;
import org.lwjgl.input.Mouse;

public class GuiRoutingOrder
extends GuiContainerBase<ContainerRoutingOrder> {
    private boolean hasChanged = false;
    private CompositeScrolled area;

    public GuiRoutingOrder(ContainerBase container) {
        super(container);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 0, this.field_146999_f, this.field_147000_g - 72 - 8 - 4 - 8);
        this.addGuiElement(this.area);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        List<RoutingOrder.RoutePoint> entries = ((ContainerRoutingOrder)((Object)this.getContainer())).routingOrder.getEntries();
        int totalHeight = 12;
        int index = 0;
        for (RoutingOrder.RoutePoint point : entries) {
            BlockPos pos = point.getTarget();
            Block block = this.player.field_70170_p.func_180495_p(pos).func_177230_c();
            Label label = new Label(8, totalHeight, block == null ? "" : block.func_149732_F());
            this.area.addGuiElement(label);
            label = new Label(120, totalHeight, StringTools.formatPos(pos));
            this.area.addGuiElement(label);
            String labelString = Direction.getDirectionFor(point.getBlockSide()).getTranslationKey();
            IndexedButton button = new IndexedButton(8, totalHeight + 10, 55, 12, labelString, index){

                @Override
                protected void onPressed() {
                    ((ContainerRoutingOrder)((Object)GuiRoutingOrder.this.getContainer())).routingOrder.changeBlockSide(this.index);
                    GuiRoutingOrder.this.refreshGui();
                    GuiRoutingOrder.this.hasChanged = true;
                }
            };
            this.area.addGuiElement(button);
            labelString = point.getRouteType().getTranslationKey();
            button = new IndexedButton(65, totalHeight + 10, 79, 12, labelString, index){

                @Override
                protected void onPressed(int mButton) {
                    ((ContainerRoutingOrder)((Object)GuiRoutingOrder.this.getContainer())).routingOrder.changeRouteType(this.index, mButton == 1);
                    GuiRoutingOrder.this.refreshGui();
                    GuiRoutingOrder.this.hasChanged = true;
                }
            };
            this.area.addGuiElement(button);
            labelString = point.getIgnoreDamage() ? TextFormatting.RED.toString() + TextFormatting.STRIKETHROUGH.toString() : "";
            labelString = labelString + I18n.func_135052_a((String)"guistrings.dmg", (Object[])new Object[0]);
            button = new IndexedButton(146, totalHeight + 10, 38, 12, labelString, index){

                @Override
                protected void onPressed() {
                    ((ContainerRoutingOrder)((Object)GuiRoutingOrder.this.getContainer())).routingOrder.toggleIgnoreDamage(this.index);
                    GuiRoutingOrder.this.hasChanged = true;
                    GuiRoutingOrder.this.refreshGui();
                }
            };
            button.addTooltip(I18n.func_135052_a((String)("guistrings.dmg.tooltipprefix." + (point.getIgnoreDamage() ? "disabled" : "enabled")), (Object[])new Object[0]) + I18n.func_135052_a((String)"guistrings.dmg.tooltip", (Object[])new Object[0]), 28);
            this.area.addGuiElement(button);
            labelString = point.getIgnoreTag() ? TextFormatting.RED.toString() + TextFormatting.STRIKETHROUGH.toString() : "";
            labelString = labelString + I18n.func_135052_a((String)"guistrings.tag", (Object[])new Object[0]);
            button = new IndexedButton(186, totalHeight + 10, 38, 12, labelString, index){

                @Override
                protected void onPressed() {
                    ((ContainerRoutingOrder)((Object)GuiRoutingOrder.this.getContainer())).routingOrder.toggleIgnoreTag(this.index);
                    GuiRoutingOrder.this.hasChanged = true;
                    GuiRoutingOrder.this.refreshGui();
                }
            };
            button.addTooltip(I18n.func_135052_a((String)("guistrings.tag.tooltipprefix." + (point.getIgnoreTag() ? "disabled" : "enabled")), (Object[])new Object[0]) + I18n.func_135052_a((String)"guistrings.tag.tooltip", (Object[])new Object[0]), 28);
            this.area.addGuiElement(button);
            for (int i = 0; i < point.getFilterSize(); ++i) {
                IndexedRoutePointItemSlot slot = new IndexedRoutePointItemSlot(9 + i * 18, totalHeight + 10 + 12 + 2, point.getFilterInSlot(i), this, point, i){

                    @Override
                    public void onSlotClicked(ItemStack stack, boolean rightClicked) {
                        GuiRoutingOrder.this.onFilterSlotClicked(this, this.point, this.index, stack);
                    }
                };
                this.area.addGuiElement(slot);
            }
            button = new IndexedButton(229, totalHeight, 12, 9, "guistrings.npc.remove_point", index){

                @Override
                protected void onPressed() {
                    ((ContainerRoutingOrder)((Object)GuiRoutingOrder.this.getContainer())).routingOrder.remove(this.index);
                    GuiRoutingOrder.this.refreshGui();
                    GuiRoutingOrder.this.hasChanged = true;
                }
            };
            this.area.addGuiElement(button);
            button = new IndexedButton(229, totalHeight + 15, 12, 12, "guistrings.moveup", index){

                @Override
                protected void onPressed() {
                    ((ContainerRoutingOrder)((Object)GuiRoutingOrder.this.getContainer())).routingOrder.increment(this.index);
                    GuiRoutingOrder.this.refreshGui();
                    GuiRoutingOrder.this.hasChanged = true;
                }
            };
            this.area.addGuiElement(button);
            button = new IndexedButton(229, totalHeight + 29, 12, 12, "guistrings.movedown", index){

                @Override
                protected void onPressed() {
                    ((ContainerRoutingOrder)((Object)GuiRoutingOrder.this.getContainer())).routingOrder.decrement(this.index);
                    GuiRoutingOrder.this.refreshGui();
                    GuiRoutingOrder.this.hasChanged = true;
                }
            };
            this.area.addGuiElement(button);
            this.area.addGuiElement(new Line(0, (totalHeight += 48) - 1, this.field_146999_f - 13, totalHeight - 1, 1, 255));
            totalHeight += 6;
            ++index;
        }
        this.area.setAreaSize(totalHeight);
    }

    private void onFilterSlotClicked(ItemSlot slot, RoutingOrder.RoutePoint point, int index, ItemStack stack) {
        if (!slot.getStack().func_190926_b() && GuiRoutingOrder.func_146272_n()) {
            if (Mouse.getEventButton() == 0) {
                slot.getStack().func_190917_f(32);
                point.setFilter(index, slot.getStack());
            } else if (Mouse.getEventButton() == 1) {
                slot.getStack().func_190918_g(32);
                if (slot.getStack().func_190916_E() < 1) {
                    slot.getStack().func_190920_e(1);
                }
                point.setFilter(index, slot.getStack());
            }
        } else if (!slot.getStack().func_190926_b() && GuiRoutingOrder.func_146271_m()) {
            if (Mouse.getEventButton() == 0) {
                slot.getStack().func_190917_f(1);
                point.setFilter(index, slot.getStack());
            } else if (Mouse.getEventButton() == 1) {
                slot.getStack().func_190918_g(1);
                if (slot.getStack().func_190916_E() < 1) {
                    slot.getStack().func_190920_e(1);
                }
                point.setFilter(index, slot.getStack());
            }
        } else if (stack.func_190926_b()) {
            point.setFilter(index, ItemStack.field_190927_a);
            slot.setItem(ItemStack.field_190927_a);
        } else if (InventoryTools.doItemStacksMatchRelaxed(stack, slot.getStack())) {
            if (Mouse.getEventButton() == 0) {
                slot.getStack().func_190917_f(stack.func_190916_E());
                point.setFilter(index, slot.getStack());
            } else if (Mouse.getEventButton() == 1) {
                slot.getStack().func_190918_g(stack.func_190916_E());
                if (slot.getStack().func_190916_E() < 1) {
                    slot.getStack().func_190920_e(1);
                }
                point.setFilter(index, slot.getStack());
            }
        } else {
            stack = stack.func_77946_l();
            point.setFilter(index, stack);
            slot.setItem(stack);
        }
        this.hasChanged = true;
    }

    @Override
    protected boolean onGuiCloseRequested() {
        if (this.hasChanged) {
            ((ContainerRoutingOrder)((Object)this.getContainer())).onClose();
        }
        return super.onGuiCloseRequested();
    }

    private class IndexedButton
    extends Button {
        final int index;

        public IndexedButton(int topLeftX, int topLeftY, int width, int height, String text, int index) {
            super(topLeftX, topLeftY, width, height, text);
            this.index = index;
        }
    }

    private class IndexedRoutePointItemSlot
    extends ItemSlot {
        final RoutingOrder.RoutePoint point;
        final int index;

        public IndexedRoutePointItemSlot(int topLeftX, int topLeftY, ItemStack item, ITooltipRenderer render, RoutingOrder.RoutePoint point, int index) {
            super(topLeftX, topLeftY, item, render);
            this.point = point;
            this.index = index;
        }
    }
}

