/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Line;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionTradeSetup;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionTrader;
import net.shadowmage.ancientwarfare.npc.gui.GuiTradeTemplateSelect;
import net.shadowmage.ancientwarfare.npc.trade.FactionTrade;
import net.shadowmage.ancientwarfare.npc.trade.Trade;
import net.shadowmage.ancientwarfare.npc.trade.TradeList;

public class GuiNpcFactionTradeSetup
extends GuiContainerBase<ContainerNpcFactionTradeSetup> {
    private CompositeScrolled area;
    private TradeList tradeList;

    public GuiNpcFactionTradeSetup(ContainerBase container) {
        super(container, 320, 240);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 0, this.field_146999_f, this.field_147000_g - 16 - 4 - 72);
        this.addGuiElement(this.area);
        Button templateButton = new Button(170, this.field_147000_g - 85, this.field_146999_f - 174, 12, "guistrings.select_trade_template"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTradeTemplateSelect(GuiNpcFactionTradeSetup.this, ((NpcFactionTrader)((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).entity).getFaction()));
                GuiNpcFactionTradeSetup.this.refreshGui();
            }
        };
        this.addGuiElement(templateButton);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        this.tradeList = ((ContainerNpcFactionTradeSetup)((Object)this.getContainer())).tradeList;
        if (this.tradeList == null) {
            return;
        }
        int totalHeight = 8;
        for (int i = 0; i < this.tradeList.size(); ++i) {
            totalHeight = this.addTrade((Trade)this.tradeList.get(i), totalHeight, i);
        }
        Button newTradeButton = new Button(8, totalHeight, this.field_146999_f - 8 - 16, 12, "guistrings.new_trade"){

            @Override
            protected void onPressed() {
                GuiNpcFactionTradeSetup.this.tradeList.addNewTrade();
                ((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).tradesChanged = true;
                GuiNpcFactionTradeSetup.this.refreshGui();
            }
        };
        this.area.addGuiElement(newTradeButton);
        this.area.setAreaSize(totalHeight += 12);
    }

    private int addTrade(Trade trade, int startHeight, int tradeNum) {
        int gridX = 0;
        int gridY = 0;
        for (int i = 0; i < trade.size(); ++i) {
            int slotX = gridX * 18 + 8;
            int slotY = gridY * 18 + startHeight;
            this.addTradeInputSlot(trade, slotX, slotY, i);
            this.addTradeOutputSlot(trade, slotX += 63, slotY, i);
            if (++gridX < 3) continue;
            gridX = 0;
            ++gridY;
        }
        this.addTradeControls((FactionTrade)trade, startHeight, tradeNum);
        this.area.addGuiElement(new Line(0, (startHeight += 18 * gridY) + 1, this.field_146999_f, startHeight + 1, 1, 255));
        return startHeight += 5;
    }

    private void addTradeControls(final FactionTrade trade, int startHeight, final int tradeNum) {
        --startHeight;
        int startWidth = 62;
        if (trade.size() < 3) {
            startWidth += (trade.size() - 3) * 18;
        }
        int infoX = startWidth * 2 + 5;
        Button upButton = new Button(infoX, startHeight, 55, 12, "guistrings.up"){

            @Override
            protected void onPressed() {
                GuiNpcFactionTradeSetup.this.tradeList.increment(tradeNum);
                GuiNpcFactionTradeSetup.this.refreshGui();
                ((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).tradesChanged = true;
            }
        };
        this.area.addGuiElement(upButton);
        Button downButton = new Button(infoX, startHeight + 54 - 12, 55, 12, "guistrings.down"){

            @Override
            protected void onPressed() {
                GuiNpcFactionTradeSetup.this.tradeList.decrement(tradeNum);
                GuiNpcFactionTradeSetup.this.refreshGui();
                ((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).tradesChanged = true;
            }
        };
        this.area.addGuiElement(downButton);
        Button delete = new Button(infoX, startHeight + 21, 55, 12, "guistrings.delete"){

            @Override
            protected void onPressed() {
                GuiNpcFactionTradeSetup.this.tradeList.remove(tradeNum);
                GuiNpcFactionTradeSetup.this.refreshGui();
                ((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).tradesChanged = true;
            }
        };
        this.area.addGuiElement(delete);
        this.area.addGuiElement(new Label(startWidth + 1, startHeight + 20, ">"));
        this.area.addGuiElement(new Label(infoX + 55 + 4, startHeight + 1, "guistrings.max_trades"));
        this.area.addGuiElement(new Label(infoX + 55 + 4, startHeight + 18 + 1, "guistrings.refill_frequency"));
        NumberInput tradeInput = new NumberInput(infoX + 55 + 4 + 60, startHeight, 40, trade.getMaxAvailable(), this){

            @Override
            public void onValueUpdated(float value) {
                trade.setMaxAvailable((int)value);
                ((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).tradesChanged = true;
            }
        };
        tradeInput.setIntegerValue();
        this.area.addGuiElement(tradeInput);
        NumberInput refillInput = new NumberInput(infoX + 55 + 4 + 60, startHeight + 18, 40, trade.getRefillFrequency(), this){

            @Override
            public void onValueUpdated(float value) {
                trade.setRefillFrequency((int)value);
                ((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).tradesChanged = true;
            }
        };
        refillInput.setIntegerValue();
        refillInput.setAllowNegative();
        this.area.addGuiElement(refillInput);
    }

    private void addTradeInputSlot(final Trade trade, int x, int y, final int slotNum) {
        ItemStack stack = trade.getInputStack(slotNum);
        stack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
        ItemSlot slot = new ItemSlot(x, y, stack, this){

            @Override
            public void onSlotClicked(ItemStack stack, boolean rightClicked) {
                stack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
                this.setItem(stack);
                trade.setInputStack(slotNum, stack);
                ((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).tradesChanged = true;
            }
        };
        if (stack.func_190926_b()) {
            slot.addTooltip("guistrings.npc.trade_input_slot");
        }
        this.area.addGuiElement(slot);
    }

    private void addTradeOutputSlot(final Trade trade, int x, int y, final int slotNum) {
        ItemStack stack = trade.getOutputStack(slotNum);
        stack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
        ItemSlot slot = new ItemSlot(x, y, stack, this){

            @Override
            public void onSlotClicked(ItemStack stack, boolean rightClicked) {
                stack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
                this.setItem(stack);
                trade.setOutputStack(slotNum, stack);
                ((ContainerNpcFactionTradeSetup)((Object)GuiNpcFactionTradeSetup.this.getContainer())).tradesChanged = true;
            }
        };
        if (stack.func_190926_b()) {
            slot.addTooltip("guistrings.npc.trade_output_slot");
        }
        this.area.addGuiElement(slot);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerNpcFactionTradeSetup)((Object)this.getContainer())).onGuiClosed();
        return super.onGuiCloseRequested();
    }
}

