/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcCreativeControls;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class GuiNpcCreativeControls
extends GuiContainerBase<ContainerNpcCreativeControls> {
    private Text ownerNameInput;
    private Text customTexInput;
    private NumberInput attackDamageOverrideInput;
    private NumberInput armorValueOverrideInput;
    private NumberInput maxHealthOverrideInput;
    private Checkbox wanderCheckbox;
    private boolean hasChanged = false;

    public GuiNpcCreativeControls(ContainerBase container) {
        super(container);
    }

    @Override
    public void initElements() {
        int totalHeight = 8;
        Label label = new Label(8, totalHeight + 1, "guistrings.npc.owner_name");
        this.addGuiElement(label);
        this.ownerNameInput = new Text(100, totalHeight, 140, "", this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                ((ContainerNpcCreativeControls)((Object)GuiNpcCreativeControls.this.getContainer())).ownerName = newText;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.ownerNameInput);
        label = new Label(8, (totalHeight += 12) + 1, "guistrings.npc.custom_texture");
        this.addGuiElement(label);
        this.customTexInput = new Text(100, totalHeight, 140, "", this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                ((ContainerNpcCreativeControls)((Object)GuiNpcCreativeControls.this.getContainer())).customTexRef = newText;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.customTexInput);
        label = new Label(8, (totalHeight += 12) + 1, "guistrings.npc.health_override");
        this.addGuiElement(label);
        this.maxHealthOverrideInput = new NumberInput(120, totalHeight, 60, 0.0f, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerNpcCreativeControls)((Object)GuiNpcCreativeControls.this.getContainer())).maxHealth = (int)value;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.maxHealthOverrideInput);
        this.maxHealthOverrideInput.setIntegerValue().setAllowNegative();
        label = new Label(8, (totalHeight += 12) + 1, "guistrings.npc.damage_override");
        this.addGuiElement(label);
        this.attackDamageOverrideInput = new NumberInput(120, totalHeight, 60, 0.0f, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerNpcCreativeControls)((Object)GuiNpcCreativeControls.this.getContainer())).attackDamage = (int)value;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.attackDamageOverrideInput);
        this.attackDamageOverrideInput.setIntegerValue().setAllowNegative();
        label = new Label(8, (totalHeight += 12) + 1, "guistrings.npc.armor_override");
        this.addGuiElement(label);
        this.armorValueOverrideInput = new NumberInput(120, totalHeight, 60, 0.0f, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerNpcCreativeControls)((Object)GuiNpcCreativeControls.this.getContainer())).armorValue = (int)value;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.armorValueOverrideInput);
        this.armorValueOverrideInput.setIntegerValue().setAllowNegative();
        this.wanderCheckbox = new Checkbox(8, totalHeight += 12, 16, 16, "guistrings.npc.allow_wander"){

            @Override
            public void onToggled() {
                ((ContainerNpcCreativeControls)((Object)GuiNpcCreativeControls.this.getContainer())).wander = this.checked();
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.wanderCheckbox);
        this.field_147000_g = (totalHeight += 16) + 8;
    }

    @Override
    public void setupElements() {
        this.ownerNameInput.setText(((ContainerNpcCreativeControls)((Object)this.getContainer())).ownerName);
        this.customTexInput.setText(((ContainerNpcCreativeControls)((Object)this.getContainer())).customTexRef);
        this.attackDamageOverrideInput.setValue(((ContainerNpcCreativeControls)((Object)this.getContainer())).attackDamage);
        this.armorValueOverrideInput.setValue(((ContainerNpcCreativeControls)((Object)this.getContainer())).armorValue);
        this.maxHealthOverrideInput.setValue(((ContainerNpcCreativeControls)((Object)this.getContainer())).maxHealth);
        this.wanderCheckbox.setChecked(((ContainerNpcCreativeControls)((Object)this.getContainer())).wander);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        if (this.hasChanged) {
            ((ContainerNpcCreativeControls)((Object)this.getContainer())).sendChangesToServer();
        }
        ((NpcBase)((ContainerNpcCreativeControls)((Object)this.getContainer())).entity).openGUI(this.player);
        return false;
    }
}

