/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.event;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;

public class EventHandler {
    private Set<Predicate<EntityAIBase>> additionalHostileAIChecks = new HashSet<Predicate<EntityAIBase>>();
    public static final EventHandler INSTANCE = new EventHandler();

    private EventHandler() {
    }

    public void registerAdditionalHostileAICheck(Predicate<EntityAIBase> aiCheck) {
        this.additionalHostileAIChecks.add(aiCheck);
    }

    private int getHostileAIPriority(EntityCreature entity) {
        for (EntityAITasks.EntityAITaskEntry taskEntry : entity.field_70715_bh.field_75782_a) {
            if ((!(taskEntry.field_75733_a instanceof EntityAINearestAttackableTarget) || ((EntityAINearestAttackableTarget)taskEntry.field_75733_a).field_75307_b != EntityPlayer.class) && !this.additionalHostileAIChecks.stream().anyMatch(p -> p.test(taskEntry.field_75733_a)) || taskEntry.field_75731_b == -1) continue;
            return taskEntry.field_75731_b;
        }
        return -1;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof NpcBase) {
            return;
        }
        if (!(event.getEntity() instanceof EntityCreature)) {
            return;
        }
        EntityCreature entity = (EntityCreature)event.getEntity();
        int targetTaskPriority = this.getHostileAIPriority(entity);
        if (targetTaskPriority != -1) {
            entity.field_70715_bh.func_75776_a(targetTaskPriority, (EntityAIBase)new EntityAINearestAttackableTarget(entity, NpcBase.class, 0, true, false, e -> e != null && (!(e instanceof NpcFaction) || !e.isPassive() && FactionRegistry.getFaction(((NpcFaction)e).getFaction()).isTarget((Entity)entity)) && (!(e instanceof NpcPlayerOwned) || NpcDefaultsRegistry.getOwnedNpcDefault((NpcPlayerOwned)e).isTarget((Entity)entity))));
        }
    }
}

