/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionFleeSun;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionRestrictSun;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.AdditionalAttributes;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.IAdditionalAttribute;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;
import net.shadowmage.ancientwarfare.npc.registry.FactionNpcDefault;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;

public abstract class NpcFaction
extends NpcBase {
    protected String factionName;
    private Map<IAdditionalAttribute<?>, Object> additionalAttributes = new HashMap();

    public NpcFaction(World world) {
        super(world);
        this.addAI();
    }

    public NpcFaction(World world, String factionName) {
        super(world);
        this.setFactionNameAndDefaults(factionName);
        this.addAI();
    }

    private void addAI() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIFactionRestrictSun(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIFactionFleeSun(this, 1.0));
    }

    public void setAdditionalAttribute(IAdditionalAttribute<?> attribute, Object value) {
        this.additionalAttributes.put(attribute, value);
    }

    protected <T> Optional<T> getAdditionalAttributeValue(IAdditionalAttribute<T> attribute) {
        return Optional.ofNullable(attribute.getValueClass().cast(this.additionalAttributes.get(attribute)));
    }

    public boolean burnsInSun() {
        return this.getAdditionalAttributeValue(AdditionalAttributes.BURNS_IN_SUN).orElse(false);
    }

    public void func_70636_d() {
        this.doSunBurn();
        super.func_70636_d();
    }

    private void doSunBurn() {
        if (this.burnsInSun() && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float brightness = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (brightness > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                ItemStack helmet = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (helmet.func_190926_b()) {
                    this.func_70015_d(8);
                } else {
                    this.damageHelmet(helmet);
                }
            }
        }
    }

    private void damageHelmet(ItemStack helmet) {
        if (helmet.func_77984_f()) {
            helmet.func_77964_b(helmet.func_77952_i() + this.field_70146_Z.nextInt(2));
            if (helmet.func_77952_i() >= helmet.func_77958_k()) {
                this.func_70669_a(helmet);
                this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
            }
        }
    }

    public void setFactionNameAndDefaults(String factionName) {
        this.factionName = factionName;
        this.applyFactionNpcSettings();
    }

    private void applyFactionNpcSettings() {
        FactionNpcDefault npcDefault = NpcDefaultsRegistry.getFactionNpcDefault(this);
        npcDefault.applyAttributes(this);
        npcDefault.applyAdditionalAttributes(this);
        this.field_70728_aV = npcDefault.getExperienceDrop();
        npcDefault.applyPathSettings((PathNavigateGround)this.func_70661_as());
        npcDefault.applyEquipment(this);
    }

    @Override
    public int func_82143_as() {
        int i = super.func_82143_as();
        if (i > 4) {
            i = (int)((float)i + (float)this.field_70170_p.func_175659_aa().func_151525_a() * this.func_110138_aP() / 5.0f);
        }
        if ((float)i >= this.func_110143_aJ()) {
            return (int)this.func_110143_aJ();
        }
        return i;
    }

    @Override
    protected boolean tryCommand(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d && super.tryCommand(player);
    }

    @Override
    public boolean hasCommandPermissions(UUID playerUuid, String playerName) {
        return false;
    }

    @Override
    public String func_70005_c_() {
        String name = I18n.func_74838_a((String)("entity.ancientwarfarenpc." + this.getNpcFullType() + ".name"));
        if (this.func_145818_k_()) {
            name = name + " : " + this.func_95999_t();
        }
        return name;
    }

    @Override
    protected float getLitBlockWeight(BlockPos pos) {
        return this.burnsInSun() ? 1.0f - this.field_70170_p.func_175724_o(pos) : super.getLitBlockWeight(pos);
    }

    @Override
    public String getNpcFullType() {
        return this.factionName + "." + super.getNpcFullType();
    }

    @Override
    public boolean isHostileTowards(Entity e) {
        if (e instanceof EntityPlayer) {
            return FactionTracker.INSTANCE.getStandingFor(this.field_70170_p, e.func_70005_c_(), this.getFaction()) < 0;
        }
        if (e instanceof NpcPlayerOwned) {
            NpcBase npc = (NpcBase)e;
            return FactionTracker.INSTANCE.getStandingFor(this.field_70170_p, npc.getOwner().getName(), this.getFaction()) < 0;
        }
        if (e instanceof NpcFaction) {
            NpcFaction npc = (NpcFaction)e;
            return !npc.getFaction().equals(this.factionName) && FactionRegistry.getFaction(this.getFaction()).isHostileTowards(npc.getFaction());
        }
        return FactionRegistry.getFaction(this.factionName).isTarget(e);
    }

    @Override
    public boolean canTarget(Entity e) {
        if (e instanceof NpcFaction) {
            return !((NpcFaction)e).getFaction().equals(this.getFaction());
        }
        return e instanceof EntityLivingBase;
    }

    @Override
    public boolean canBeAttackedBy(Entity e) {
        return !(e instanceof NpcFaction) || !this.getFaction().equals(((NpcFaction)e).getFaction());
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (damageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)damageSource.func_76346_g();
            FactionTracker.INSTANCE.adjustStandingFor(this.field_70170_p, player.func_70005_c_(), this.getFaction(), -AWNPCStatics.factionLossOnDeath);
        } else if (damageSource.func_76346_g() instanceof NpcPlayerOwned) {
            String playerName = ((NpcBase)damageSource.func_76346_g()).getOwner().getName();
            FactionTracker.INSTANCE.adjustStandingFor(this.field_70170_p, playerName, this.getFaction(), -AWNPCStatics.factionLossOnDeath);
        }
    }

    @Override
    public String getNpcSubType() {
        return "";
    }

    public String getFaction() {
        return this.factionName;
    }

    @Override
    public Team func_96124_cp() {
        return null;
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        new PacketBuffer(buffer).func_180714_a(this.factionName);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.factionName = new PacketBuffer(buffer).func_150789_c(20);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.factionName = tag.func_74779_i("factionName");
        NpcDefaultsRegistry.getFactionNpcDefault(this).applyAdditionalAttributes(this);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.factionName != null) {
            tag.func_74778_a("factionName", this.factionName);
        }
    }
}

