/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBed;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IEntityPacketHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketEntity;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.ai.NpcNavigator;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.IKeepFood;
import net.shadowmage.ancientwarfare.npc.entity.NpcLevelingStats;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;
import net.shadowmage.ancientwarfare.npc.item.ItemShield;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinManager;
import net.shadowmage.ancientwarfare.vehicle.entity.IPathableEntity;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.pathing.Node;

public abstract class NpcBase
extends EntityCreature
implements IEntityAdditionalSpawnData,
IOwnable,
IEntityPacketHandler,
IPathableEntity,
INpc {
    private static final DataParameter<Integer> AI_TASKS = EntityDataManager.func_187226_a(NpcBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> BED_POS = EntityDataManager.func_187226_a(NpcBase.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Byte> BED_DIRECTION = EntityDataManager.func_187226_a(NpcBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> IS_SLEEPING = EntityDataManager.func_187226_a(NpcBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(NpcBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String PROFILE_TEXTURE_TAG = "profileTex";
    private static final String CUSTOM_TEXTURE_TAG = "customTex";
    private static final String SLOT_NUM_TAG = "slotNum";
    private static final String BED_DIRECTION_TAG = "bedDirection";
    private static final String IS_SLEEPING_TAG = "isSleeping";
    private static final String CACHED_BED_POS_TAG = "cachedBedPos";
    private static final String BED_POS_TAG = "bedPos";
    private static final String FOUND_BED_TAG = "foundBed";
    private static final String ORDERS_STACK_TAG = "ordersStack";
    private static final String UPKEEP_STACK_TAG = "upkeepStack";
    private static final String LEVELING_STATS_TAG = "levelingStats";
    private static final String MAX_HEALTH_TAG = "maxHealth";
    private static final String HEALTH_TAG = "health";
    private static final String ATTACK_DAMAGE_OVERRIDE_TAG = "attackDamageOverride";
    private static final String ARMOR_VALUE_OVERRIDE_TAG = "armorValueOverride";
    private static final String AI_ENABLED_TAG = "aiEnabled";
    private Owner owner = Owner.EMPTY;
    private String followingPlayerName;
    private NpcLevelingStats levelingStats;
    private static final ResourceLocation baseDefaultTexture = new ResourceLocation("ancientwarfare:textures/entity/npc/npc_default.png");
    private ResourceLocation currentTexture = null;
    public static final int ORDER_SLOT = 6;
    public static final int UPKEEP_SLOT = 7;
    @Nonnull
    public ItemStack ordersStack = ItemStack.field_190927_a;
    @Nonnull
    public ItemStack upkeepStack = ItemStack.field_190927_a;
    public Set<Entity> nearbyHostiles = new LinkedHashSet<Entity>();
    private boolean aiEnabled = true;
    private int attackDamage = -1;
    private int armorValue = -1;
    private int maxHealthOverride = -1;
    private String customTexRef = "";
    private boolean usesPlayerSkin = false;
    private BlockPos cachedBedPos;
    private boolean foundBed = false;
    private boolean rainedOn = false;
    private float originalWidth;
    private float originalHeight;

    public NpcBase(World par1World) {
        super(par1World);
        this.levelingStats = new NpcLevelingStats(this);
        this.field_184655_bs = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.field_82174_bp = new float[]{1.0f, 1.0f};
        this.field_70699_by = new NpcNavigator((EntityLiving)this);
        this.func_184644_a(PathNodeType.DOOR_WOOD_CLOSED, 0.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AI_TASKS, (Object)0);
        this.field_70180_af.func_187214_a(BED_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(BED_DIRECTION, (Object)((byte)EnumFacing.NORTH.ordinal()));
        this.field_70180_af.func_187214_a(IS_SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
    }

    public ItemStack getShieldStack() {
        return this.func_184586_b(EnumHand.OFF_HAND);
    }

    public void setShieldStack(ItemStack stack) {
        this.func_184611_a(EnumHand.OFF_HAND, stack);
    }

    public int getMaxHealthOverride() {
        return this.maxHealthOverride;
    }

    public void setMaxHealthOverride(int maxHealthOverride) {
        this.maxHealthOverride = maxHealthOverride;
        if (maxHealthOverride > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealthOverride);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110138_aP());
            }
        }
    }

    public void setCustomTexRef(String customTexRef) {
        if (!this.field_70170_p.field_72995_K) {
            if (!customTexRef.equals(this.customTexRef)) {
                PacketEntity pkt = new PacketEntity((Entity)this);
                if (customTexRef.startsWith("Player:")) {
                    String name = customTexRef.split(":", 2)[1];
                    AncientWarfareNPC.proxy.cacheProfile((WorldServer)this.field_70170_p, name).ifPresent(t -> pkt.packetData.func_74782_a(PROFILE_TEXTURE_TAG, (NBTBase)t));
                }
                pkt.packetData.func_74778_a(CUSTOM_TEXTURE_TAG, customTexRef);
                NetworkHandler.sendToAllTracking((Entity)this, pkt);
            }
            this.customTexRef = customTexRef;
        } else {
            this.customTexRef = customTexRef;
            this.updateTexture();
        }
    }

    public void setAttackDamageOverride(int attackDamage) {
        this.attackDamage = attackDamage;
    }

    public void setArmorValueOverride(int armorValue) {
        this.armorValue = armorValue;
    }

    public String getCustomTex() {
        return this.customTexRef;
    }

    public int getArmorValueOverride() {
        return this.armorValue;
    }

    public int getAttackDamageOverride() {
        return this.attackDamage;
    }

    public boolean func_70652_k(Entity target) {
        boolean targetHit;
        float damage = this.getAttackDamageOverride();
        ItemStack shield = ItemStack.field_190927_a;
        if (damage < 0.0f) {
            if (!this.getShieldStack().func_190926_b()) {
                shield = this.getShieldStack().func_77946_l();
                this.func_110140_aT().func_111147_b(shield.func_111283_C(EntityEquipmentSlot.OFFHAND));
            }
            damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        }
        int knockback = 0;
        if (target instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)target).func_70668_bt());
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (targetHit = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
            int fireDamage;
            if (knockback > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireDamage = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fireDamage * 4);
            }
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)target);
        }
        if (!shield.func_190926_b()) {
            this.func_110140_aT().func_111148_a(shield.func_111283_C(EntityEquipmentSlot.OFFHAND));
        }
        return targetHit;
    }

    protected float func_70655_b(DamageSource source, float amount) {
        if (!source.func_76363_c()) {
            if (this.getArmorValueOverride() >= 0) {
                return super.func_70655_b(source, amount);
            }
            NonNullList armor = NonNullList.func_191196_a();
            for (ItemStack armorPiece : this.func_184193_aE()) {
                armor.add((Object)armorPiece);
            }
            float value = ISpecialArmor.ArmorProperties.applyArmor((EntityLivingBase)this, (NonNullList)armor, (DamageSource)source, (double)amount);
            if (value > 0.0f && this.getShieldStack().func_77973_b() instanceof ItemShield) {
                float absorb = value * (float)((ItemShield)this.getShieldStack().func_77973_b()).getArmorBonusValue() / 25.0f;
                int dmg = Math.max((int)absorb, 1);
                this.getShieldStack().func_77972_a(dmg, (EntityLivingBase)this);
                value -= absorb;
            }
            if (value < 0.0f) {
                return 0.0f;
            }
            return value;
        }
        return amount;
    }

    public int func_70658_aO() {
        if (this.getArmorValueOverride() >= 0) {
            return this.getArmorValueOverride();
        }
        int value = super.func_70658_aO();
        if (this.getShieldStack().func_77973_b() instanceof ItemShield) {
            ItemShield shield = (ItemShield)this.getShieldStack().func_77973_b();
            value += shield.getArmorBonusValue();
        }
        return value;
    }

    public final double func_70033_W() {
        return -0.35;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 4 : 4 + (int)(this.func_110143_aJ() / 3.0f);
    }

    public float func_180484_a(BlockPos pos) {
        IBlockState stateBelow = this.field_70170_p.func_180495_p(pos.func_177977_b());
        if (stateBelow.func_185904_a() == Material.field_151587_i || stateBelow.func_185904_a() == Material.field_151570_A) {
            return -10.0f;
        }
        if (stateBelow.func_185904_a().func_76224_d()) {
            return 0.0f;
        }
        float level = this.getLitBlockWeight(pos);
        if (level < 0.0f) {
            return 0.0f;
        }
        return level + (float)(stateBelow.isSideSolid((IBlockAccess)this.field_70170_p, pos.func_177977_b(), EnumFacing.UP) ? 1 : 0);
    }

    protected float getLitBlockWeight(BlockPos pos) {
        return this.field_70170_p.func_175724_o(pos);
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && !this.isSleeping()) {
            this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        }
        super.func_70030_z();
    }

    public double getDistanceSqFromHome() {
        if (!this.func_110175_bO()) {
            return 0.0;
        }
        BlockPos home = this.func_180486_cf();
        return this.func_70092_e((double)home.func_177958_n() + 0.5, home.func_177956_o(), (double)home.func_177952_p() + 0.5);
    }

    public Optional<BlockPos> getTownHallPosition() {
        return Optional.empty();
    }

    public void setHomeAreaAtCurrentPosition() {
        this.func_175449_a(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)), this.getHomeRange());
    }

    public int getHomeRange() {
        if (this.func_110175_bO()) {
            return MathHelper.func_76141_d((float)this.func_110174_bM());
        }
        return 5;
    }

    public boolean shouldBeAtHome() {
        if (this.func_70638_az() != null || !this.func_110175_bO()) {
            return false;
        }
        if (this.field_70170_p.func_175727_C(this.func_180425_c())) {
            this.setRainedOn(true);
        }
        return this.shouldSleep() || this.isWaitingForRainToStop();
    }

    private boolean isWaitingForRainToStop() {
        if (this.worksInRain() || !this.field_70170_p.func_72896_J()) {
            this.setRainedOn(false);
            return false;
        }
        return this.rainedOn;
    }

    public boolean worksInRain() {
        return false;
    }

    public boolean isPassive() {
        return true;
    }

    private void setRainedOn(boolean rainedOn) {
        this.rainedOn = rainedOn;
    }

    public void setIsAIEnabled(boolean val) {
        this.aiEnabled = val;
    }

    public boolean getIsAIEnabled() {
        return this.aiEnabled && !AWNPCStatics.npcAIDebugMode;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.tryCommand(player);
    }

    public void openGUI(EntityPlayer player) {
        NetworkHandler.INSTANCE.openGui(player, 4, this.func_145782_y(), 0, 0);
    }

    public void openAltGui(EntityPlayer player) {
    }

    public boolean hasAltGui() {
        return false;
    }

    protected boolean tryCommand(EntityPlayer player) {
        boolean baton;
        boolean bl = baton = !EntityTools.getItemFromEitherHand(player, ItemCommandBaton.class).func_190926_b();
        if (!baton) {
            if (!this.field_70170_p.field_72995_K) {
                if (player.func_70093_af()) {
                    this.followingPlayerName = this.followingPlayerName != null && this.followingPlayerName.equals(player.func_70005_c_()) ? null : player.func_70005_c_();
                } else {
                    this.openGUI(player);
                }
            }
            return true;
        }
        return false;
    }

    public void func_70108_f(Entity entity) {
        if (!this.func_70090_H() && !this.isHostileTowards(entity)) {
            int d0 = (int)Math.signum(this.field_70165_t - entity.field_70165_t);
            int d1 = (int)Math.signum(this.field_70161_v - entity.field_70161_v);
            if (d0 != 0 || d1 != 0) {
                Material material = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t + (double)d0, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v + (double)d1)).func_185904_a();
                if (material.func_76224_d() || material == Material.field_151570_A) {
                    return;
                }
                this.field_70144_Y = 0.9f;
            }
        }
        super.func_70108_f(entity);
        this.field_70144_Y = 0.0f;
    }

    public final boolean func_70097_a(DamageSource source, float par2) {
        if (this.isSleeping()) {
            return false;
        }
        if (source.func_76346_g() != null && !this.canBeAttackedBy(source.func_76346_g())) {
            return false;
        }
        if (source == DamageSource.field_76368_d && this.func_184187_bx() instanceof EntityLiving) {
            this.knockFromDamage(par2, this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v)).func_185904_a());
            return false;
        }
        if (source == DamageSource.field_76367_g) {
            this.knockFromDamage(par2, Material.field_151570_A);
        } else if (source == DamageSource.field_76371_c) {
            this.knockFromDamage(par2, Material.field_151587_i);
        } else if (source == DamageSource.field_76369_e) {
            this.func_70664_aZ();
        }
        return super.func_70097_a(source, par2);
    }

    private void knockFromDamage(float val, Material material) {
        BlockPos pos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b + 0.5, this.field_70161_v);
        if (this.field_70170_p.func_180495_p(pos.func_177976_e()).func_185904_a() == material) {
            this.func_70653_a(null, val, (double)(pos.func_177958_n() - 1) - this.field_70165_t, 0.0);
        } else if (this.field_70170_p.func_180495_p(pos.func_177978_c()).func_185904_a() == material) {
            this.func_70653_a(null, val, 0.0, (double)(pos.func_177952_p() - 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_180495_p(pos.func_177974_f()).func_185904_a() == material) {
            this.func_70653_a(null, val, (double)(pos.func_177958_n() + 1) - this.field_70165_t, 0.0);
        } else if (this.field_70170_p.func_180495_p(pos.func_177968_d()).func_185904_a() == material) {
            this.func_70653_a(null, val, 0.0, (double)(pos.func_177952_p() + 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_180495_p(pos.func_177982_a(-1, 0, -1)).func_185904_a() == material) {
            this.func_70653_a(null, val, (double)(pos.func_177958_n() - 1) - this.field_70165_t, (double)(pos.func_177952_p() - 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_180495_p(pos.func_177982_a(1, 0, -1)).func_185904_a() == material) {
            this.func_70653_a(null, val, (double)(pos.func_177958_n() + 1) - this.field_70165_t, (double)(pos.func_177952_p() - 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_180495_p(pos.func_177982_a(-1, 0, 1)).func_185904_a() == material) {
            this.func_70653_a(null, val, (double)(pos.func_177958_n() - 1) - this.field_70165_t, (double)(pos.func_177952_p() + 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_180495_p(pos.func_177982_a(1, 0, 1)).func_185904_a() == material) {
            this.func_70653_a(null, val, (double)(pos.func_177958_n() + 1) - this.field_70165_t, (double)(pos.func_177952_p() + 1) - this.field_70161_v);
        } else if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a() == material) {
            this.func_70653_a(null, val, 2.0f * this.func_70681_au().nextFloat() - 1.0f, 2.0f * this.func_70681_au().nextFloat() - 1.0f);
        }
        if (this.field_70170_p.field_72995_K || this.func_70661_as().func_75500_f()) {
            return;
        }
        PathPoint point = this.func_70661_as().func_75505_d().func_75877_a(this.func_70661_as().func_75505_d().func_75873_e());
        if (this.field_70170_p.func_180495_p(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)).func_185904_a() == material) {
            this.func_70661_as().func_75499_g();
        } else if (this.field_70170_p.func_180495_p(new BlockPos(point.field_75839_a, point.field_75837_b - 1, point.field_75838_c)).func_185904_a() == material) {
            this.func_70661_as().func_75499_g();
        }
    }

    public void func_70029_a(World world) {
        super.func_70029_a(world);
        ((NpcNavigator)this.field_70699_by).onWorldChange();
    }

    public void func_70624_b(@Nullable EntityLivingBase entity) {
        if (entity != null && !this.canTarget((Entity)entity)) {
            return;
        }
        super.func_70624_b(entity);
        if (!this.field_70170_p.field_72995_K) {
            this.updateAttackTargetClient();
        }
    }

    private void updateAttackTargetClient() {
        PacketEntity pkt = new PacketEntity((Entity)this);
        pkt.packetData.func_74768_a("attackTarget", this.func_70638_az() == null ? 0 : this.func_70638_az().func_145782_y());
        NetworkHandler.sendToAllTracking((Entity)this, pkt);
    }

    public final void func_70604_c(EntityLivingBase entity) {
        if (entity != null && !this.canTarget((Entity)entity)) {
            return;
        }
        super.func_70604_c(entity);
    }

    protected final void func_82160_b(boolean par1, int par2) {
        if (!this.field_70170_p.field_72995_K) {
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack itemstack = this.func_184582_a(slot);
                if (!itemstack.func_190926_b()) {
                    this.func_70099_a(itemstack, 0.0f);
                }
                this.func_184201_a(slot, ItemStack.field_190927_a);
            }
            if (!AWNPCStatics.persistOrdersOnDeath) {
                if (!this.ordersStack.func_190926_b()) {
                    this.func_70099_a(this.ordersStack, 0.0f);
                }
                if (!this.upkeepStack.func_190926_b()) {
                    this.func_70099_a(this.upkeepStack, 0.0f);
                }
                this.ordersStack = ItemStack.field_190927_a;
                this.upkeepStack = ItemStack.field_190927_a;
            }
        }
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return super.func_184582_a(slotIn);
    }

    public final ItemStack getItemStackFromSlot(int slot) {
        if (slot == 6) {
            return this.ordersStack;
        }
        if (slot == 7) {
            return this.upkeepStack;
        }
        if (slot >= 0 && slot < EntityEquipmentSlot.values().length) {
            return super.func_184582_a(EntityEquipmentSlot.values()[slot]);
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slot, ItemStack stack) {
        super.func_184201_a(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            this.onWeaponInventoryChanged();
        }
    }

    public final void setItemStackToSlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot < EntityEquipmentSlot.values().length) {
            this.func_184201_a(EntityEquipmentSlot.values()[slot], stack);
        } else if (slot == 7) {
            this.upkeepStack = stack;
        } else if (slot == 6) {
            this.ordersStack = stack;
            this.onOrdersInventoryChanged();
        }
    }

    public final void func_70074_a(EntityLivingBase par1EntityLivingBase) {
        super.func_70074_a(par1EntityLivingBase);
        if (!this.field_70170_p.field_72995_K) {
            this.addExperience(AWNPCStatics.npcXpFromKill);
            if (par1EntityLivingBase == this.func_70638_az()) {
                this.func_70624_b(null);
            }
        }
    }

    public final int getAITasks() {
        return (Integer)this.field_70180_af.func_187225_a(AI_TASKS);
    }

    public final void addAITask(int task) {
        int tasks = this.getAITasks();
        int tc = tasks;
        if (tc != (tasks |= task)) {
            this.setAITasks(tasks);
        }
    }

    public final void removeAITask(int task) {
        int tasks = this.getAITasks();
        int tc = tasks;
        if (tc != (tasks &= ~task)) {
            this.setAITasks(tasks);
        }
    }

    private void setAITasks(int tasks) {
        this.field_70180_af.func_187227_b(AI_TASKS, (Object)tasks);
    }

    public final void addExperience(int amount) {
        this.getLevelingStats().addExperience(amount);
    }

    public final void readAdditionalItemData(NBTTagCompound tag) {
        NBTTagList equipmentList = tag.func_150295_c("equipment", 10);
        for (int i = 0; i < equipmentList.func_74745_c(); ++i) {
            NBTTagCompound equipmentTag = equipmentList.func_150305_b(i);
            ItemStack stack = new ItemStack(equipmentTag);
            if (!equipmentTag.func_74764_b(SLOT_NUM_TAG)) continue;
            this.setItemStackToSlot(equipmentTag.func_74762_e(SLOT_NUM_TAG), stack);
        }
        this.readBaseTags(tag);
    }

    public final void writeAdditionalItemData(NBTTagCompound tag) {
        NBTTagList equipmentList = new NBTTagList();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = this.func_184582_a(slot);
            if (stack.func_190926_b()) continue;
            NBTTagCompound equipmentTag = stack.func_77955_b(new NBTTagCompound());
            equipmentTag.func_74768_a(SLOT_NUM_TAG, slot.ordinal());
            equipmentList.func_74742_a((NBTBase)equipmentTag);
        }
        tag.func_74782_a("equipment", (NBTBase)equipmentList);
        this.writeBaseTags(tag);
    }

    public boolean isValidOrdersStack(ItemStack stack) {
        return false;
    }

    public void onOrdersInventoryChanged() {
    }

    public void onWeaponInventoryChanged() {
    }

    public abstract String getNpcSubType();

    public abstract String getNpcType();

    public String getNpcFullType() {
        String type = this.getNpcType();
        if (type == null || type.isEmpty()) {
            throw new RuntimeException("Type must not be null or empty:");
        }
        String sub = this.getNpcSubType();
        if (sub == null) {
            throw new RuntimeException("Subtype must not be null...type: " + type);
        }
        if (!sub.isEmpty()) {
            type = type + "." + sub;
        }
        return type;
    }

    public String func_70005_c_() {
        String name = I18n.func_74838_a((String)("entity.ancientwarfarenpc." + this.getNpcFullType() + ".name"));
        if (this.func_145818_k_()) {
            name = name + " : " + this.func_95999_t();
        }
        return name;
    }

    public final NpcLevelingStats getLevelingStats() {
        return this.levelingStats;
    }

    private ResourceLocation getDefaultTexture() {
        return baseDefaultTexture;
    }

    private ItemStack getItemToSpawn() {
        return ItemNpcSpawner.getSpawnerItemForNpc(this);
    }

    public final long getIDForSkin() {
        return this.field_96093_i.getLeastSignificantBits();
    }

    public final ItemStack getPickedResult(RayTraceResult target) {
        return this.getItemToSpawn();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.func_110124_au().getMostSignificantBits());
        buffer.writeLong(this.func_110124_au().getLeastSignificantBits());
        this.owner.serializeToBuffer(buffer);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.customTexRef);
    }

    public void readSpawnData(ByteBuf buffer) {
        long l1 = buffer.readLong();
        long l2 = buffer.readLong();
        this.field_96093_i = new UUID(l1, l2);
        this.owner = new Owner(buffer);
        this.customTexRef = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.updateTexture();
    }

    public void func_70071_h_() {
        this.field_70170_p.field_72984_F.func_76320_a("AWNpcTick");
        this.func_82168_bl();
        if (this.field_70173_aa % 200 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_70089_S() && (!this.requiresUpkeep() || this.getFoodRemaining() > 0)) {
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        }
        super.func_70071_h_();
        if (!this.func_184614_ca().func_190926_b()) {
            this.func_184614_ca().func_77945_a(this.field_70170_p, (Entity)this, 0, true);
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public boolean func_70686_a(Class claz) {
        return !EntityFlying.class.isAssignableFrom(claz);
    }

    protected final boolean func_70692_ba() {
        return false;
    }

    public final void updateDamageFromLevel() {
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getLeveledAttack());
    }

    private double getLeveledAttack() {
        double dmg = this.getBaseAttack();
        int level = this.getLevelingStats().getLevel();
        return dmg * (1.0 + (double)level * AWNPCStatics.npcLevelDamageMultiplier);
    }

    private double getBaseAttack() {
        return this instanceof NpcFaction ? NpcDefaultsRegistry.getFactionNpcDefault((NpcFaction)this).getBaseAttack() : NpcDefaultsRegistry.getOwnedNpcDefault((NpcPlayerOwned)this).getBaseAttack();
    }

    public int getFoodRemaining() {
        return 0;
    }

    public void setFoodRemaining(int food) {
    }

    public boolean requiresUpkeep() {
        return this instanceof IKeepFood;
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = new Owner(player);
    }

    @Override
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void setOwnerName(String name) {
        this.owner = new Owner(this.field_70170_p, name);
        if (!this.field_70170_p.field_72995_K && !name.equals(this.owner.getName())) {
            PacketEntity pkt = new PacketEntity((Entity)this);
            pkt.packetData = this.owner.serializeToNBT(new NBTTagCompound());
            NetworkHandler.sendToAllTracking((Entity)this, pkt);
        }
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.owner.getName());
    }

    public boolean hasCommandPermissions(Owner owner) {
        return this.hasCommandPermissions(owner.getUUID(), owner.getName());
    }

    public boolean hasCommandPermissions(UUID playerId, String playerName) {
        return this.owner.playerHasCommandPermissions(this.field_70170_p, playerId, playerName);
    }

    protected int func_70693_a(@Nullable EntityPlayer attacker) {
        if (attacker == null || this.isHostileTowards((Entity)attacker) && this.canBeAttackedBy((Entity)attacker)) {
            return super.func_70693_a(attacker);
        }
        return 0;
    }

    public abstract boolean isHostileTowards(Entity var1);

    public abstract boolean canTarget(Entity var1);

    public abstract boolean canBeAttackedBy(Entity var1);

    public final EntityLivingBase getFollowingEntity() {
        if (this.followingPlayerName == null) {
            return null;
        }
        return this.field_70170_p.func_72924_a(this.followingPlayerName);
    }

    public final void setFollowingEntity(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && this.hasCommandPermissions(entity.func_110124_au(), entity.func_70005_c_())) {
            this.followingPlayerName = entity.func_70005_c_();
        }
    }

    public final void clearFollowingEntity() {
        this.followingPlayerName = null;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public final void repackEntity(EntityPlayer player) {
        if (AWNPCStatics.repackCreativeOnly && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (!player.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.onRepack();
            ItemStack item = InventoryTools.mergeItemStack((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), this.getItemToSpawn());
            if (!item.func_190926_b()) {
                InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)item);
            }
        }
        this.func_70106_y();
    }

    protected void onRepack() {
    }

    public void func_70037_a(NBTTagCompound tag) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184201_a(slot, ItemStack.field_190927_a);
        }
        super.func_70037_a(tag);
        if (tag.func_74764_b("home")) {
            this.func_175449_a(BlockPos.func_177969_a((long)tag.func_74763_f("home")), tag.func_74762_e("homeRange"));
        }
        if (tag.func_74764_b(BED_DIRECTION_TAG)) {
            this.setBedDirection(EnumFacing.field_82609_l[tag.func_74771_c(BED_DIRECTION_TAG)]);
        }
        if (tag.func_74764_b(IS_SLEEPING_TAG)) {
            this.setSleeping(tag.func_74767_n(IS_SLEEPING_TAG));
        }
        if (tag.func_74764_b(CACHED_BED_POS_TAG)) {
            this.cachedBedPos = BlockPos.func_177969_a((long)tag.func_74763_f(CACHED_BED_POS_TAG));
        }
        if (tag.func_74764_b(BED_POS_TAG)) {
            this.setBedPosition(BlockPos.func_177969_a((long)tag.func_74763_f(BED_POS_TAG)));
        }
        if (tag.func_74764_b(FOUND_BED_TAG)) {
            this.foundBed = tag.func_74767_n(FOUND_BED_TAG);
        }
        this.readBaseTags(tag);
        this.onWeaponInventoryChanged();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (!this.func_110175_bO()) {
            Optional<BlockPos> position = this.getTownHallPosition();
            if (position.isPresent()) {
                this.func_175449_a(position.get(), this.getHomeRange());
            } else {
                this.setHomeAreaAtCurrentPosition();
            }
        }
        tag.func_74772_a("home", this.func_180486_cf().func_177986_g());
        tag.func_74768_a("homeRange", this.getHomeRange());
        tag.func_74774_a(BED_DIRECTION_TAG, (byte)this.getBedDirection().ordinal());
        tag.func_74757_a(IS_SLEEPING_TAG, this.isSleeping());
        if (this.cachedBedPos != null) {
            tag.func_74772_a(CACHED_BED_POS_TAG, this.cachedBedPos.func_177986_g());
        }
        BlockPos bedPos = this.getBedPosition();
        tag.func_74772_a(BED_POS_TAG, bedPos.func_177986_g());
        tag.func_74757_a(FOUND_BED_TAG, this.foundBed);
        this.writeBaseTags(tag);
    }

    private void readBaseTags(NBTTagCompound tag) {
        if (tag.func_74764_b(ORDERS_STACK_TAG)) {
            this.setItemStackToSlot(6, new ItemStack(tag.func_74775_l(ORDERS_STACK_TAG)));
        }
        if (tag.func_74764_b(UPKEEP_STACK_TAG)) {
            this.setItemStackToSlot(7, new ItemStack(tag.func_74775_l(UPKEEP_STACK_TAG)));
        }
        if (tag.func_74764_b(LEVELING_STATS_TAG)) {
            this.getLevelingStats().readFromNBT(tag.func_74775_l(LEVELING_STATS_TAG));
        }
        if (tag.func_74764_b(MAX_HEALTH_TAG)) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)tag.func_74760_g(MAX_HEALTH_TAG));
        }
        if (tag.func_74764_b(HEALTH_TAG)) {
            this.func_70606_j(tag.func_74760_g(HEALTH_TAG));
        }
        if (tag.func_74764_b("name")) {
            this.func_96094_a(tag.func_74779_i("name"));
        }
        if (tag.func_74764_b("food")) {
            this.setFoodRemaining(tag.func_74762_e("food"));
        }
        if (tag.func_74764_b(ATTACK_DAMAGE_OVERRIDE_TAG)) {
            this.setAttackDamageOverride(tag.func_74762_e(ATTACK_DAMAGE_OVERRIDE_TAG));
        }
        if (tag.func_74764_b(ARMOR_VALUE_OVERRIDE_TAG)) {
            this.setArmorValueOverride(tag.func_74762_e(ARMOR_VALUE_OVERRIDE_TAG));
        }
        if (tag.func_74764_b(CUSTOM_TEXTURE_TAG)) {
            this.setCustomTexRef(tag.func_74779_i(CUSTOM_TEXTURE_TAG));
        }
        if (tag.func_74764_b(AI_ENABLED_TAG)) {
            this.setIsAIEnabled(tag.func_74767_n(AI_ENABLED_TAG));
        }
        this.owner = Owner.deserializeFromNBT(tag);
    }

    public static void registerFixesNpc(DataFixer fixer, Class<?> entityClass) {
        EntityLiving.func_189752_a((DataFixer)fixer, entityClass);
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackData(entityClass, new String[]{ORDERS_STACK_TAG, UPKEEP_STACK_TAG}));
    }

    private void writeBaseTags(NBTTagCompound tag) {
        if (!this.ordersStack.func_190926_b()) {
            tag.func_74782_a(ORDERS_STACK_TAG, (NBTBase)this.ordersStack.func_77955_b(new NBTTagCompound()));
        }
        if (!this.upkeepStack.func_190926_b()) {
            tag.func_74782_a(UPKEEP_STACK_TAG, (NBTBase)this.upkeepStack.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74782_a(LEVELING_STATS_TAG, (NBTBase)this.getLevelingStats().writeToNBT(new NBTTagCompound()));
        tag.func_74776_a(MAX_HEALTH_TAG, this.func_110138_aP());
        tag.func_74776_a(HEALTH_TAG, this.func_110143_aJ());
        if (this.func_145818_k_()) {
            tag.func_74778_a("name", this.func_95999_t());
        }
        tag.func_74768_a("food", this.getFoodRemaining());
        tag.func_74768_a(ATTACK_DAMAGE_OVERRIDE_TAG, this.attackDamage);
        tag.func_74768_a(ARMOR_VALUE_OVERRIDE_TAG, this.armorValue);
        tag.func_74778_a(CUSTOM_TEXTURE_TAG, this.customTexRef);
        tag.func_74757_a(AI_ENABLED_TAG, this.aiEnabled);
        this.owner.serializeToNBT(tag);
    }

    public final ResourceLocation getTexture() {
        if (this.currentTexture == null) {
            this.updateTexture();
        }
        return this.currentTexture == null ? this.getDefaultTexture() : this.currentTexture;
    }

    public final void updateTexture() {
        this.usesPlayerSkin = false;
        if (this.customTexRef.startsWith("Player:")) {
            try {
                AncientWarfareNPC.proxy.getPlayerSkin(this.customTexRef.split(":", 2)[1]).ifPresent(t -> {
                    this.currentTexture = t;
                    this.usesPlayerSkin = true;
                });
            }
            catch (Throwable throwable) {}
        } else {
            NpcSkinManager.INSTANCE.getTextureFor(this).ifPresent(t -> {
                this.currentTexture = t;
            });
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("ownerName")) {
            this.owner = Owner.deserializeFromNBT(tag);
        } else if (tag.func_74764_b(PROFILE_TEXTURE_TAG) && tag.func_74764_b(CUSTOM_TEXTURE_TAG)) {
            this.customTexRef = tag.func_74779_i(CUSTOM_TEXTURE_TAG);
            NBTTagCompound tah = tag.func_74775_l(PROFILE_TEXTURE_TAG);
            if (this.field_70170_p.field_72995_K) {
                Optional.ofNullable(NBTUtil.func_152459_a((NBTTagCompound)tah)).ifPresent(AncientWarfareNPC.proxy::cacheProfile);
            }
            this.updateTexture();
        } else if (tag.func_74764_b(CUSTOM_TEXTURE_TAG)) {
            this.setCustomTexRef(tag.func_74779_i(CUSTOM_TEXTURE_TAG));
        } else if (tag.func_74764_b("attackTarget")) {
            int entityId = tag.func_74762_e("attackTarget");
            this.func_70624_b((EntityLivingBase)this.field_70170_p.func_73045_a(entityId));
        }
    }

    public double func_174818_b(BlockPos pos) {
        return this.func_70092_e((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public BlockPos findBed() {
        IBlockState state;
        if (!this.foundBed) {
            int originX = MathHelper.func_76128_c((double)this.field_70165_t);
            int originY = MathHelper.func_76128_c((double)this.field_70163_u);
            int originZ = MathHelper.func_76128_c((double)this.field_70161_v);
            int maxSearchRange = 6;
            int minX = originX - maxSearchRange;
            int maxX = originX + maxSearchRange;
            int minY = originY - maxSearchRange;
            int maxY = originY + maxSearchRange;
            int minZ = originZ - maxSearchRange;
            int maxZ = originZ + maxSearchRange;
            ArrayList<BlockPos> foundBeds = new ArrayList<BlockPos>();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        IBlockState state2 = this.field_70170_p.func_180495_p(new BlockPos(x, y, z));
                        if (!(state2.func_177230_c() instanceof BlockBed) || state2.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.FOOT || ((Boolean)state2.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue()) continue;
                        foundBeds.add(new BlockPos(x, y, z));
                    }
                }
            }
            int closetBedIndex = -1;
            for (int i = 0; i < foundBeds.size(); ++i) {
                double bedDistance = ((BlockPos)foundBeds.get(i)).func_177957_d((double)originX, (double)originY, (double)originZ);
                if (closetBedIndex != -1 && !(bedDistance < ((BlockPos)foundBeds.get(closetBedIndex)).func_177957_d((double)originX, (double)originY, (double)originZ))) continue;
                closetBedIndex = i;
            }
            if (closetBedIndex == -1) {
                this.foundBed = false;
                return null;
            }
            this.foundBed = true;
            this.cachedBedPos = (BlockPos)foundBeds.get(closetBedIndex);
        }
        if ((state = this.field_70170_p.func_180495_p(this.cachedBedPos)).func_177230_c() instanceof BlockBed) {
            return this.cachedBedPos;
        }
        this.foundBed = false;
        return null;
    }

    public boolean lieDown(BlockPos pos) {
        if (!this.foundBed) {
            return false;
        }
        if (this.field_70170_p.func_175667_e(pos) && this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockBed) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue()) {
                this.foundBed = false;
                return false;
            }
            state = state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(true));
            this.field_70170_p.func_175656_a(pos, state);
            this.setBedPosition(pos);
            this.setBedDirection((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D));
            this.setSleeping(true);
            this.originalHeight = this.field_70131_O;
            this.originalWidth = this.field_70130_N;
            this.func_70105_a(0.2f, 0.2f);
            this.setPositionToBed();
            return true;
        }
        return false;
    }

    public void wakeUp() {
        EnumFacing bedDirection;
        this.setSleeping(false);
        BlockPos bedPos = this.getBedPosition();
        IBlockState bedState = this.field_70170_p.func_180495_p(bedPos);
        if (bedState.func_177230_c() == Blocks.field_150324_C) {
            this.field_70170_p.func_180501_a(bedPos, bedState.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 4);
        }
        if (this.tryMovingToBedside(bedPos.func_177972_a((bedDirection = this.getBedDirection()).func_176746_e()))) {
            return;
        }
        if (this.tryMovingToBedside(bedPos.func_177972_a(bedDirection.func_176735_f()))) {
            return;
        }
        BlockPos offsetPos = bedPos.func_177972_a(bedDirection.func_176734_d());
        if (this.tryMovingToBedside(offsetPos)) {
            return;
        }
        if (this.tryMovingToBedside(offsetPos.func_177972_a(bedDirection.func_176746_e()))) {
            return;
        }
        if (this.tryMovingToBedside(offsetPos.func_177972_a(bedDirection.func_176735_f()))) {
            return;
        }
        this.func_70105_a(this.originalWidth, this.originalHeight);
    }

    private boolean tryMovingToBedside(BlockPos posToMove) {
        if (this.field_70170_p.func_180495_p(posToMove).func_185904_a().func_76230_c()) {
            return false;
        }
        if (this.field_70170_p.func_180495_p(posToMove.func_177984_a()).func_185904_a().func_76230_c()) {
            return false;
        }
        if (!this.field_70170_p.func_180495_p(posToMove.func_177977_b()).func_185904_a().func_76230_c()) {
            return false;
        }
        this.aiEnabled = false;
        this.func_70107_b((double)posToMove.func_177958_n() + 0.5, (double)posToMove.func_177956_o() + 0.5, (double)posToMove.func_177952_p() + 0.5);
        this.aiEnabled = true;
        return true;
    }

    private BlockPos getBedPosition() {
        return (BlockPos)this.field_70180_af.func_187225_a(BED_POS);
    }

    private void setBedPosition(BlockPos pos) {
        this.field_70180_af.func_187227_b(BED_POS, (Object)pos);
    }

    public void setPositionToBed() {
        float xOffset = 0.5f;
        float yOffset = 0.6f;
        float zOffset = 0.5f;
        this.func_70107_b((float)this.cachedBedPos.func_177958_n() + xOffset, (float)this.cachedBedPos.func_177956_o() + yOffset, (float)this.cachedBedPos.func_177952_p() + zOffset);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.isSleeping()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
            this.field_70704_bt = 0.0f;
            super.func_191986_a(0.0f, 0.0f, 0.0f);
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public boolean isBedCacheValid() {
        return this.field_70170_p.func_180495_p(this.cachedBedPos).func_177230_c() instanceof BlockBed;
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.isSleeping()) {
            super.func_70100_b_(player);
        }
    }

    public boolean func_70104_M() {
        return !this.isSleeping();
    }

    protected void func_82167_n(Entity entity) {
        if (!this.isSleeping()) {
            super.func_82167_n(entity);
        }
    }

    private void setSleeping(boolean isSleeping) {
        this.field_70180_af.func_187227_b(IS_SLEEPING, (Object)isSleeping);
    }

    public boolean isSleeping() {
        return this.field_70180_af == null ? false : (Boolean)this.field_70180_af.func_187225_a(IS_SLEEPING);
    }

    private void setBedDirection(EnumFacing direction) {
        this.field_70180_af.func_187227_b(BED_DIRECTION, (Object)((byte)direction.ordinal()));
    }

    public EnumFacing getBedDirection() {
        return EnumFacing.field_82609_l[(Byte)this.field_70180_af.func_187225_a(BED_DIRECTION)];
    }

    public boolean shouldSleep() {
        return !WorldTools.isDaytimeInDimension(this.field_70170_p);
    }

    @SideOnly(value=Side.CLIENT)
    public float getBedOrientationInDegrees() {
        IBlockState state;
        BlockPos bedLocation = this.getBedPosition();
        IBlockState iBlockState = state = bedLocation == null ? null : this.field_70170_p.func_180495_p(bedLocation);
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)this.field_70170_p, bedLocation, (Entity)this)) {
            EnumFacing enumfacing = state.func_177230_c().getBedDirection(state, (IBlockAccess)this.field_70170_p, bedLocation);
            switch (enumfacing) {
                case SOUTH: {
                    return 90.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
                case EAST: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public boolean getUsesPlayerSkin() {
        return this.usesPlayerSkin;
    }

    @Nullable
    private VehicleBase getRidingVehicle() {
        if (this.func_184187_bx() instanceof VehicleBase) {
            return (VehicleBase)this.func_184187_bx();
        }
        return null;
    }

    @Override
    public void setPath(List<Node> path) {
        VehicleBase vehicle = this.getRidingVehicle();
        if (vehicle != null) {
            vehicle.nav.forcePath(path);
        }
    }

    @Override
    public void setMoveTo(double x, double y, double z, float moveSpeed) {
        this.func_70605_aq().func_75642_a(x, y, z, (double)moveSpeed);
    }

    @Override
    public float getDefaultMoveSpeed() {
        return 1.0f;
    }

    @Override
    public boolean isPathableEntityOnLadder() {
        return this.func_70617_f_();
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    @Override
    public void onStuckDetected() {
    }
}

