/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionTrader;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;
import net.shadowmage.ancientwarfare.npc.trade.FactionTradeList;

public class ContainerNpcFactionTradeView
extends ContainerNpcBase<NpcFactionTrader> {
    private static final String DO_TRADE_TAG = "doTrade";
    private static final String TRADE_DATA_TAG = "tradeData";
    public final FactionTradeList tradeList;

    public ContainerNpcFactionTradeView(EntityPlayer player, int x, int y, int z) {
        super(player, x);
        this.tradeList = ((NpcFactionTrader)this.entity).getTradeList();
        ((NpcFactionTrader)this.entity).startTrade(player);
        this.addPlayerSlots();
    }

    @Override
    public void sendInitData() {
        this.tradeList.updateTradesForView();
        NBTTagCompound packetTag = new NBTTagCompound();
        packetTag.func_74782_a(TRADE_DATA_TAG, (NBTBase)this.tradeList.serializeNBT());
        this.sendDataToClient(packetTag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(TRADE_DATA_TAG)) {
            this.tradeList.deserializeNBT(tag.func_74775_l(TRADE_DATA_TAG));
        } else if (tag.func_74764_b(DO_TRADE_TAG) && this.tradeList.performTrade(this.player, tag.func_74762_e(DO_TRADE_TAG))) {
            FactionTracker.INSTANCE.adjustStandingFor(((NpcFactionTrader)this.entity).field_70170_p, this.player.func_70005_c_(), ((NpcFactionTrader)this.entity).getFaction(), AWNPCStatics.factionGainOnTrade);
        }
        this.refreshGui();
    }

    public void func_75134_a(EntityPlayer player) {
        ((NpcFactionTrader)this.entity).closeTrade();
        super.func_75134_a(player);
    }

    public void doTrade(int tradeNum) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(DO_TRADE_TAG, tradeNum);
        this.sendDataToServer(tag);
    }
}

