/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionTrader;
import net.shadowmage.ancientwarfare.npc.trade.FactionTradeList;

public class ContainerNpcFactionTradeSetup
extends ContainerNpcBase<NpcFactionTrader> {
    public FactionTradeList tradeList = ((NpcFactionTrader)this.entity).getTradeList();
    public boolean tradesChanged = false;

    public ContainerNpcFactionTradeSetup(EntityPlayer player, int x, int y, int z) {
        super(player, x);
        ((NpcFactionTrader)this.entity).startTrade(player);
        this.addPlayerSlots();
    }

    @Override
    public void sendInitData() {
        this.tradeList.updateTradesForView();
        NBTTagCompound packetTag = new NBTTagCompound();
        packetTag.func_74782_a("tradeData", (NBTBase)this.tradeList.serializeNBT());
        this.sendDataToClient(packetTag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("tradeData")) {
            this.tradeList.deserializeNBT(tag.func_74775_l("tradeData"));
        }
        this.refreshGui();
    }

    public void func_75134_a(EntityPlayer p_75134_1_) {
        ((NpcFactionTrader)this.entity).closeTrade();
        super.func_75134_a(p_75134_1_);
    }

    public void onGuiClosed() {
        if (this.player.field_70170_p.field_72995_K && this.tradesChanged) {
            this.tradeList.removeEmptyTrades();
            this.sendTradeListToServer();
        }
    }

    private void sendTradeListToServer() {
        NBTTagCompound packetTag = new NBTTagCompound();
        packetTag.func_74782_a("tradeData", (NBTBase)this.tradeList.serializeNBT());
        this.sendDataToServer(packetTag);
    }

    public void setTradeList(FactionTradeList tradeList) {
        this.tradeList = tradeList;
        this.sendTradeListToServer();
    }
}

