/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.orders.WorkOrder;

public class NpcAIPlayerOwnedWork
extends NpcAI<NpcBase> {
    private int ticksAtSite;
    private int workIndex;
    public WorkOrder order;
    private boolean init = false;

    public NpcAIPlayerOwnedWork(NpcBase npc) {
        super(npc);
        if (!(npc instanceof IWorker)) {
            throw new IllegalArgumentException("cannot instantiate work ai task on non-worker npc");
        }
        this.func_75248_a(3);
        this.ticksAtSite = 0;
    }

    public boolean func_75250_a() {
        if (!this.init) {
            this.order = WorkOrder.getWorkOrder(this.npc.ordersStack);
            this.init = true;
            if (this.order == null || this.workIndex >= this.order.size()) {
                this.workIndex = 0;
            }
        }
        return this.func_75253_b();
    }

    public boolean func_75253_b() {
        return this.npc.getIsAIEnabled() && this.npc.getFoodRemaining() > 0 && !this.npc.shouldBeAtHome() && this.order != null && !this.order.isEmpty();
    }

    public void func_75246_d() {
        WorkOrder.WorkEntry entry = (WorkOrder.WorkEntry)this.order.get(this.workIndex);
        BlockPos pos = entry.getPosition();
        double dist = this.npc.func_174818_b(pos);
        if (dist > ((IWorker)((Object)this.npc)).getWorkRangeSq()) {
            this.npc.addAITask(512);
            this.ticksAtSite = 0;
            this.moveToPosition(pos, dist);
        } else {
            if (dist < 10.0 || this.shouldMoveFromTimeAtSite(entry) || this.shouldMoveFromNoWork()) {
                this.npc.func_70661_as().func_75499_g();
                this.npc.removeAITask(512);
            }
            this.workAtSite(entry);
        }
    }

    public void func_75249_e() {
        this.npc.addAITask(16);
    }

    private void workAtSite(WorkOrder.WorkEntry entry) {
        BlockPos pos;
        ++this.ticksAtSite;
        if (this.ticksAtSite == 1 && WorldTools.getTile((IBlockAccess)this.npc.field_70170_p, pos = entry.getPosition(), IWorkSite.class).map(t -> !((IWorker)((Object)this.npc)).canWorkAt(t.getWorkType()) || !t.hasWork()).orElse(false).booleanValue()) {
            this.setMoveToNextSite();
            return;
        }
        if (this.npc.field_70173_aa % 10 == 0) {
            this.npc.func_184609_a(EnumHand.MAIN_HAND);
        }
        if (this.ticksAtSite >= AWNPCStatics.npcWorkTicks) {
            this.ticksAtSite = 0;
            Optional<IWorkSite> workSite = WorldTools.getTile((IBlockAccess)this.npc.field_70170_p, entry.getPosition(), IWorkSite.class).filter(s -> ((IWorker)((Object)this.npc)).canWorkAt(s.getWorkType()));
            if (workSite.isPresent()) {
                IWorkSite site = workSite.get();
                if (site.hasWork()) {
                    this.npc.addExperience(AWNPCStatics.npcXpFromWork);
                    site.addEnergyFromWorker((IWorker)((Object)this.npc));
                } else if (this.shouldMoveFromNoWork()) {
                    this.setMoveToNextSite();
                }
                if (this.shouldMoveFromTimeAtSite(entry)) {
                    this.setMoveToNextSite();
                }
                return;
            }
            this.setMoveToNextSite();
        }
    }

    private boolean shouldMoveFromNoWork() {
        return !this.order.getPriorityType().isTimed() && this.order.size() > 1;
    }

    private boolean shouldMoveFromTimeAtSite(WorkOrder.WorkEntry entry) {
        return this.order.getPriorityType().isTimed() && this.ticksAtSite > entry.getWorkLength();
    }

    private void setMoveToNextSite() {
        this.ticksAtSite = 0;
        this.moveRetryDelay = 0;
        this.workIndex = this.order.getPriorityType().getNextWorkIndex(this.workIndex, this.order.getEntries(), this.npc);
    }

    public void onOrdersChanged() {
        this.order = WorkOrder.getWorkOrder(this.npc.ordersStack);
        this.workIndex = 0;
        this.ticksAtSite = 0;
    }

    public void func_75251_c() {
        this.ticksAtSite = 0;
        this.npc.removeAITask(528);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.ticksAtSite = tag.func_74762_e("ticksAtSite");
        this.workIndex = tag.func_74762_e("workIndex");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("ticksAtSite", this.ticksAtSite);
        tag.func_74768_a("workIndex", this.workIndex);
        return tag;
    }
}

