/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.item.ItemBackpack;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.orders.TradeOrder;

public class NpcAIPlayerOwnedTrader
extends NpcAI<NpcPlayerOwned> {
    private boolean shelter;
    private boolean upkeep;
    private boolean restock;
    private boolean deposit;
    private boolean waiting;
    private boolean atShelter;
    private boolean atUpkeep;
    private boolean atDeposit;
    private boolean atWithdraw;
    private boolean atWaypoint;
    private int delayCounter;
    private int waypointIndex;
    private BlockPos waypoint;
    private BlockPos shelterPoint;
    private TradeOrder orders;

    public NpcAIPlayerOwnedTrader(NpcPlayerOwned npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public void onOrdersUpdated() {
        this.orders = TradeOrder.getTradeOrder(((NpcPlayerOwned)this.npc).ordersStack);
        this.waypoint = null;
        this.shelterPoint = null;
        this.upkeep = false;
        this.restock = false;
        this.deposit = false;
        this.waiting = false;
        this.atDeposit = false;
        this.atShelter = false;
        this.atUpkeep = false;
        this.atWaypoint = false;
        this.atWithdraw = false;
        this.waypointIndex = 0;
        this.delayCounter = 0;
        if (this.orders != null && this.orders.getRoute().size() > 0) {
            this.waypoint = this.orders.getRoute().get(this.waypointIndex).getPosition();
        }
    }

    public boolean func_75250_a() {
        return this.orders != null && this.waypoint != null;
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        if (((NpcPlayerOwned)this.npc).shouldBeAtHome() || this.shelter) {
            this.updateShelter();
        } else if (this.upkeep) {
            this.updateUpkeep();
        } else if (this.restock) {
            this.updateRestock();
        } else {
            this.updatePatrol();
        }
    }

    private void updateShelter() {
        ((NpcPlayerOwned)this.npc).addAITask(8);
        this.shelter = true;
        if (this.atShelter) {
            if (!((NpcPlayerOwned)this.npc).shouldBeAtHome()) {
                this.shelter = false;
                this.atShelter = false;
                this.shelterPoint = null;
                this.upkeep = false;
                this.atUpkeep = false;
                this.deposit = false;
                this.restock = false;
                this.atDeposit = false;
                this.atWithdraw = false;
                this.waiting = false;
                this.delayCounter = 0;
                ((NpcPlayerOwned)this.npc).removeAITask(8);
            }
        } else if (this.shelterPoint == null) {
            double d2;
            int index = this.waypointIndex - 1;
            if (index < 0) {
                index = this.orders.getRoute().size() - 1;
            }
            BlockPos wp2 = this.orders.getRoute().get(index).getPosition();
            double d1 = ((NpcPlayerOwned)this.npc).func_174818_b(this.waypoint);
            this.shelterPoint = d1 < (d2 = ((NpcPlayerOwned)this.npc).func_174818_b(wp2)) ? this.waypoint : wp2;
        } else {
            double d = ((NpcPlayerOwned)this.npc).func_174818_b(this.shelterPoint);
            if (d > 9.0) {
                ((NpcPlayerOwned)this.npc).addAITask(512);
                this.moveToPosition(this.shelterPoint, d);
            } else {
                ((NpcPlayerOwned)this.npc).removeAITask(512);
                this.atShelter = true;
            }
        }
    }

    private void updateUpkeep() {
        ((NpcPlayerOwned)this.npc).addAITask(2);
        if (this.atUpkeep) {
            if (this.tryWithdrawUpkeep()) {
                this.atUpkeep = false;
                this.upkeep = false;
                this.restock = true;
                this.deposit = true;
                ((NpcPlayerOwned)this.npc).removeAITask(2);
                ((NpcPlayerOwned)this.npc).removeAITask(4);
            }
        } else if (((NpcPlayerOwned)this.npc).getUpkeepPoint().isPresent()) {
            ((NpcPlayerOwned)this.npc).getUpkeepPoint().ifPresent(upkeepPoint -> {
                double d = ((NpcPlayerOwned)this.npc).func_174818_b((BlockPos)upkeepPoint);
                if (d > 9.0) {
                    ((NpcPlayerOwned)this.npc).addAITask(512);
                    this.moveToPosition((BlockPos)upkeepPoint, d);
                } else {
                    ((NpcPlayerOwned)this.npc).removeAITask(512);
                    this.atUpkeep = true;
                }
            });
        } else {
            ((NpcPlayerOwned)this.npc).addAITask(4);
            ((NpcPlayerOwned)this.npc).removeAITask(2);
        }
    }

    private boolean tryWithdrawUpkeep() {
        return ((NpcPlayerOwned)this.npc).getUpkeepPoint().map(upkeepPoint -> WorldTools.getItemHandlerFromTile((IBlockAccess)((NpcPlayerOwned)this.npc).field_70170_p, upkeepPoint, ((NpcPlayerOwned)this.npc).getUpkeepBlockSide()).map(h -> ((NpcPlayerOwned)this.npc).withdrawFood((IItemHandler)h)).orElse(false)).orElse(false);
    }

    private void updateRestock() {
        if (this.deposit) {
            this.updateDeposit();
        } else {
            this.updateWithdraw();
        }
    }

    private void updateDeposit() {
        if (this.atDeposit) {
            this.doDeposit();
            this.deposit = false;
            this.atDeposit = false;
        } else if (this.orders.getRestockData().getDepositPoint() != null) {
            BlockPos p = this.orders.getRestockData().getDepositPoint();
            double d = ((NpcPlayerOwned)this.npc).func_174818_b(p);
            if (d > 9.0) {
                ((NpcPlayerOwned)this.npc).addAITask(512);
                this.moveToPosition(p, d);
            } else {
                ((NpcPlayerOwned)this.npc).removeAITask(512);
                this.atDeposit = true;
            }
        } else {
            this.deposit = false;
        }
    }

    private void updateWithdraw() {
        if (this.atWithdraw) {
            this.doWithdraw();
            this.setNextWaypoint();
            this.restock = false;
            this.atWithdraw = false;
        } else if (this.orders.getRestockData().getWithdrawPoint() != null) {
            BlockPos p = this.orders.getRestockData().getWithdrawPoint();
            double d = ((NpcPlayerOwned)this.npc).func_174818_b(p);
            if (d > 9.0) {
                ((NpcPlayerOwned)this.npc).addAITask(512);
                this.moveToPosition(p, d);
            } else {
                ((NpcPlayerOwned)this.npc).removeAITask(512);
                this.atWithdraw = true;
            }
        } else {
            this.restock = false;
            this.setNextWaypoint();
        }
    }

    private void updatePatrol() {
        if (this.atWaypoint) {
            if (this.waiting) {
                ++this.delayCounter;
                if (this.delayCounter >= this.orders.getRoute().get(this.waypointIndex).getDelay()) {
                    this.delayCounter = 0;
                    this.waiting = false;
                    this.atWaypoint = false;
                    if (this.orders.getRoute().get(this.waypointIndex).shouldUpkeep()) {
                        this.upkeep = true;
                    } else {
                        this.setNextWaypoint();
                    }
                }
            } else {
                this.waiting = true;
                this.delayCounter = 0;
            }
        } else {
            ((NpcPlayerOwned)this.npc).addAITask(512);
            double d = ((NpcPlayerOwned)this.npc).func_174818_b(this.waypoint);
            if (d < 9.0) {
                this.atWaypoint = true;
                this.waiting = false;
                ((NpcPlayerOwned)this.npc).removeAITask(512);
            } else {
                this.moveToPosition(this.waypoint, d);
            }
        }
    }

    private void setNextWaypoint() {
        ++this.waypointIndex;
        if (this.waypointIndex >= this.orders.getRoute().size()) {
            this.waypointIndex = 0;
        }
        this.waypoint = this.orders.getRoute().get(this.waypointIndex).getPosition();
    }

    private void doDeposit() {
        ItemStack backpack = ((NpcPlayerOwned)this.npc).func_184614_ca();
        if (!backpack.func_190926_b() && backpack.func_77973_b() instanceof ItemBackpack) {
            IItemHandler inv = (IItemHandler)backpack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            BlockPos pos = this.orders.getRestockData().getDepositPoint();
            WorldTools.getItemHandlerFromTile((IBlockAccess)((NpcPlayerOwned)this.npc).field_70170_p, pos, this.orders.getRestockData().getDepositSide()).ifPresent(handler -> this.orders.getRestockData().doDeposit(inv, (IItemHandler)handler));
        }
    }

    private void doWithdraw() {
        ItemStack backpack = ((NpcPlayerOwned)this.npc).func_184614_ca();
        if (!backpack.func_190926_b() && backpack.func_77973_b() instanceof ItemBackpack) {
            IItemHandler inv = (IItemHandler)backpack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            BlockPos pos = this.orders.getRestockData().getWithdrawPoint();
            WorldTools.getItemHandlerFromTile((IBlockAccess)((NpcPlayerOwned)this.npc).field_70170_p, pos, this.orders.getRestockData().getWithdrawSide()).ifPresent(handler -> this.orders.getRestockData().doWithdraw(inv, (IItemHandler)handler));
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.orders = TradeOrder.getTradeOrder(((NpcPlayerOwned)this.npc).ordersStack);
        this.waypointIndex = tag.func_74762_e("waypoint");
        this.waypoint = this.orders == null || this.orders.getRoute().size() == 0 ? null : this.orders.getRoute().get(this.waypointIndex).getPosition();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("waypoint", this.waypointIndex);
        return tag;
    }
}

