/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;

public class NpcAIPlayerOwnedFollowCommand
extends NpcAI<NpcPlayerOwned> {
    private BlockPos moveTargetPos = null;

    public NpcAIPlayerOwnedFollowCommand(NpcPlayerOwned npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!((NpcPlayerOwned)this.npc).getIsAIEnabled()) {
            return false;
        }
        NpcCommand.Command cmd = ((NpcPlayerOwned)this.npc).getCurrentCommand();
        if (cmd == null) {
            return false;
        }
        if (cmd.type == NpcCommand.CommandType.GUARD || cmd.type == NpcCommand.CommandType.ATTACK_AREA) {
            return ((NpcPlayerOwned)this.npc).func_70638_az() == null;
        }
        return true;
    }

    public void func_75251_c() {
        NpcCommand.Command cmd = ((NpcPlayerOwned)this.npc).getCurrentCommand();
        if (!(cmd == null || ((NpcPlayerOwned)this.npc).func_70638_az() != null && cmd.type.isPersistent())) {
            ((NpcPlayerOwned)this.npc).handlePlayerCommand(null);
        }
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        NpcCommand.Command cmd = ((NpcPlayerOwned)this.npc).getCurrentCommand();
        this.handleCommand(cmd);
        if (!cmd.type.isPersistent()) {
            ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
        }
    }

    private void handleCommand(NpcCommand.Command cmd) {
        switch (cmd.type) {
            case CLEAR_HOME: {
                ((NpcPlayerOwned)this.npc).func_110177_bN();
                break;
            }
            case CLEAR_UPKEEP: {
                ((NpcPlayerOwned)this.npc).setUpkeepAutoPosition(null);
                break;
            }
            case SET_HOME: {
                ((NpcPlayerOwned)this.npc).func_175449_a(cmd.pos, ((NpcPlayerOwned)this.npc).getHomeRange());
                break;
            }
            case SET_UPKEEP: {
                ((NpcPlayerOwned)this.npc).setUpkeepAutoPosition(cmd.pos);
                break;
            }
            case CLEAR_COMMAND: 
            case ATTACK: {
                ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
                break;
            }
            case ATTACK_AREA: {
                this.handleAttackMoveCommand(cmd);
                break;
            }
            case GUARD: {
                this.handleGuardCommand(cmd);
                break;
            }
            case MOVE: {
                this.handleMoveCommand(cmd);
            }
        }
    }

    private void handleGuardCommand(NpcCommand.Command cmd) {
        Entity e = cmd.getEntityTarget(((NpcPlayerOwned)this.npc).field_70170_p);
        if (e == null) {
            ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
            return;
        }
        double sqDist = ((NpcPlayerOwned)this.npc).func_70068_e(e);
        if (sqDist > 9.0) {
            this.moveToEntity(e, sqDist);
        } else {
            ((NpcPlayerOwned)this.npc).func_70661_as().func_75499_g();
            if (e instanceof EntityHorse) {
                if (!((NpcPlayerOwned)this.npc).func_184218_aH() && e.func_184188_bt().isEmpty()) {
                    ((NpcPlayerOwned)this.npc).func_184220_m(e);
                    e.field_70126_B = e.field_70177_z = ((NpcPlayerOwned)this.npc).field_70177_z % 360.0f;
                    ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
                } else if (((NpcPlayerOwned)this.npc).func_184218_aH() && ((NpcPlayerOwned)this.npc).func_184187_bx() == e) {
                    ((NpcPlayerOwned)this.npc).func_184210_p();
                    ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
                }
            }
        }
    }

    private void handleMoveCommand(NpcCommand.Command cmd) {
        double sqDist;
        if (this.moveTargetPos == null || this.moveTargetPos != cmd.pos) {
            this.moveTargetPos = cmd.pos;
        }
        if ((sqDist = ((NpcPlayerOwned)this.npc).func_174818_b(this.moveTargetPos)) > 9.0) {
            this.moveToPosition(this.moveTargetPos, sqDist);
        } else {
            ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
        }
    }

    private void handleAttackMoveCommand(NpcCommand.Command cmd) {
        double sqDist;
        if (this.moveTargetPos == null || this.moveTargetPos != cmd.pos) {
            this.moveTargetPos = cmd.pos;
        }
        if ((sqDist = ((NpcPlayerOwned)this.npc).func_174818_b(this.moveTargetPos)) > 9.0) {
            this.moveToPosition(this.moveTargetPos, sqDist);
        } else {
            ((NpcPlayerOwned)this.npc).setPlayerCommand(null);
        }
    }
}

