/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class NpcWalkNodeProcessor
extends WalkNodeProcessor {
    public NpcWalkNodeProcessor() {
        this.func_186321_b(true);
        this.func_186317_a(true);
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        boolean flag3;
        int i = 0;
        int j = 0;
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            j = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos blockpos = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double d0 = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos).field_72337_e);
        PathPoint southPoint = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH);
        PathPoint westPoint = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.WEST);
        PathPoint eastPoint = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.EAST);
        PathPoint northPoint = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH);
        if (southPoint != null && southPoint.field_186287_m != PathNodeType.BLOCKED && !southPoint.field_75842_i && southPoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = southPoint;
        }
        if (westPoint != null && westPoint.field_186287_m != PathNodeType.BLOCKED && !westPoint.field_75842_i && westPoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = westPoint;
        }
        if (eastPoint != null && eastPoint.field_186287_m != PathNodeType.BLOCKED && !eastPoint.field_75842_i && eastPoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = eastPoint;
        }
        if (northPoint != null && northPoint.field_186287_m != PathNodeType.BLOCKED && !northPoint.field_75842_i && northPoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = northPoint;
        }
        boolean flag = northPoint == null || northPoint.field_186287_m == PathNodeType.OPEN || northPoint.field_186287_m != PathNodeType.BLOCKED && northPoint.field_186286_l != 0.0f;
        boolean flag1 = southPoint == null || southPoint.field_186287_m == PathNodeType.OPEN || southPoint.field_186287_m != PathNodeType.BLOCKED && southPoint.field_186286_l != 0.0f;
        boolean flag2 = eastPoint == null || eastPoint.field_186287_m == PathNodeType.OPEN || eastPoint.field_186287_m != PathNodeType.BLOCKED && eastPoint.field_186286_l != 0.0f;
        boolean bl = flag3 = westPoint == null || westPoint.field_186287_m == PathNodeType.OPEN || westPoint.field_186287_m != PathNodeType.BLOCKED && westPoint.field_186286_l != 0.0f;
        if (flag && flag3 && (pathpoint4 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint4.field_75842_i && pathpoint4.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint4;
        }
        if (flag && flag2 && (pathpoint5 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint5.field_75842_i && pathpoint5.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint5;
        }
        if (flag1 && flag3 && (pathpoint6 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint6.field_75842_i && pathpoint6.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint6;
        }
        if (flag1 && flag2 && (pathpoint7 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint7.field_75842_i && pathpoint7.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint7;
        }
        return i;
    }

    @Nullable
    private PathPoint getSafePoint(int x, int y, int z, int p_186332_4_, double p_186332_5_, EnumFacing facing) {
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockPos blockpos1 = blockpos.func_177977_b();
        double d0 = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos1).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos1).field_72337_e);
        if (d0 - p_186332_5_ > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
        float pathPriority = this.field_186326_b.func_184643_a(pathnodetype);
        double d1 = (double)this.field_186326_b.field_70130_N / 2.0;
        if (pathnodetype == PathNodeType.BLOCKED || pathPriority >= 0.0f) {
            pathpoint = this.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, pathPriority);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return pathpoint;
        }
        if (!(pathpoint != null && pathnodetype != PathNodeType.BLOCKED || p_186332_4_ <= 0 || pathnodetype == PathNodeType.FENCE || pathnodetype == PathNodeType.TRAPDOOR || (pathpoint = this.getSafePoint(x, y + 1, z, p_186332_4_ - 1, p_186332_5_, facing)) == null || pathpoint.field_186287_m != PathNodeType.OPEN && pathpoint.field_186287_m != PathNodeType.WALKABLE || !(this.field_186326_b.field_70130_N < 1.0f))) {
            double d2 = (double)(x - facing.func_82601_c()) + 0.5;
            double d3 = (double)(z - facing.func_82599_e()) + 0.5;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(d2 - d1, (double)y + 0.001, d3 - d1, d2 + d1, (double)((float)y + this.field_186326_b.field_70131_O), d3 + d1);
            AxisAlignedBB axisalignedbb1 = this.field_176169_a.func_180495_p(blockpos).func_185900_c(this.field_176169_a, blockpos);
            AxisAlignedBB axisalignedbb2 = axisalignedbb.func_72321_a(0.0, axisalignedbb1.field_72337_e - 0.002, 0.0);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb2)) {
                pathpoint = null;
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB axisalignedbb3 = new AxisAlignedBB((double)x - d1 + 0.5, (double)y + 0.001, (double)z - d1 + 0.5, (double)x + d1 + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + d1 + 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb3)) {
                return null;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (pathnodetype1 = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = PathNodeType.WALKABLE;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, pathPriority);
                return pathpoint;
            }
            int i = 0;
            while (y > 0 && pathnodetype == PathNodeType.OPEN) {
                --y;
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
                pathPriority = this.field_186326_b.func_184643_a(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && pathPriority >= 0.0f) {
                    pathpoint = this.func_176159_a(x, y, z);
                    pathpoint.field_186287_m = pathnodetype;
                    pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, pathPriority);
                    break;
                }
                if (!(pathPriority < 0.0f)) continue;
                return null;
            }
        }
        return pathpoint;
    }

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, int x, int y, int z) {
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    protected PathNodeType func_189553_b(IBlockAccess world, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState iblockstate = world.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (block instanceof BlockFenceGate) {
            return (Boolean)iblockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a) != false ? PathNodeType.DOOR_OPEN : PathNodeType.DOOR_WOOD_CLOSED;
        }
        return super.func_189553_b(world, x, y, z);
    }
}

