/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityHorse;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIRideHorse<T extends NpcBase>
extends NpcAI<T> {
    private final AttributeModifier followRangeModifier;
    private final AttributeModifier moveSpeedModifier;
    protected AbstractHorse horse;
    private List<EntityAITasks.EntityAITaskEntry> horseAI = new ArrayList<EntityAITasks.EntityAITaskEntry>();

    public NpcAIRideHorse(T npc, double speedFactor) {
        super(npc);
        this.moveSpeedModifier = new AttributeModifier("modifier.npc_ride_speed", speedFactor, 1);
        this.moveSpeedModifier.func_111168_a(false);
        this.followRangeModifier = new AttributeModifier("modifier.npc_horse_path_extension", 24.0, 0);
        this.followRangeModifier.func_111168_a(false);
    }

    public boolean func_75250_a() {
        if (this.horse == null && this.npc.func_184187_bx() instanceof EntityHorse) {
            this.horse = (EntityHorse)this.npc.func_184187_bx();
            this.onMountHorse();
            return true;
        }
        return false;
    }

    protected void onMountHorse() {
        this.removeHorseAI();
        this.horse.func_110251_o(true);
        this.horse.func_110227_p(false);
        this.horse.func_110219_q(false);
        this.applyModifiers();
    }

    public void onKilled() {
        if (this.horse != null) {
            this.onDismountHorse();
            this.horse = null;
        }
    }

    protected void onDismountHorse() {
        this.addHorseAI();
        this.horse.func_110251_o(true);
        this.removeModifiers();
    }

    private void applyModifiers() {
        this.removeModifiers();
        this.horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.moveSpeedModifier);
        this.horse.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(this.followRangeModifier);
    }

    private void removeModifiers() {
        this.horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.moveSpeedModifier);
        this.horse.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111124_b(this.followRangeModifier);
    }

    private void removeHorseAI() {
        this.horseAI.clear();
        this.horseAI.addAll(this.horse.field_70714_bg.field_75782_a);
        for (EntityAITasks.EntityAITaskEntry task : this.horseAI) {
            this.horse.field_70714_bg.func_85156_a(task.field_75733_a);
        }
    }

    private void addHorseAI() {
        if (this.horse.field_70714_bg.field_75782_a.isEmpty()) {
            this.horse.field_70714_bg.field_75782_a.addAll(this.horseAI);
        }
        this.horseAI.clear();
    }
}

