/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIMedicBase
extends NpcAI<NpcBase> {
    private int injuredRecheckDelay = 0;
    private int injuredRecheckDelayMax = 20;
    private int healDelay = 0;
    private int healDelayMax = 20;
    private EntityLivingBase targetToHeal = null;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private Predicate<EntityLivingBase> selector;

    public NpcAIMedicBase(NpcBase npc) {
        super(npc);
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)npc);
        this.selector = entity -> entity.func_70089_S() && entity.func_110143_aJ() < entity.func_110138_aP() && !this.npc.isHostileTowards((Entity)entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.npc.getIsAIEnabled()) {
            return false;
        }
        if (!this.isProperSubtype()) {
            return false;
        }
        if (this.injuredRecheckDelay-- > 0) {
            return false;
        }
        this.injuredRecheckDelay = this.injuredRecheckDelayMax;
        double dist = this.npc.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        AxisAlignedBB bb = this.npc.func_174813_aQ().func_72321_a(dist, dist / 2.0, dist);
        List potentialTargets = this.npc.field_70170_p.func_175647_a(EntityLivingBase.class, bb, this.selector);
        if (potentialTargets.isEmpty()) {
            return false;
        }
        potentialTargets.sort(this.sorter);
        List sub = potentialTargets.stream().filter(input -> input instanceof NpcBase || input instanceof EntityPlayer).collect(Collectors.toList());
        Iterator iterator = sub.iterator();
        while (iterator.hasNext()) {
            EntityLivingBase base;
            this.targetToHeal = base = (EntityLivingBase)iterator.next();
            if (!this.validateTarget()) continue;
            return true;
        }
        this.targetToHeal = (EntityLivingBase)potentialTargets.get(0);
        if (!this.validateTarget()) {
            this.targetToHeal = null;
            return false;
        }
        return true;
    }

    private boolean validateTarget() {
        return this.targetToHeal != null && this.targetToHeal.func_70089_S() && this.targetToHeal.func_110143_aJ() < this.targetToHeal.func_110138_aP();
    }

    public boolean func_75253_b() {
        return this.npc.getIsAIEnabled() && this.isProperSubtype() && this.validateTarget();
    }

    protected boolean isProperSubtype() {
        return "medic".equals(this.npc.getNpcSubType());
    }

    public void func_75249_e() {
        this.npc.addAITask(64);
    }

    public void func_75246_d() {
        double attackDistance;
        double dist = this.npc.func_70068_e((Entity)this.targetToHeal);
        if (dist > (attackDistance = (double)(this.npc.field_70130_N * this.npc.field_70130_N * 2.0f * 2.0f + this.targetToHeal.field_70130_N * this.targetToHeal.field_70130_N * 2.0f * 2.0f))) {
            this.npc.addAITask(512);
            this.moveToEntity((Entity)this.targetToHeal, dist);
            this.healDelay = this.healDelayMax;
        } else {
            this.npc.removeAITask(512);
            --this.healDelay;
            if (this.healDelay < 0) {
                this.healDelay = this.healDelayMax;
                float amountToHeal = (float)this.npc.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 2.0f;
                this.npc.func_184609_a(EnumHand.MAIN_HAND);
                this.targetToHeal.func_70691_i(amountToHeal);
            }
        }
    }

    public void func_75251_c() {
        this.npc.removeAITask(576);
        this.targetToHeal = null;
    }
}

