/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcCombat;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;

public class NpcAIFleeHostiles
extends NpcAI<NpcPlayerOwned> {
    private static final int MAX_STAY_AWAY = 50;
    private static final int MAX_FLEE_RANGE = 16;
    private static final int HEIGHT_CHECK = 7;
    private static final int PURSUE_RANGE = 256;
    private final Predicate<EntityLiving> hostileOrFriendlyCombatNpcSelector;
    private final Comparator<Entity> sorter;
    private double distanceFromEntity = 16.0;
    private Vec3d fleeVector;
    private int stayOutOfSightTimer = 0;
    private int fearLevel = 0;
    private boolean homeCompromised = false;
    private LinkedHashSet<NpcCombat> nearbySoldiers = new LinkedHashSet();
    private int ticker = 0;
    private static final int TICKER_MAX = 5;

    public NpcAIFleeHostiles(NpcPlayerOwned npc) {
        super(npc);
        this.hostileOrFriendlyCombatNpcSelector = selectedEntity -> {
            if (selectedEntity != null && selectedEntity.func_70089_S()) {
                if (selectedEntity instanceof NpcBase) {
                    return ((NpcBase)selectedEntity).getNpcSubType().equals("soldier") && ((NpcBase)selectedEntity).hasCommandPermissions(npc.getOwner()) || ((NpcBase)selectedEntity).isHostileTowards((Entity)this.npc);
                }
                return ((NpcPlayerOwned)this.npc).isHostileTowards((Entity)selectedEntity);
            }
            return false;
        };
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)npc);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!((NpcPlayerOwned)this.npc).getIsAIEnabled()) {
            return false;
        }
        if (this.fearLevel > 0) {
            --this.fearLevel;
        }
        ++this.ticker;
        if (this.ticker != 5) {
            return false;
        }
        this.ticker = 0;
        boolean flee = false;
        this.findNearbyRelevantEntities();
        if (!((NpcPlayerOwned)this.npc).nearbyHostiles.isEmpty()) {
            Entity nearestHostile = (Entity)((NpcPlayerOwned)this.npc).nearbyHostiles.iterator().next();
            if (((NpcPlayerOwned)this.npc).getTownHallPosition().isPresent() || ((NpcPlayerOwned)this.npc).func_110175_bO()) {
                flee = true;
            } else {
                this.fleeVector = RandomPositionGenerator.func_75461_b((EntityCreature)this.npc, (int)16, (int)7, (Vec3d)new Vec3d(nearestHostile.field_70165_t, nearestHostile.field_70163_u, nearestHostile.field_70161_v));
                boolean bl = flee = this.fleeVector != null && nearestHostile.func_70092_e(this.fleeVector.field_72450_a, this.fleeVector.field_72448_b, this.fleeVector.field_72449_c) >= nearestHostile.func_70068_e((Entity)this.npc);
            }
            if (flee) {
                if (nearestHostile instanceof EntityLivingBase) {
                    ((NpcPlayerOwned)this.npc).func_70624_b((EntityLivingBase)nearestHostile);
                } else {
                    AncientWarfareNPC.LOG.error("Attempted to flee an entity that isn't EntityLiving: '" + EntityList.func_75621_b((Entity)nearestHostile) + "', ignoring! Please report this error.");
                }
            }
        }
        return flee;
    }

    private void findNearbyRelevantEntities() {
        ((NpcPlayerOwned)this.npc).nearbyHostiles.clear();
        this.nearbySoldiers.clear();
        List nearbyHostilesOrFriendlySoldiers = ((NpcPlayerOwned)this.npc).field_70170_p.func_175647_a(EntityLiving.class, ((NpcPlayerOwned)this.npc).func_174813_aQ().func_72321_a(this.distanceFromEntity, 3.0, this.distanceFromEntity), this.hostileOrFriendlyCombatNpcSelector);
        if (nearbyHostilesOrFriendlySoldiers.isEmpty()) {
            return;
        }
        nearbyHostilesOrFriendlySoldiers.sort(this.sorter);
        for (Object entity : nearbyHostilesOrFriendlySoldiers) {
            if (!((NpcPlayerOwned)this.npc).func_70685_l((Entity)entity)) continue;
            if (entity instanceof NpcBase) {
                if (!((NpcBase)entity).getNpcSubType().equals("soldier") || !((NpcBase)entity).hasCommandPermissions(((NpcPlayerOwned)this.npc).getOwner())) continue;
                this.nearbySoldiers.add((NpcCombat)entity);
                continue;
            }
            ((NpcPlayerOwned)this.npc).nearbyHostiles.add((Entity)entity);
        }
    }

    public void func_75249_e() {
        ((NpcPlayerOwned)this.npc).addAITask(8);
        ((NpcPlayerOwned)this.npc).addAITask(2048);
        this.stayOutOfSightTimer = 50 + this.fearLevel;
        this.fearLevel += 50;
    }

    public boolean func_75253_b() {
        boolean shouldPanic = true;
        if (((NpcPlayerOwned)this.npc).getIsAIEnabled() && (((NpcPlayerOwned)this.npc).func_70638_az() == null || ((NpcPlayerOwned)this.npc).func_70638_az().field_70128_L)) {
            this.fearLevel = 50;
        }
        if (this.stayOutOfSightTimer == 0) {
            this.findNearbyRelevantEntities();
            shouldPanic = false;
        }
        if (!shouldPanic && !((NpcPlayerOwned)this.npc).nearbyHostiles.isEmpty()) {
            this.stayOutOfSightTimer = 50 + this.fearLevel;
            shouldPanic = true;
            this.announceDistress();
        }
        return shouldPanic;
    }

    public void func_75246_d() {
        if (((NpcPlayerOwned)this.npc).func_70638_az() == null || ((NpcPlayerOwned)this.npc).func_70638_az().field_70128_L) {
            ((NpcPlayerOwned)this.npc).func_70624_b(null);
            this.stayOutOfSightTimer = 0;
            return;
        }
        BlockPos pos = null;
        double distSq = 0.0;
        if (((NpcPlayerOwned)this.npc).func_110175_bO()) {
            distSq = ((NpcPlayerOwned)this.npc).getDistanceSqFromHome();
            pos = ((NpcPlayerOwned)this.npc).func_180486_cf();
            if (distSq < 9.0 && !((NpcPlayerOwned)this.npc).nearbyHostiles.isEmpty()) {
                this.homeCompromised = true;
                ((NpcPlayerOwned)this.npc).addAITask(1024);
            }
        }
        if (this.homeCompromised || !((NpcPlayerOwned)this.npc).func_110175_bO()) {
            distSq = ((NpcPlayerOwned)this.npc).getTownHallPosition().map(townHallPos -> ((NpcPlayerOwned)this.npc).func_174818_b((BlockPos)townHallPos)).orElse(distSq);
        }
        if (pos == null) {
            if (this.fleeVector == null) {
                return;
            }
            distSq = ((NpcPlayerOwned)this.npc).func_70092_e(this.fleeVector.field_72450_a, this.fleeVector.field_72448_b, this.fleeVector.field_72449_c);
            if (distSq > 9.0) {
                this.moveToPosition(this.fleeVector.field_72450_a, this.fleeVector.field_72448_b, this.fleeVector.field_72449_c, distSq);
            } else if (((NpcPlayerOwned)this.npc).func_70068_e((Entity)((NpcPlayerOwned)this.npc).func_70638_az()) < 256.0) {
                this.fleeVector = RandomPositionGenerator.func_75461_b((EntityCreature)this.npc, (int)16, (int)7, (Vec3d)new Vec3d(((NpcPlayerOwned)this.npc).func_70638_az().field_70165_t, ((NpcPlayerOwned)this.npc).func_70638_az().field_70163_u, ((NpcPlayerOwned)this.npc).func_70638_az().field_70161_v));
                if (this.fleeVector == null) {
                    ((NpcPlayerOwned)this.npc).func_70624_b(null);
                }
            } else {
                ((NpcPlayerOwned)this.npc).func_70624_b(null);
            }
        }
        if (pos != null && distSq > 9.0) {
            this.moveToPosition(pos, distSq);
        }
        if (this.stayOutOfSightTimer > 0) {
            --this.stayOutOfSightTimer;
        } else {
            this.func_75251_c();
        }
    }

    public void func_75251_c() {
        this.fleeVector = null;
        ((NpcPlayerOwned)this.npc).func_70661_as().func_75499_g();
        ((NpcPlayerOwned)this.npc).func_70624_b(null);
        ((NpcPlayerOwned)this.npc).removeAITask(3080);
        this.homeCompromised = false;
    }

    private void announceDistress() {
        for (NpcCombat soldier : this.nearbySoldiers) {
            soldier.respondToDistress(this.npc);
        }
    }
}

