/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttack;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.IExtendedReachWeapon;

public class NpcAIAttackMeleeLongRange
extends NpcAIAttack<NpcBase> {
    private float attackReach = 2.5f;

    public NpcAIAttackMeleeLongRange(NpcBase npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public void setAttackReachFromWeapon(ItemStack weapon) {
        float reach = 2.5f;
        if (weapon.func_77973_b() instanceof IExtendedReachWeapon) {
            reach = ((IExtendedReachWeapon)weapon.func_77973_b()).getReach() - 1.0f;
        }
        this.attackReach = reach;
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.isTargetInRange();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.isTargetInRange();
    }

    private boolean isTargetInRange() {
        return (double)this.npc.func_70032_d((Entity)this.npc.func_70638_az()) < this.getAdjustedTargetDistance();
    }

    private double getAdjustedTargetDistance() {
        return Math.max(this.getTargetDistance() / (this.getHomeDistance() / 20.0), 3.0);
    }

    private double getHomeDistance() {
        BlockPos cc = this.npc.func_180486_cf();
        float distSq = (float)this.npc.func_70092_e((double)cc.func_177958_n() + 0.5, cc.func_177956_o(), (double)cc.func_177952_p() + 0.5);
        return Math.sqrt(distSq);
    }

    private double getTargetDistance() {
        IAttributeInstance iattributeinstance = this.npc.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }

    @Override
    protected boolean shouldCloseOnTarget(double distanceToEntity) {
        double attackDistance = (double)this.npc.field_70130_N / 2.0 + (double)this.getTarget().field_70130_N / 2.0 + (double)this.attackReach;
        return distanceToEntity > attackDistance * attackDistance || !this.npc.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    @Override
    protected void doAttack(double distanceToEntity) {
        this.npc.removeAITask(512);
        if (this.getAttackDelay() <= 0) {
            this.npc.func_184609_a(EnumHand.MAIN_HAND);
            this.npc.func_70652_k((Entity)this.getTarget());
            this.setAttackDelay(this.getCoolDown());
            this.npc.addExperience(AWNPCStatics.npcXpFromAttack);
        }
    }

    private int getCoolDown() {
        int entityAttackCooldown = (int)(1.0 / this.npc.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0);
        return entityAttackCooldown > 0 ? entityAttackCooldown : 20;
    }
}

