/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util.parsing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.RegistryTools;
import net.shadowmage.ancientwarfare.core.util.parsing.BlockStateMatcher;
import net.shadowmage.ancientwarfare.core.util.parsing.ItemStackMatcher;
import net.shadowmage.ancientwarfare.core.util.parsing.MultiBlockStateMatcher;
import net.shadowmage.ancientwarfare.core.util.parsing.PropertyState;
import net.shadowmage.ancientwarfare.core.util.parsing.PropertyStateMatcher;

public class JsonHelper {
    public static IBlockState getBlockState(JsonObject parent, String elementName) {
        return JsonHelper.getBlockState(parent, elementName, Block::func_176223_P, BlockTools::updateProperty);
    }

    public static BlockStateMatcher getBlockStateMatcher(JsonElement stateJson) {
        return BlockTools.getBlockState(JsonHelper.getBlockNameAndProperties(stateJson), BlockStateMatcher::new, BlockStateMatcher::addProperty);
    }

    public static BlockStateMatcher getBlockStateMatcher(JsonObject stateJson) {
        return JsonHelper.getBlockState(stateJson, BlockStateMatcher::new, BlockStateMatcher::addProperty);
    }

    public static BlockStateMatcher getBlockStateMatcher(JsonObject parent, String elementName) {
        return JsonHelper.getBlockState(parent, elementName, BlockStateMatcher::new, BlockStateMatcher::addProperty);
    }

    public static ItemStack getItemStack(JsonElement json) {
        return JsonHelper.getItemStack(json, (Item i, int c, int m, NBTTagCompound t) -> {
            ItemStack stack = new ItemStack(i, c, m);
            stack.func_77982_d(t);
            return stack;
        });
    }

    public static ItemStack getItemStack(JsonObject json, String elementName) {
        if (!JsonUtils.func_151204_g((JsonObject)json, (String)elementName)) {
            throw new JsonParseException("Expected " + elementName + " member in " + json.toString());
        }
        return JsonHelper.getItemStack(json.get(elementName));
    }

    private static <T> T getItemStack(JsonElement element, ItemStackCreator<T> creator) {
        if (element.isJsonPrimitive()) {
            return creator.instantiate(RegistryTools.getItem(element.getAsString()), 1, -1, null);
        }
        JsonObject obj = element.getAsJsonObject();
        String registryName = JsonUtils.func_151200_h((JsonObject)obj, (String)"name");
        Item item = RegistryTools.getItem(registryName);
        int count = JsonUtils.func_151204_g((JsonObject)obj, (String)"count") ? JsonUtils.func_151203_m((JsonObject)obj, (String)"count") : 1;
        int meta = -1;
        if (JsonUtils.func_151204_g((JsonObject)obj, (String)"data")) {
            meta = JsonUtils.func_151203_m((JsonObject)obj, (String)"data");
        }
        NBTTagCompound tagCompound = null;
        if (JsonUtils.func_151204_g((JsonObject)obj, (String)"nbt")) {
            try {
                tagCompound = JsonToNBT.func_180713_a((String)JsonUtils.func_151200_h((JsonObject)obj, (String)"nbt"));
            }
            catch (NBTException e) {
                AncientWarfareCore.LOG.error("Error reading item stack nbt ", (Object)JsonUtils.func_152754_s((JsonObject)obj, (String)"nbt"));
            }
        }
        return creator.instantiate(item, count, meta, tagCompound);
    }

    public static ItemStackMatcher getItemStackMatcher(JsonElement element) {
        return JsonHelper.getItemStack(element, (Item i, int c, int m, NBTTagCompound t) -> new ItemStackMatcher.Builder(i).setMeta(m).setTagCompound(t).build());
    }

    public static ItemStackMatcher getItemStackMatcher(JsonObject parent, String elementName) {
        if (!JsonUtils.func_151204_g((JsonObject)parent, (String)elementName)) {
            throw new JsonParseException("Expected " + elementName + " member in " + parent.toString());
        }
        return JsonHelper.getItemStackMatcher(parent.get(elementName));
    }

    private static <T> T getBlockState(JsonObject stateJson, Function<Block, T> init, BlockTools.AddPropertyFunction<T> addProperty) {
        return BlockTools.getBlockState(JsonHelper.getBlockNameAndProperties(stateJson), init, addProperty);
    }

    private static <T> T getBlockState(JsonObject parent, String elementName, Function<Block, T> init, BlockTools.AddPropertyFunction<T> addProperty) {
        return BlockTools.getBlockState(JsonHelper.getBlockNameAndProperties(parent, elementName), init, addProperty);
    }

    private static Tuple<String, Map<String, String>> getBlockNameAndProperties(JsonObject stateJson) {
        HashMap properties = new HashMap();
        if (JsonUtils.func_151204_g((JsonObject)stateJson, (String)"properties")) {
            JsonUtils.func_152754_s((JsonObject)stateJson, (String)"properties").entrySet().forEach(p -> properties.put(p.getKey(), ((JsonElement)p.getValue()).getAsString()));
        }
        return new Tuple((Object)JsonUtils.func_151200_h((JsonObject)stateJson, (String)"name"), properties);
    }

    private static Tuple<String, Map<String, String>> getBlockNameAndProperties(JsonElement stateElement) {
        if (stateElement.isJsonPrimitive()) {
            return new Tuple((Object)JsonUtils.func_151206_a((JsonElement)stateElement, (String)""), new HashMap());
        }
        return JsonHelper.getBlockNameAndProperties(JsonUtils.func_151210_l((JsonElement)stateElement, (String)""));
    }

    private static Tuple<String, Map<String, String>> getBlockNameAndProperties(JsonObject parent, String elementName) {
        if (!JsonUtils.func_151204_g((JsonObject)parent, (String)elementName)) {
            throw new JsonParseException("Expected " + elementName + " member in " + parent.toString());
        }
        return JsonHelper.getBlockNameAndProperties(parent.get(elementName));
    }

    public static Predicate<IBlockState> getBlockStateMatcher(JsonObject json, String arrayElement, String individualElement) {
        if (json.has(arrayElement)) {
            JsonArray stateMatchers = JsonUtils.func_151214_t((JsonObject)json, (String)arrayElement);
            return new MultiBlockStateMatcher((BlockStateMatcher[])StreamSupport.stream(stateMatchers.spliterator(), false).map(e -> JsonHelper.getBlockStateMatcher(JsonUtils.func_151210_l((JsonElement)e, (String)individualElement))).toArray(BlockStateMatcher[]::new));
        }
        return JsonHelper.getBlockStateMatcher(json, individualElement);
    }

    public static PropertyState getPropertyState(IBlockState state, JsonObject parent, String elementName) {
        JsonObject jsonProperty = JsonUtils.func_152754_s((JsonObject)parent, (String)elementName);
        if (jsonProperty.entrySet().isEmpty()) {
            throw new JsonParseException("Expected at least one property defined for " + elementName + " in " + parent.toString());
        }
        Map.Entry propJson = (Map.Entry)jsonProperty.entrySet().iterator().next();
        String propName = (String)propJson.getKey();
        String propValue = ((JsonElement)propJson.getValue()).getAsString();
        return BlockTools.getPropertyState(state.func_177230_c(), state.func_177230_c().func_176194_O(), propName, propValue);
    }

    public static PropertyStateMatcher getPropertyStateMatcher(IBlockState state, JsonObject parent, String elementName) {
        return new PropertyStateMatcher(JsonHelper.getPropertyState(state, parent, elementName));
    }

    public static <K, V> Map<K, V> mapFromJson(JsonObject json, String propertyName, Function<Map.Entry<String, JsonElement>, K> parseKey, Function<Map.Entry<String, JsonElement>, V> parseValue) {
        return JsonHelper.mapFromObjectProperties(JsonUtils.func_152754_s((JsonObject)json, (String)propertyName), new HashMap(), parseKey, parseValue);
    }

    public static <K, V> Map<K, V> mapFromJson(JsonElement json, Function<Map.Entry<String, JsonElement>, K> parseKey, Function<Map.Entry<String, JsonElement>, V> parseValue) {
        return JsonHelper.mapFromObjectProperties(JsonUtils.func_151210_l((JsonElement)json, (String)""), new HashMap(), parseKey, parseValue);
    }

    public static <K, V> void mapFromJson(JsonObject json, String propertyName, Map<K, V> ret, Function<Map.Entry<String, JsonElement>, K> parseKey, Function<Map.Entry<String, JsonElement>, V> parseValue) {
        JsonHelper.mapFromObjectProperties(JsonUtils.func_152754_s((JsonObject)json, (String)propertyName), ret, parseKey, parseValue);
    }

    public static <K, V> Map<K, V> mapFromObjectArray(JsonArray jsonArray, String keyName, String valueName, Function<JsonElement, K> parseKey, Function<JsonElement, V> parseValue) {
        HashMap<K, V> ret = new HashMap<K, V>();
        for (JsonElement element : jsonArray) {
            JsonObject entry = JsonUtils.func_151210_l((JsonElement)element, (String)"");
            ret.put(parseKey.apply(entry.get(keyName)), parseValue.apply(entry.get(valueName)));
        }
        return ret;
    }

    private static <K, V> Map<K, V> mapFromObjectProperties(JsonObject jsonObject, Map<K, V> ret, Function<Map.Entry<String, JsonElement>, K> parseKey, Function<Map.Entry<String, JsonElement>, V> parseValue) {
        for (Map.Entry pair : jsonObject.entrySet()) {
            ret.put(parseKey.apply(pair), parseValue.apply(pair));
        }
        return ret;
    }

    public static List<ItemStack> getItemStacks(JsonArray stacks) {
        NonNullList ret = NonNullList.func_191196_a();
        for (JsonElement stackElement : stacks) {
            ret.add(JsonHelper.getItemStack((JsonElement)JsonUtils.func_151210_l((JsonElement)stackElement, (String)"itemstack")));
        }
        return ret;
    }

    public static <V> Set<V> setFromJson(JsonElement element, Function<JsonElement, V> getElement) {
        return JsonHelper.setFromJson(JsonUtils.func_151207_m((JsonElement)element, (String)""), getElement);
    }

    private static <V> Set<V> setFromJson(JsonArray array, Function<JsonElement, V> getElement) {
        HashSet<V> ret = new HashSet<V>();
        for (JsonElement element : array) {
            ret.add(getElement.apply(element));
        }
        return ret;
    }

    private static interface ItemStackCreator<R> {
        public R instantiate(Item var1, int var2, int var3, @Nullable NBTTagCompound var4);
    }
}

