/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util.parsing;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class BlockStateMatcher
implements Predicate<IBlockState> {
    private final Block block;
    private final PropertyMapMatcher propertyMatcher = new PropertyMapMatcher();

    public BlockStateMatcher(IBlockState fullState) {
        this(fullState.func_177230_c());
        fullState.func_177228_b().forEach(this::addProperty);
    }

    public BlockStateMatcher(Block block) {
        this.block = block;
    }

    BlockStateMatcher addProperty(IProperty<?> property, Comparable<?> value) {
        this.propertyMatcher.addProperty(property, value);
        return this;
    }

    @Override
    public boolean test(IBlockState state) {
        return this.block == state.func_177230_c() && this.propertyMatcher.test((Map<IProperty<?>, Comparable<?>>)state.func_177228_b());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStateMatcher that = (BlockStateMatcher)o;
        return this.block.equals(that.block) && this.propertyMatcher.equals(that.propertyMatcher);
    }

    public int hashCode() {
        int result = this.block.hashCode();
        result = 31 * result + this.propertyMatcher.hashCode();
        return result;
    }

    public static class PropertyMapMatcher
    implements Predicate<Map<IProperty<?>, Comparable<?>>> {
        private final Map<IProperty<?>, Comparable<?>> propertyValues = new HashMap();

        void addProperty(IProperty<?> property, Comparable<?> value) {
            this.propertyValues.put(property, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyMapMatcher that = (PropertyMapMatcher)o;
            return this.propertyValues.equals(that.propertyValues);
        }

        public int hashCode() {
            return this.propertyValues.hashCode();
        }

        @Override
        public boolean test(Map<IProperty<?>, Comparable<?>> properties) {
            for (Map.Entry<IProperty<?>, Comparable<?>> property : this.propertyValues.entrySet()) {
                if (properties.containsKey(property.getKey()) && property.getValue().equals(properties.get(property.getKey()))) continue;
                return false;
            }
            return true;
        }
    }
}

