/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.TextureImageBased;

@SideOnly(value=Side.CLIENT)
public class TextureUtils {
    private TextureUtils() {
    }

    public static ResourceLocation getTextureLocation(String path) {
        String overridePath = "config/ancientwarfare/" + path;
        ResourceLocation locationOverride = new ResourceLocation("ancientwarfare", overridePath);
        if (TextureUtils.textureLoaded(locationOverride)) {
            return locationOverride;
        }
        ResourceLocation locationMain = new ResourceLocation("ancientwarfare", path);
        if (TextureUtils.textureLoaded(locationMain)) {
            return locationMain;
        }
        if (TextureUtils.loadTexture(locationOverride, overridePath)) {
            return locationOverride;
        }
        if (TextureUtils.loadTextureFromAssets(locationMain, path)) {
            return locationMain;
        }
        return TextureMap.field_174945_f;
    }

    private static boolean textureLoaded(ResourceLocation loc) {
        return Minecraft.func_71410_x().func_110434_K().func_110581_b(loc) != null;
    }

    private static boolean loadTexture(ResourceLocation loc, String path) {
        File file = new File(path);
        return file.exists() && TextureUtils.loadTexture(loc, file);
    }

    private static boolean loadTexture(ResourceLocation loc, File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            Minecraft.func_71410_x().field_71446_o.func_110579_a(loc, (ITextureObject)new TextureImageBased(loc, image));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadTextureFromAssets(ResourceLocation loc, String path) {
        String fullPath = "assets/ancientwarfare/" + path;
        File source = Loader.instance().activeModContainer().getSource();
        if (!source.isFile()) {
            if (!source.isDirectory()) return false;
            File file = source.toPath().resolve(fullPath).toFile();
            if (!TextureUtils.loadTexture(loc, file)) return false;
            return true;
        }
        try (FileSystem fs2222 = FileSystems.newFileSystem(source.toPath(), null);){
            InputStream inputstream = fs2222.provider().newInputStream(fs2222.getPath(fullPath, new String[0]), new OpenOption[0]);
            Minecraft.func_71410_x().field_71446_o.func_110579_a(loc, (ITextureObject)new TextureImageBased(loc, ImageIO.read(inputstream)));
            boolean bl = true;
            return bl;
        }
        catch (IOException fs2222) {
            return false;
        }
    }
}

