/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.Trig;

public class RayTraceUtils {
    public static RayTraceResult getPlayerTarget(EntityPlayer player, float range, float border) {
        HashSet<Entity> excluded = new HashSet<Entity>();
        excluded.add((Entity)player);
        if (player.func_184187_bx() != null) {
            excluded.add(player.func_184187_bx());
        }
        float yOffset = player.func_70047_e();
        Vec3d look = player.func_70040_Z();
        look = look.func_186678_a((double)range);
        look = look.func_72441_c(player.field_70165_t, player.field_70163_u + (double)yOffset, player.field_70161_v);
        return RayTraceUtils.tracePath(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)yOffset, player.field_70161_v, look.field_72450_a, look.field_72448_b, look.field_72449_c, border, excluded);
    }

    public static RayTraceResult tracePathWithYawPitch(World world, float x, float y, float z, float yaw, float pitch, float range, float borderSize, HashSet<Entity> excluded) {
        float tx = x + Trig.sinDegrees(yaw + 180.0f) * range * Trig.cosDegrees(pitch);
        float ty = -Trig.sinDegrees(pitch) * range + y;
        float tz = z + Trig.cosDegrees(yaw) * range * Trig.cosDegrees(pitch);
        return RayTraceUtils.tracePath(world, x, y, z, tx, ty, tz, borderSize, excluded);
    }

    public static RayTraceResult tracePath(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, HashSet<Entity> excluded) {
        double minX = x < tx ? x : tx;
        double minY = y < ty ? y : ty;
        double minZ = z < tz ? z : tz;
        double maxX = x > tx ? x : tx;
        double maxY = y > ty ? y : ty;
        double maxZ = z > tz ? z : tz;
        AxisAlignedBB bb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ).func_72321_a((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        Entity closestHitEntity = null;
        float closestHit = Float.POSITIVE_INFINITY;
        Vec3d startVec = new Vec3d(x, y, z);
        Vec3d endVec = new Vec3d(tx, ty, tz);
        for (Entity ent : allEntities) {
            float currentHit;
            float entBorder;
            RayTraceResult intercept;
            AxisAlignedBB entityBb;
            if (!ent.func_70067_L() || excluded.contains(ent) || (entityBb = ent.func_174813_aQ()) == null || (intercept = entityBb.func_72321_a((double)(entBorder = ent.func_70111_Y()), (double)entBorder, (double)entBorder).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            return new RayTraceResult(closestHitEntity);
        }
        startVec = new Vec3d(x, y, z);
        endVec = new Vec3d(tx, ty, tz);
        return world.func_72933_a(startVec, endVec);
    }
}

