/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.Function2;

@SideOnly(value=Side.CLIENT)
public class ModelLoaderHelper {
    private ModelLoaderHelper() {
    }

    public static void registerItem(Item item, String prefix) {
        ModelLoaderHelper.registerItem(item, prefix, "inventory");
    }

    public static void registerItem(Item item, String prefix, boolean metaSuffix) {
        ModelLoaderHelper.registerItem(item, prefix, metaSuffix, "inventory");
    }

    public static void registerItem(Block block, String prefix, String variant, boolean metaSuffix) {
        ModelLoaderHelper.registerItem(Item.func_150898_a((Block)block), prefix, metaSuffix, variant);
    }

    public static void registerItem(Block block, String prefix, String variant) {
        ModelLoaderHelper.registerItem(Item.func_150898_a((Block)block), prefix, variant);
    }

    public static void registerItem(Item item, String prefix, String variant) {
        ModelLoaderHelper.registerItem(item, prefix, true, variant);
    }

    public static void registerItem(Item item, String prefix, boolean metaSuffix, String variant) {
        ModelLoaderHelper.registerItem(item, prefix, metaSuffix, (Integer meta) -> variant);
    }

    public static void registerItem(Item item, String prefix, boolean metaSuffix, Function<Integer, String> getVariant) {
        ModelLoaderHelper.registerItem(item, (Item it, Integer meta) -> {
            String modelName = "ancientwarfare:" + (prefix.isEmpty() ? "" : prefix + "/") + it.getRegistryName().func_110623_a();
            String suffix = it.func_77614_k() && metaSuffix ? "_" + meta : "";
            return new ModelResourceLocation(modelName + suffix, (String)getVariant.apply((Integer)meta));
        });
    }

    public static void registerItem(Block block, ModelResourceLocation modelLocation) {
        ModelLoaderHelper.registerItem(Item.func_150898_a((Block)block), (Item i, Integer m) -> modelLocation);
    }

    public static void registerItem(Item item, Function2<Item, Integer, ModelResourceLocation> getModelLocation) {
        if (item.func_77614_k()) {
            NonNullList subItems = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), subItems);
            for (ItemStack subItem : subItems) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)subItem.func_77960_j(), (ModelResourceLocation)getModelLocation.apply(item, subItem.func_77960_j()));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)getModelLocation.apply(item, 0));
        }
    }

    public static void registerItem(Item item, int meta, String modelVariantName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("ancientwarfare:" + modelVariantName));
    }

    public static void registerItem(Item item, int meta, String modelName, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(modelName, variant));
    }
}

