/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import org.apache.commons.lang3.Validate;

public class InventoryTools {
    public static boolean canInventoryHold(IItemHandler handler, ItemStack stack) {
        return InventoryTools.insertItem(handler, stack, true).func_190926_b();
    }

    public static boolean canInventoryHold(IItemHandler handler, List<ItemStack> stacks) {
        return InventoryTools.insertItems(handler, stacks, true).isEmpty();
    }

    public static List<ItemStack> insertItems(IItemHandler handler, List<ItemStack> stacks, boolean simulate) {
        NonNullList remainingItems = NonNullList.func_191196_a();
        if (simulate) {
            handler = InventoryTools.cloneItemHandler(handler);
        }
        for (ItemStack stack : stacks) {
            ItemStack remainingItem = InventoryTools.insertItem(handler, stack, false);
            if (remainingItem.func_190926_b()) continue;
            remainingItems.add((Object)remainingItem);
        }
        return remainingItems;
    }

    public static IItemHandlerModifiable cloneItemHandler(final IItemHandler handler) {
        ItemStackHandler copy = new ItemStackHandler(handler.getSlots()){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return this.canInsert(slot, stack) ? super.insertItem(slot, stack.func_77946_l(), simulate) : stack;
            }

            private boolean canInsert(int slot, @Nonnull ItemStack stack) {
                ItemStack remainingStack = handler.insertItem(slot, stack, true);
                return remainingStack.func_190926_b() || remainingStack.func_190916_E() != stack.func_190916_E();
            }
        };
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            copy.setStackInSlot(slot, handler.getStackInSlot(slot).func_77946_l());
        }
        return copy;
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack stack) {
        return InventoryTools.insertItem(handler, stack, false);
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack stack, boolean simulate) {
        ItemStack remaining = stack;
        for (int slot = 0; slot < handler.getSlots() && !(remaining = handler.insertItem(slot, remaining, simulate)).func_190926_b(); ++slot) {
        }
        return remaining;
    }

    public static void updateCursorItem(EntityPlayerMP player, ItemStack stack, boolean shiftClick) {
        if (!stack.func_190926_b()) {
            if (shiftClick) {
                stack = InventoryTools.mergeItemStack((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack);
            }
            if (!stack.func_190926_b()) {
                player.field_71071_by.func_70437_b(stack);
                player.func_71113_k();
            }
        }
    }

    public static ItemStack mergeItemStack(IItemHandler handler, ItemStack stack) {
        int i;
        ItemStack ret = stack;
        if (stack.func_77985_e()) {
            for (i = 0; i < handler.getSlots() && !stack.func_190926_b(); ++i) {
                ItemStack slotStack = handler.getStackInSlot(i);
                if (!InventoryTools.doItemStacksMatch(slotStack, stack)) continue;
                int maxSize = Math.min(handler.getSlotLimit(i), stack.func_77976_d());
                int change = Math.min(maxSize - slotStack.func_190916_E(), stack.func_190916_E());
                handler.insertItem(i, stack, false);
                stack.func_190918_g(change);
            }
        }
        if (!stack.func_190926_b()) {
            for (i = 0; i < handler.getSlots(); ++i) {
                ItemStack itemstack1 = handler.getStackInSlot(i);
                if (!itemstack1.func_190926_b() || !handler.insertItem(i, stack, true).func_190926_b()) continue;
                int slotLimit = handler.getSlotLimit(i);
                if (stack.func_190916_E() > slotLimit) {
                    handler.insertItem(i, stack.func_77979_a(slotLimit), false);
                    continue;
                }
                handler.insertItem(i, stack.func_77979_a(stack.func_190916_E()), false);
                ret = ItemStack.field_190927_a;
                break;
            }
        }
        return ret;
    }

    public static ItemStack removeItems(IItemHandler handler, ItemStack filter, int quantity) {
        return InventoryTools.removeItems(handler, filter, quantity, false);
    }

    public static ItemStack removeItems(IItemHandler handler, ItemStack filter, int quantity, boolean simulate) {
        int toMove;
        ItemStack extractedStack;
        ItemStack slotStack;
        if (quantity <= 0) {
            return ItemStack.field_190927_a;
        }
        if (quantity > filter.func_77976_d()) {
            quantity = filter.func_77976_d();
        }
        int returnCount = 0;
        for (int index = 0; index < handler.getSlots() && ((slotStack = handler.getStackInSlot(index)).func_190926_b() || !InventoryTools.doItemStacksMatchRelaxed(filter, slotStack) || quantity - (returnCount += (extractedStack = handler.extractItem(index, toMove = Math.min(quantity - returnCount, slotStack.func_190916_E()), simulate)).func_190916_E()) > 0); ++index) {
        }
        ItemStack returnStack = ItemStack.field_190927_a;
        if (returnCount > 0) {
            returnStack = filter.func_77946_l();
            returnStack.func_190920_e(returnCount);
        }
        return returnStack;
    }

    public static int transferItems(IItemHandler from, IItemHandler to, ItemStack filter, int quantity) {
        return InventoryTools.transferItems(from, to, filter, quantity, false, false);
    }

    public static int transferItems(IItemHandler from, IItemHandler to, ItemStack filterStack, int quantity, boolean ignoreDamage, boolean ignoreNBT) {
        return InventoryTools.transferItems(from, to, (ItemStack stack) -> InventoryTools.doItemStacksMatch(filterStack, stack, ignoreDamage, ignoreNBT), quantity);
    }

    public static int transferItems(IItemHandler from, IItemHandler to, Function<ItemStack, Boolean> filter, int quantity) {
        int moved = 0;
        int toMove = quantity;
        for (int slot = 0; slot < from.getSlots() && toMove > 0; ++slot) {
            ItemStack stack = from.getStackInSlot(slot);
            if (stack.func_190926_b() || !filter.apply(stack).booleanValue()) continue;
            int stackSizeToMove = Math.min(stack.func_77976_d(), Math.min(stack.func_190916_E(), toMove));
            ItemStack stackToMove = stack.func_77946_l();
            stackToMove.func_190920_e(stackSizeToMove);
            ItemStack remaining = InventoryTools.insertItem(to, stackToMove, false);
            int stackSizeMoved = stackSizeToMove - remaining.func_190916_E();
            if (stackSizeMoved > 0) {
                from.extractItem(slot, stackSizeMoved, false);
            }
            toMove = quantity - (moved += stackSizeMoved);
        }
        return moved;
    }

    public static int findItemSlot(IItemHandler handler, Predicate<ItemStack> filter) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (!filter.test(stack)) continue;
            return slot;
        }
        return -1;
    }

    public static int getCountOf(IItemHandler handler, ItemStack filterStack) {
        return InventoryTools.getCountOf(handler, (ItemStack stack) -> !stack.func_190926_b() && InventoryTools.doItemStacksMatchRelaxed(filterStack, stack));
    }

    public static int getCountOf(IItemHandler handler, Predicate<ItemStack> filter) {
        if (handler.getSlots() <= 0) {
            return 0;
        }
        int count = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (!filter.test(stack)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static boolean hasCountOrMore(IItemHandler handler, ItemStack filterStack) {
        return InventoryTools.hasCountOrMore(handler, s -> InventoryTools.doItemStacksMatch(s, filterStack), filterStack.func_190916_E());
    }

    private static boolean hasCountOrMore(IItemHandler handler, Predicate<ItemStack> filter, int minimumCount) {
        if (handler.getSlots() <= 0) {
            return false;
        }
        int count = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (!filter.test(stack) || (count += stack.func_190916_E()) < minimumCount) continue;
            return true;
        }
        return false;
    }

    public static boolean doItemStacksMatchRelaxed(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        return OreDictionary.itemMatches((ItemStack)stack1, (ItemStack)stack2, (!stack1.func_190926_b() && (stack1.func_77984_f() || stack1.func_77952_i() != Short.MAX_VALUE) ? 1 : 0) != 0) && ItemStack.func_185132_d((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2) && stack1.areCapsCompatible(stack2);
    }

    public static boolean doItemStacksMatch(ItemStack stackA, ItemStack stackB) {
        return InventoryTools.doItemStacksMatch(stackA, stackB, false, false);
    }

    public static boolean doItemStacksMatch(ItemStack stackA, ItemStack stackB, boolean ignoreDamage, boolean ignoreNBT) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if ((stackA.func_77981_g() || !ignoreDamage) && stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        if (!ignoreNBT && stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
            return false;
        }
        return (ignoreNBT || stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p())) && stackA.areCapsCompatible(stackB);
    }

    public static void dropItemInWorld(World world, ItemStack item, BlockPos pos) {
        InventoryTools.dropItemInWorld(world, item, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void dropItemInWorld(World world, ItemStack item, double x, double y, double z) {
        if (world.field_72995_K) {
            return;
        }
        InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)item);
    }

    public static NBTTagCompound writeInventoryToNBT(IInventory inventory, NBTTagCompound tag) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item.func_190926_b()) continue;
            NBTTagCompound itemTag = item.func_77955_b(new NBTTagCompound());
            itemTag.func_74777_a("slot", (short)i);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("itemList", (NBTBase)itemList);
        return tag;
    }

    public static void readInventoryFromNBT(IInventory inventory, NBTTagCompound tag) {
        NBTTagList itemList = tag.func_150295_c("itemList", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = itemList.func_150305_b(i);
            short slot = itemTag.func_74765_d("slot");
            ItemStack item = new ItemStack(itemTag);
            inventory.func_70299_a((int)slot, item);
        }
    }

    public static NonNullList<ItemStack> compactStackList(NonNullList<ItemStack> in) {
        ItemQuantityMap map = new ItemQuantityMap();
        for (ItemStack stack : in) {
            map.addCount(stack, stack.func_190916_E());
        }
        return map.getItems();
    }

    public static void mergeItemStacks(NonNullList<ItemStack> stacks, NonNullList<ItemStack> stacksToMerge) {
        for (ItemStack stackToMerge : stacksToMerge) {
            if (stackToMerge.func_190926_b()) continue;
            for (ItemStack stack : stacks) {
                if (stack.func_190916_E() >= stack.func_77976_d() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackToMerge, (ItemStack)stack)) continue;
                int count = Math.min(stack.func_77976_d() - stack.func_190916_E(), stackToMerge.func_190916_E());
                stack.func_190917_f(count);
                stackToMerge.func_190918_g(count);
                if (!stackToMerge.func_190926_b()) continue;
                break;
            }
            if (stackToMerge.func_190926_b()) continue;
            stacks.add((Object)stackToMerge);
        }
    }

    public static void dropItemsInWorld(World world, IInventory inventory, BlockPos pos) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            InventoryTools.dropItemInWorld(world, inventory.func_70301_a(slot), pos);
        }
    }

    public static void dropItemsInWorld(World world, IItemHandler handler, BlockPos pos) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            InventoryTools.dropItemInWorld(world, handler.getStackInSlot(slot), pos);
        }
    }

    public static void dropItemsInWorld(World world, IItemHandler handler, double x, double y, double z) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            InventoryTools.dropItemInWorld(world, handler.getStackInSlot(slot), x, y, z);
        }
    }

    public static void dropItemsInWorld(World world, NonNullList<ItemStack> stacks, BlockPos pos) {
        for (ItemStack stack : stacks) {
            InventoryTools.dropItemInWorld(world, stack, pos);
        }
    }

    public static NonNullList<ItemStack> getItems(IItemHandler handler) {
        NonNullList ret = NonNullList.func_191196_a();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack slotStack = handler.getStackInSlot(slot);
            if (slotStack.func_190926_b()) continue;
            ret.add((Object)slotStack);
        }
        return ret;
    }

    public static NonNullList<ItemStack> removeItems(NonNullList<ItemStack> stacks, NonNullList<ItemStack> stacksToRemove) {
        return stacks.stream().filter(s -> stacksToRemove.stream().noneMatch(r -> InventoryTools.doItemStacksMatch(s, r))).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    public static NonNullList<ItemStack> removeItems(IItemHandler handler, NonNullList<ItemStack> stacks) {
        return InventoryTools.removeItems(handler, stacks, false);
    }

    public static NonNullList<ItemStack> removeItems(IItemHandler handler, NonNullList<ItemStack> stacks, boolean simulate) {
        NonNullList extractedItems = NonNullList.func_191196_a();
        if (simulate) {
            handler = InventoryTools.cloneItemHandler(handler);
        }
        for (ItemStack stack : stacks) {
            ItemStack extracted = InventoryTools.removeItem(handler, stack, false);
            if (extracted.func_190926_b()) continue;
            extractedItems.add((Object)extracted);
        }
        return extractedItems;
    }

    private static ItemStack removeItem(IItemHandler handler, ItemStack stack, boolean simulate) {
        ItemStack slotStack;
        ItemStack extracted = ItemStack.field_190927_a;
        for (int slot = 0; !(slot >= handler.getSlots() || InventoryTools.doItemStacksMatchRelaxed(stack, slotStack = handler.getStackInSlot(slot)) && (extracted = handler.extractItem(slot, stack.func_190916_E(), simulate)).func_190916_E() == stack.func_190916_E()); ++slot) {
        }
        return extracted;
    }

    public static ItemStack removeItem(NonNullList<ItemStack> stacks, Predicate<ItemStack> filter, int quantity) {
        return InventoryTools.removeItem(stacks, filter, quantity, false);
    }

    public static ItemStack removeItem(NonNullList<ItemStack> stacks, Predicate<ItemStack> filter, int quantity, boolean simulate) {
        Iterator<ItemStack> it = simulate ? InventoryTools.copyStacks(stacks).iterator() : stacks.iterator();
        ItemStack stackToReturn = ItemStack.field_190927_a;
        int removed = 0;
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (!filter.test(stack)) continue;
            if (stack.func_77976_d() < quantity) {
                throw new UnsupportedOperationException("Not supported for quantity greater than max stack size");
            }
            int toRemove = Math.min(quantity - removed, stack.func_190916_E());
            removed += toRemove;
            if (stackToReturn.func_190926_b()) {
                stackToReturn = stack.func_77946_l();
            }
            stack.func_190918_g(toRemove);
            stackToReturn.func_190920_e(removed);
            if (stack.func_190926_b()) {
                it.remove();
            }
            if (quantity - removed > 0) continue;
            return stackToReturn;
        }
        return stackToReturn;
    }

    public static List<ItemStack> copyStacks(List<ItemStack> stacks) {
        return (List)stacks.stream().map(ItemStack::func_77946_l).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    public static boolean isInventory(TileEntity tileEntity) {
        return tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public static void generateLootFor(World world, IItemHandler inventory, Random rng, int rolls) {
        InventoryTools.generateLootFor(world, null, inventory, rng, LootTableList.field_186422_d, rolls);
    }

    public static void generateLootFor(World world, @Nullable EntityPlayer player, IItemHandler inventory, Random rng, ResourceLocation lootTableName, int rolls) {
        LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
        LootTable lootTable = world.func_184146_ak().func_186521_a(lootTableName);
        if (player != null) {
            builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
        }
        LootContext lootContext = builder.func_186471_a();
        NonNullList loot = NonNullList.func_191196_a();
        for (int i = 0; i < rolls; ++i) {
            InventoryTools.mergeItemStacks((NonNullList<ItemStack>)loot, InventoryTools.toNonNullList(lootTable.func_186462_a(rng, lootContext)));
        }
        List<Integer> randomSlots = InventoryTools.getEmptySlotsRandomized(inventory, rng);
        InventoryTools.shuffleItems((NonNullList<ItemStack>)loot, randomSlots.size(), rng);
        for (ItemStack itemstack : loot) {
            if (randomSlots.isEmpty()) {
                AncientWarfareCore.LOG.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.func_190926_b()) continue;
            inventory.insertItem(randomSlots.remove(randomSlots.size() - 1).intValue(), itemstack, false);
        }
    }

    public static void emptyInventory(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            itemHandler.extractItem(slot, itemHandler.getStackInSlot(slot).func_190916_E(), false);
        }
    }

    public static Optional<IItemHandler> getItemHandlerFrom(ICapabilityProvider provider, @Nullable EnumFacing side) {
        return provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) ? Optional.ofNullable(provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) : Optional.empty();
    }

    public static List<Integer> getEmptySlotsRandomized(IItemHandler inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    private static void shuffleItems(NonNullList<ItemStack> stacks, int numberOfSlots, Random rand) {
        numberOfSlots -= stacks.size();
        int MIN_SIZE_TO_SPLIT = 3;
        List splittableStacks = stacks.stream().filter(s -> s.func_190916_E() >= MIN_SIZE_TO_SPLIT).collect(Collectors.toList());
        while (numberOfSlots > 0 && !splittableStacks.isEmpty()) {
            int slot = rand.nextInt(splittableStacks.size());
            ItemStack stack = (ItemStack)splittableStacks.get(slot);
            int splitCount = MathHelper.func_76136_a((Random)rand, (int)1, (int)(stack.func_190916_E() / 2));
            ItemStack splitStack = stack.func_77979_a(splitCount);
            if (stack.func_190916_E() < MIN_SIZE_TO_SPLIT) {
                splittableStacks.remove(slot);
            }
            if (splitStack.func_190916_E() >= MIN_SIZE_TO_SPLIT) {
                splittableStacks.add(splitStack);
            }
            stacks.add((Object)splitStack);
            --numberOfSlots;
        }
        Collections.shuffle(stacks, rand);
    }

    public static void insertOrDropItem(IItemHandler handler, ItemStack stack, World world, BlockPos pos) {
        ItemStack remaining = InventoryTools.insertItem(handler, stack, false);
        if (!remaining.func_190926_b()) {
            InventoryTools.dropItemInWorld(world, stack, pos);
        }
    }

    public static void insertOrDropItems(IItemHandler handler, List<ItemStack> stacks, World world, BlockPos pos) {
        for (ItemStack stack : stacks) {
            InventoryTools.insertOrDropItem(handler, stack, world, pos);
        }
    }

    public static NonNullList<ItemStack> toNonNullList(List<ItemStack> stacks) {
        NonNullList ret = NonNullList.func_191196_a();
        for (ItemStack stack : stacks) {
            Validate.notNull((Object)stack);
            ret.add((Object)stack);
        }
        return ret;
    }

    public static Stream<ItemStack> stream(IItemHandler handler) {
        return StreamSupport.stream(InventoryTools.getIterator(handler).spliterator(), false);
    }

    public static Iterable<ItemStack> getIterator(final IItemHandler handler) {
        return () -> new Iterator<ItemStack>(){
            private int currentSlot = 0;

            @Override
            public boolean hasNext() {
                return this.currentSlot < handler.getSlots();
            }

            @Override
            public ItemStack next() {
                if (this.currentSlot < 0 || this.currentSlot >= handler.getSlots()) {
                    throw new NoSuchElementException();
                }
                return handler.getStackInSlot(this.currentSlot++);
            }
        };
    }

    public static final class ComparatorItemStack
    implements Comparator<ItemStack> {
        private SortOrder sortOrder;
        private SortType sortType;

        public ComparatorItemStack(SortType type, SortOrder order) {
            this.sortOrder = order;
            this.sortType = type;
        }

        public void setSortOrder(SortOrder order) {
            this.sortOrder = order;
        }

        public void setSortType(SortType type) {
            this.sortType = type;
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            int result = this.sortType.compare(o1, o2);
            if (result == 0) {
                return 0;
            }
            return (result > 0 ? 1 : -1) * this.sortOrder.mult;
        }

        public static enum SortOrder {
            ASCENDING(-1),
            DESCENDING(1);

            int mult;

            private SortOrder(int mult) {
                this.mult = mult;
            }
        }

        public static enum SortType {
            QUANTITY("sort_type_quantity"){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    int r = o1.func_190916_E() - o2.func_190916_E();
                    if (r == 0) {
                        return super.compare(o1, o2);
                    }
                    return r;
                }
            }
            ,
            NAME("sort_type_name"){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    int r = o1.func_82833_r().compareTo(o2.func_82833_r());
                    if (r == 0) {
                        return super.compare(o1, o2);
                    }
                    return r;
                }
            }
            ,
            DAMAGE("sort_type_damage");

            public final String unlocalizedName;

            private SortType(String unlocalizedName) {
                this.unlocalizedName = unlocalizedName;
            }

            public SortType next() {
                if (this == QUANTITY) {
                    return NAME;
                }
                if (this == NAME) {
                    return DAMAGE;
                }
                return QUANTITY;
            }

            public String toString() {
                return this.unlocalizedName;
            }

            public int compare(ItemStack o1, ItemStack o2) {
                int itemComparison = o1.func_77973_b().getRegistryName().toString().compareTo(o2.func_77973_b().getRegistryName().toString());
                if (itemComparison != 0) {
                    return itemComparison;
                }
                if (o1.func_77952_i() != o2.func_77952_i()) {
                    return Integer.compare(o1.func_77952_i(), o2.func_77952_i());
                }
                if (o1.func_77942_o()) {
                    if (o2.func_77942_o()) {
                        return Integer.compare(o1.func_77978_p().hashCode(), o2.func_77978_p().hashCode());
                    }
                    return 1;
                }
                if (o2.func_77942_o()) {
                    return -1;
                }
                return 0;
            }
        }
    }
}

