/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityTools {
    private EntityTools() {
    }

    @Nullable
    public static EnumHand getHandHoldingItem(EntityLivingBase entity, Item item) {
        if (entity.func_184614_ca().func_77973_b() == item) {
            return EnumHand.MAIN_HAND;
        }
        if (entity.func_184592_cb().func_77973_b() == item) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    public static ItemStack getItemFromEitherHand(EntityPlayer player, Class ... itemClasses) {
        for (Class itemClass : itemClasses) {
            if (itemClass.isInstance(player.func_184614_ca().func_77973_b())) {
                return player.func_184614_ca();
            }
            if (!itemClass.isInstance(player.func_184592_cb().func_77973_b())) continue;
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public static String getUnlocName(String resourceLocation) {
        return EntityTools.getUnlocName(new ResourceLocation(resourceLocation));
    }

    public static String getUnlocName(ResourceLocation registryName) {
        EntityEntry e = (EntityEntry)ForgeRegistries.ENTITIES.getValue(registryName);
        return "entity." + (registryName.func_110624_b().equals("ancientwarfarenpc") ? "ancientwarfarenpc." : "") + e.getName() + ".name";
    }

    public static <T extends Entity> List<T> getEntitiesWithinBounds(World world, Class<? extends T> clazz, BlockPos p1, BlockPos p2) {
        AxisAlignedBB bb = new AxisAlignedBB(p1, p2.func_177982_a(1, 1, 1));
        return world.func_72872_a(clazz, bb);
    }
}

